/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data;

import java.util.Arrays;
import java.util.Random;
import lombok.Generated;

public final class Median {
    private static final Random RND = new Random(0L);

    private static int getPivot(int[] nums, int start, int end) {
        int[] medians = new int[(end - start) / 5];
        int i = start;
        int k = 0;
        for (int j = start + 5; j < end; j += 5) {
            Arrays.sort(nums, i, j);
            medians[k++] = nums[i + 2];
            i = j;
        }
        return Median.kthSmallest(medians, 0, medians.length, medians.length / 2);
    }

    static int arrangeByPivot(int[] nums, int start, int end, int pivot) {
        int b = start;
        int e = end - 1;
        int i = start;
        while (i <= e) {
            int temp;
            if (nums[i] < pivot) {
                temp = nums[i];
                nums[i] = nums[b];
                nums[b] = temp;
                ++b;
                ++i;
                continue;
            }
            if (nums[i] == pivot) {
                ++i;
                continue;
            }
            temp = nums[i];
            nums[i] = nums[e];
            nums[e] = temp;
            --e;
        }
        return b;
    }

    private static int kthSmallest(int[] nums, int start, int end, int elm) {
        if (end - start <= 5) {
            Arrays.sort(nums, start, end);
            return nums[elm];
        }
        int pivot = Median.getPivot(nums, start, end);
        int loc = Median.arrangeByPivot(nums, start, end, pivot);
        if (loc == elm) {
            return nums[loc];
        }
        if (loc > elm) {
            return Median.kthSmallest(nums, start, loc, elm);
        }
        return Median.kthSmallest(nums, loc + 1, end, elm);
    }

    public static int findKthLargest(int[] nums, int k) {
        return Median.kthSmallest(nums, 0, nums.length, nums.length - k - 1);
    }

    public static int findKthSmallest(int[] nums, int k) {
        if (k < 0 || k >= nums.length) {
            throw new IllegalArgumentException();
        }
        return Median.kthSmallest(nums, 0, nums.length, k);
    }

    private static double getPivot(double[] nums, int start, int end) {
        double[] medians = new double[(end - start) / 5];
        int i = start;
        int k = 0;
        for (int j = start + 5; j < end; j += 5) {
            Arrays.sort(nums, i, j);
            medians[k++] = nums[i + 2];
            i = j;
        }
        return Median.kthSmallest(medians, 0, medians.length, medians.length / 2);
    }

    private static int arrangeByPivot(double[] nums, int start, int end, double pivot) {
        int b = start;
        int i = start;
        int e = end;
        while (i < e) {
            double temp;
            if (nums[i] < pivot) {
                temp = nums[i];
                nums[i] = nums[b];
                nums[b] = temp;
                ++b;
                ++i;
                continue;
            }
            if (nums[i] == pivot) {
                ++i;
                continue;
            }
            temp = nums[i];
            nums[i] = nums[--e];
            nums[e] = temp;
        }
        return b;
    }

    private static double kthSmallest(double[] nums, int start, int end, int elm) {
        if (end - start <= 5) {
            Arrays.sort(nums, start, end);
            return nums[elm];
        }
        double pivot = Median.getPivot(nums, start, end);
        int loc = Median.arrangeByPivot(nums, start, end, pivot);
        if (loc == elm) {
            return nums[loc];
        }
        if (loc > elm) {
            return Median.kthSmallest(nums, start, loc, elm);
        }
        return Median.kthSmallest(nums, loc + 1, end, elm);
    }

    public static double findKthLargest(double[] nums, int k) {
        return Median.kthSmallest(nums, 0, nums.length, nums.length - k - 1);
    }

    public static double findKthSmallest(double[] nums, int k) {
        if (k < 0 || k >= nums.length) {
            throw new IllegalArgumentException();
        }
        return Median.kthSmallest(nums, 0, nums.length, k);
    }

    public static int kselection(int[] arr, int low, int high, int k) {
        int pivot = arr[RND.nextInt(low, high)];
        int partition_sorting_value = Median.arrangeByPivot(arr, low, high, pivot);
        if (partition_sorting_value == k) {
            return arr[partition_sorting_value];
        }
        if (partition_sorting_value < k) {
            return Median.kselection(arr, partition_sorting_value + 1, high, k);
        }
        return Median.kselection(arr, low, partition_sorting_value, k);
    }

    public static int kselection(int[] arr, int k) {
        return Median.kselection(arr, 0, arr.length, k);
    }

    public static double kselection(double[] arr, int low, int high, int k) {
        double pivot = arr[RND.nextInt(low, high)];
        int partition_sorting_value = Median.arrangeByPivot(arr, low, high, pivot);
        if (partition_sorting_value == k) {
            return arr[partition_sorting_value];
        }
        if (partition_sorting_value < k) {
            return Median.kselection(arr, partition_sorting_value + 1, high, k);
        }
        return Median.kselection(arr, low, partition_sorting_value, k);
    }

    public static double kselection(double[] arr, int k) {
        return Median.kselection(arr, 0, arr.length, k);
    }

    @Generated
    private Median() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

