/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data.interpolation;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoublesMath;
import jdplus.toolkit.base.api.util.IntList;
import jdplus.toolkit.base.core.data.interpolation.DataInterpolator;

public class ConstInterpolator
implements DataInterpolator {
    public static final double BIGVALUE = 1.0E10;
    public final double value;

    public ConstInterpolator() {
        this.value = Double.NaN;
    }

    public ConstInterpolator(double val) {
        this.value = val;
    }

    @Override
    public double[] interpolate(DoubleSeq data, IntList missingpos) {
        double[] ndata = data.toArray();
        double nval = this.value;
        if (!Double.isFinite(nval)) {
            nval = DoublesMath.averageWithMissing((DoubleSeq)data);
        }
        for (int i = 0; i < ndata.length; ++i) {
            if (Double.isFinite(ndata[i])) continue;
            missingpos.add(i);
            ndata[i] = nval;
        }
        return ndata;
    }
}

