/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.functions;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.FunctionMinimizer;
import jdplus.toolkit.base.core.math.functions.IFunction;
import jdplus.toolkit.base.core.math.functions.IFunctionPoint;
import jdplus.toolkit.base.core.math.functions.NumericalDerivatives;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;

public class GridSearch
implements FunctionMinimizer {
    private final double epsilon;
    private final double precision;
    private final double lbound;
    private final double ubound;
    private final int m_nsteps0;
    private final int m_nsteps1;
    private final int maxIter;
    private double a;
    private double b;
    private double dfn;
    private double va;
    private double vb;
    private double curX;
    private IFunction fn;
    private IFunctionPoint m_ftry;
    private int niter;

    public static GridSearchBuilder builder() {
        return new GridSearchBuilder();
    }

    private GridSearch(GridSearchBuilder builder) {
        this.epsilon = builder.fnPrecision;
        this.precision = builder.paramPrecision;
        this.lbound = builder.lbound;
        this.ubound = builder.ubound;
        this.m_nsteps0 = builder.initialGridCount;
        this.m_nsteps1 = builder.gridCount;
        this.maxIter = builder.maxIter;
    }

    private void clear() {
        this.m_ftry = null;
        this.fn = null;
        this.dfn = Double.MAX_VALUE;
        this.va = Double.NaN;
        this.vb = Double.NaN;
        this.curX = Double.NaN;
    }

    @Override
    public FastMatrix curvatureAtMinimum() {
        FastMatrix h = FastMatrix.square(1);
        new NumericalDerivatives(this.m_ftry, false).hessian(h);
        return h;
    }

    @Override
    public DoubleSeq gradientAtMinimum() {
        return new NumericalDerivatives(this.m_ftry, false).gradient();
    }

    public int getGridCount() {
        return this.m_nsteps1;
    }

    public int getInitialGridCount() {
        return this.m_nsteps0;
    }

    public double getLBound() {
        return this.lbound;
    }

    @Override
    public IFunctionPoint getResult() {
        return this.m_ftry;
    }

    @Override
    public double getObjective() {
        return this.m_ftry == null ? Double.NaN : this.m_ftry.getValue();
    }

    public double getUBound() {
        return this.ubound;
    }

    private boolean iterate(int nsteps) {
        double step = (this.b - this.a) / (double)nsteps;
        double[] vals = new double[nsteps + 1];
        vals[0] = this.va;
        vals[nsteps] = this.vb;
        for (int i = 1; i < nsteps; ++i) {
            vals[i] = this.evaluate(this.a + (double)i * step);
        }
        double min = Double.MAX_VALUE;
        int imin = -1;
        for (int i = 0; i <= nsteps; ++i) {
            double val = vals[i];
            if (Double.isNaN(val) || !(val < min)) continue;
            imin = i;
            min = val;
        }
        if (imin == -1) {
            return false;
        }
        this.curX = this.a + step * (double)imin;
        if (imin == 0) {
            this.b = this.a + step;
            this.vb = vals[1];
        } else if (imin == nsteps) {
            this.a = this.b - step;
            this.va = vals[nsteps - 1];
        } else {
            this.a += step * (double)(imin - 1);
            this.b = this.a + 2.0 * step;
            this.va = vals[imin - 1];
            this.vb = vals[imin + 1];
        }
        this.dfn = Math.abs(this.va - this.vb);
        return true;
    }

    @Override
    public boolean minimize(IFunctionPoint start) {
        this.clear();
        IFunction function = start.getFunction();
        if (function.getDomain().getDim() != 1 || this.lbound >= this.ubound || this.m_nsteps0 < 3 || this.m_nsteps1 < 3) {
            return false;
        }
        this.fn = function;
        this.a = this.lbound;
        this.b = this.ubound;
        this.va = this.evaluate(this.a);
        this.vb = this.evaluate(this.b);
        this.niter = 0;
        while (this.niter++ < this.maxIter && this.b - this.a > this.precision && (Double.isNaN(this.dfn) || this.dfn > this.epsilon)) {
            if (this.iterate(this.niter == 1 ? this.m_nsteps0 : this.m_nsteps1)) continue;
            return false;
        }
        this.m_ftry = this.fn.evaluate((DoubleSeq)DataBlock.of(new double[]{this.curX}));
        return true;
    }

    private double evaluate(double x) {
        try {
            IFunctionPoint fx = this.fn.evaluate((DoubleSeq)DataBlock.of(new double[]{x}));
            return fx.getValue();
        }
        catch (Exception err) {
            return Double.NaN;
        }
    }

    @Override
    public int getIterationsCount() {
        return this.niter;
    }

    public static class GridSearchBuilder {
        private double fnPrecision = 1.0E-7;
        private double paramPrecision = 1.0E-6;
        private int maxIter = 100;
        private int gridCount = 4;
        private int initialGridCount = 30;
        private double lbound = -1.0;
        private double ubound = 1.0;

        private GridSearchBuilder() {
        }

        public GridSearchBuilder functionPrecision(double eps) {
            this.fnPrecision = eps;
            return this;
        }

        public GridSearchBuilder parametersPrecision(double eps) {
            this.paramPrecision = eps;
            return this;
        }

        public GridSearchBuilder maxIter(int niter) {
            this.maxIter = niter;
            return this;
        }

        public GridSearchBuilder initialGridCount(int n) {
            this.initialGridCount = n;
            return this;
        }

        public GridSearchBuilder gridCount(int n) {
            this.gridCount = n;
            return this;
        }

        public GridSearchBuilder bounds(double l, double u) {
            this.lbound = l;
            this.ubound = u;
            return this;
        }

        public GridSearch build() {
            return new GridSearch(this);
        }
    }
}

