/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import java.util.Arrays;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.DataPointer;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.IVectorTransformation;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class HouseholderReflection
implements IVectorTransformation {
    private final double alpha;
    private final double beta;
    private final double[] px;

    public static HouseholderReflection of(DataBlock v) {
        return new HouseholderReflection(v.toArray());
    }

    public static HouseholderReflection of(DataBlock v, boolean apply) {
        HouseholderReflection hr = new HouseholderReflection(v.toArray());
        if (apply) {
            v.set(0.0);
            v.set(0, hr.alpha);
        }
        return hr;
    }

    public double x0() {
        return this.px[0];
    }

    public DataPointer v() {
        return DataPointer.of(this.px, 1);
    }

    public DataPointer x() {
        return DataPointer.of(this.px, 0);
    }

    HouseholderReflection(double[] w) {
        this.px = w;
        int m = w.length - 1;
        switch (m) {
            case -1: {
                this.alpha = 0.0;
                this.beta = 0.0;
                break;
            }
            case 0: {
                this.alpha = Math.abs(this.px[0]);
                this.beta = 0.0;
                break;
            }
            default: {
                double x0 = this.px[0];
                DataPointer v = this.v();
                DataPointer x = this.x();
                if (v.test(m, q -> q == 0.0)) {
                    this.alpha = Math.abs(x0);
                    this.beta = 0.0;
                    break;
                }
                double nrm = x.norm2(this.px.length);
                double eps = Constants.getEpsilon();
                double safemin = Constants.getSafeMin() / eps;
                int k = 0;
                if (nrm < safemin) {
                    double rsafemin = 1.0 / safemin;
                    do {
                        v.mul(m, rsafemin);
                        x0 *= rsafemin;
                    } while ((nrm *= rsafemin) < safemin && ++k < 4);
                    nrm = x.norm2(this.px.length);
                }
                if (x0 < 0.0) {
                    nrm = -nrm;
                }
                for (int j = 0; j < k; ++j) {
                    nrm *= safemin;
                }
                this.beta = nrm / (nrm + x0);
                this.v().div(m, nrm);
                this.alpha = -nrm;
            }
        }
    }

    void lapply(FastMatrix M) {
        if (this.beta == 0.0) {
            return;
        }
        int nc = M.getColumnsCount();
        int lda = M.getColumnIncrement();
        int m = this.px.length - 1;
        int mstart = M.getStartPosition();
        double[] pm = M.getStorage();
        int k = 0;
        int im = mstart;
        while (k < nc) {
            double s = pm[im] / this.beta;
            int i = 1;
            int j = im + 1;
            while (i < this.px.length) {
                s += pm[j] * this.px[i];
                ++i;
                ++j;
            }
            if (s != 0.0) {
                int n = im;
                pm[n] = pm[n] - s;
                s *= -this.beta;
                j = im + 1;
                for (i = 1; i < this.px.length; ++i) {
                    int n2 = j++;
                    pm[n2] = pm[n2] + s * this.px[i];
                }
            }
            ++k;
            im += lda;
        }
    }

    @Override
    public void transform(DataBlock y) {
        if (this.beta == 0.0) {
            return;
        }
        double[] py = y.getStorage();
        int inc = y.getIncrement();
        int im = y.getStartPosition();
        double s = py[im] / this.beta;
        int i = 1;
        int j = im + inc;
        while (i < this.px.length) {
            s += py[j] * this.px[i];
            ++i;
            j += inc;
        }
        if (s != 0.0) {
            int n = im;
            py[n] = py[n] - s;
            s *= -this.beta;
            i = 1;
            j = im + inc;
            while (i < this.px.length) {
                int n2 = j;
                py[n2] = py[n2] + s * this.px[i];
                ++i;
                j += inc;
            }
        }
    }

    @Generated
    public double getAlpha() {
        return this.alpha;
    }

    @Generated
    public double getBeta() {
        return this.beta;
    }

    @Generated
    public double[] getPx() {
        return this.px;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HouseholderReflection)) {
            return false;
        }
        HouseholderReflection other = (HouseholderReflection)o;
        if (Double.compare(this.getAlpha(), other.getAlpha()) != 0) {
            return false;
        }
        if (Double.compare(this.getBeta(), other.getBeta()) != 0) {
            return false;
        }
        return Arrays.equals(this.getPx(), other.getPx());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $alpha = Double.doubleToLongBits(this.getAlpha());
        result = result * 59 + (int)($alpha >>> 32 ^ $alpha);
        long $beta = Double.doubleToLongBits(this.getBeta());
        result = result * 59 + (int)($beta >>> 32 ^ $beta);
        result = result * 59 + Arrays.hashCode(this.getPx());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "HouseholderReflection(alpha=" + this.getAlpha() + ", beta=" + this.getBeta() + ", px=" + Arrays.toString(this.getPx()) + ")";
    }
}

