/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.decomposition.IVectorTransformation;

public class HyperbolicRotation
implements IVectorTransformation {
    static final double XEPS = 1.0E-12;
    private final int lentry;
    private final int rentry;
    private final double d;
    private final double rho;
    private final double a;
    private final double b;

    public static HyperbolicRotation of(DataBlock vector, int entry) {
        return HyperbolicRotation.of(vector, 0, entry);
    }

    public static HyperbolicRotation of(DataBlock vector, int lentry, int rentry) {
        HyperbolicRotation r;
        double a = vector.get(lentry);
        double b = vector.get(rentry);
        double ra = Math.abs(a);
        double rb = Math.abs(b);
        if (rb < 1.0E-12) {
            vector.set(rentry, 0.0);
            return null;
        }
        if (Math.abs(ra - rb) < 1.0E-12) {
            r = new HyperbolicRotation(lentry, rentry, a == b);
            vector.set(lentry, 0.0);
            vector.set(rentry, 0.0);
        } else {
            r = new HyperbolicRotation(a, lentry, b, rentry);
            if (Math.abs(a) > Math.abs(b)) {
                vector.set(lentry, a * r.d);
                vector.set(rentry, 0.0);
            } else {
                vector.set(rentry, b * r.d);
                vector.set(lentry, 0.0);
            }
        }
        return r;
    }

    private HyperbolicRotation(int lentry, int rentry, boolean same) {
        this.lentry = lentry;
        this.rentry = rentry;
        this.rho = same ? 1.0 : -1.0;
        this.a = 0.0;
        this.b = 0.0;
        this.d = 1.0;
    }

    private HyperbolicRotation(double a, int lentry, double b, int rentry) {
        this.lentry = lentry;
        this.rentry = rentry;
        if (a == 0.0 || b == 0.0) {
            this.rho = 0.0;
            this.d = 1.0;
            this.b = 0.0;
            this.a = 1.0;
        } else if (Math.abs(a) > Math.abs(b)) {
            this.rho = b / a;
            double q = Math.sqrt(1.0 - this.rho * this.rho);
            this.d = a < 0.0 ? -q : q;
            this.a = a;
            this.b = b;
        } else {
            this.rho = a / b;
            double q = Math.sqrt(1.0 - this.rho * this.rho);
            this.d = b < 0.0 ? -q : q;
            this.a = b;
            this.b = a;
        }
    }

    @Override
    public void transform(DataBlock vector) {
        double l = vector.get(this.lentry);
        double r = vector.get(this.rentry);
        if (this.d == 0.0) {
            if (this.rho == 1.0) {
                double s = l - r;
                vector.set(this.lentry, s);
                vector.set(this.rentry, -s);
            } else {
                double s = l + r;
                vector.set(this.lentry, s);
                vector.set(this.rentry, s);
            }
        } else {
            this.H(vector);
        }
    }

    private void H(DataBlock vector) {
        double e;
        double z;
        double ry;
        double x = vector.get(this.lentry);
        double y = vector.get(this.rentry);
        int l = this.lentry;
        int r = this.rentry;
        double rx = Math.abs(x);
        if (rx < (ry = Math.abs(y))) {
            double t = rx;
            rx = ry;
            ry = t;
            t = x;
            x = y;
            y = t;
            int it = l;
            l = r;
            r = it;
        }
        if ((z = this.rho * y / x) < 0.5) {
            e = 1.0 - z;
        } else {
            double d1 = 1.0 - Math.abs(this.rho);
            double d2 = 1.0 - ry / rx;
            e = d1 + d2 - d1 * d2;
        }
        double x1 = Math.abs(this.a) * x * e / Math.sqrt(Math.abs((this.a - this.b) * (this.a + this.b)));
        double y1 = x1 - Math.sqrt(Math.abs((this.a + this.b) / (this.a - this.b))) * (x - y);
        vector.set(l, x1);
        vector.set(r, y1);
    }
}

