/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.LevelShift;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;

class LSFactory
implements RegressionVariableFactory<LevelShift> {
    static LSFactory FACTORY = new LSFactory();

    private LSFactory() {
    }

    @Override
    public boolean fill(LevelShift var, TsPeriod start, FastMatrix m, ProcessingLog log) {
        TsPeriod p = start.withDate(var.getPosition());
        this.fill(var, start.until(p), m.column(0));
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(LevelShift var, D domain, FastMatrix m, ProcessingLog log) {
        this.fill(var, domain.indexOf(var.getPosition()), m.column(0));
        return true;
    }

    private void fill(LevelShift var, int xpos, DataBlock buffer) {
        double Zero = var.isZeroEnded() ? -1.0 : 0.0;
        double One = var.isZeroEnded() ? 0.0 : 1.0;
        int n = buffer.length();
        if (xpos < 0) {
            buffer.set(One);
        } else {
            int lpos;
            int n2 = lpos = xpos >= 0 ? xpos : -xpos;
            if (lpos >= n) {
                buffer.set(Zero);
            } else {
                buffer.range(0, lpos).set(Zero);
                buffer.range(lpos, n).set(One);
            }
        }
    }
}

