/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import java.time.LocalDate;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.calendars.CalendarUtility;
import jdplus.toolkit.base.api.timeseries.regression.StockTradingDays;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;

class StockTDFactory
implements RegressionVariableFactory<StockTradingDays> {
    static StockTDFactory FACTORY = new StockTDFactory();

    private StockTDFactory() {
    }

    @Override
    public boolean fill(StockTradingDays var, TsPeriod start, FastMatrix buffer, ProcessingLog log) {
        int n = buffer.getRowsCount();
        int w = var.getW();
        TsPeriod cur = start;
        for (int i = 0; i < n; ++i) {
            LocalDate d;
            int g;
            int wmax;
            int day;
            LocalDate end = cur.end().toLocalDate();
            cur = cur.next();
            if (w <= 0) {
                int dw = end.getDayOfWeek().getValue();
                int g2 = (dw + w - 1) % 7;
                if (g2 < 0) {
                    g2 += 7;
                }
                if (g2 == 0) {
                    buffer.row(i).set(-1.0);
                    continue;
                }
                buffer.set(i, g2 - 1, 1.0);
                continue;
            }
            int month = end.getMonthValue() - 1;
            int year = end.getYear();
            if (month == 0) {
                month = 12;
                --year;
            }
            if ((day = w) > 28 && day > (wmax = CalendarUtility.getNumberOfDaysByMonth((int)year, (int)month))) {
                day = wmax;
            }
            if ((g = (d = LocalDate.of(year, month, day)).getDayOfWeek().getValue()) == 7) {
                buffer.row(i).set(-1.0);
                continue;
            }
            buffer.set(i, g - 1, 1.0);
        }
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(StockTradingDays var, D domain, FastMatrix buffer, ProcessingLog log) {
        throw new UnsupportedOperationException("Not supported.");
    }
}

