/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ucarima;

import jdplus.toolkit.base.core.arima.ArimaModel;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.linearsystem.LinearSystemSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.ucarima.AllSelector;
import jdplus.toolkit.base.core.ucarima.IRootSelector;
import jdplus.toolkit.base.core.ucarima.SimpleModelDecomposer;

public class RootDecomposer
extends SimpleModelDecomposer {
    private IRootSelector m_selector;
    private BackFilter m_sur;
    private BackFilter m_nur;
    private BackFilter m_sar;
    private BackFilter m_nar;
    private SymmetricFilter m_sma;
    private SymmetricFilter m_sfds;
    private SymmetricFilter m_sfdn;

    public RootDecomposer() {
        this.m_selector = new AllSelector();
    }

    public RootDecomposer(IRootSelector sel) {
        this.m_selector = sel;
    }

    @Override
    protected void calc() {
        int i;
        int i2;
        int k;
        int j;
        int qn;
        if (this.model.isNull()) {
            this.signal = ArimaModel.NULL;
            this.noise = ArimaModel.NULL;
            return;
        }
        if (this.m_selector == null) {
            this.signal = ArimaModel.NULL;
            this.noise = this.model;
            return;
        }
        this.splitRoots();
        this.m_sma = this.model.symmetricMa();
        this.m_sfds = SymmetricFilter.convolutionOf(this.m_sur.times(this.m_sar));
        this.m_sfdn = SymmetricFilter.convolutionOf(this.m_nur.times(this.m_nar));
        if (!this.checkSpecialCases()) {
            return;
        }
        double[] n = this.m_sma.coefficientsAsPolynomial().toArray();
        double[] ds = this.m_sfds.coefficientsAsPolynomial().toArray();
        double[] dn = this.m_sfdn == null ? Polynomial.ONE.toArray() : this.m_sfdn.coefficientsAsPolynomial().toArray();
        int q = n.length - 1;
        int p = ds.length + dn.length - 2;
        int ps = ds.length - 1;
        int pn = dn.length - 1;
        int qs = ps > 0 ? ps - 1 : 0;
        int n2 = qn = pn > 0 ? pn - 1 : 0;
        if (q >= p) {
            qn = q - ps;
        }
        int xs = qs + 1;
        int xn = qn + 1;
        int x = xs + xn;
        FastMatrix m = FastMatrix.square(x);
        n[0] = n[0] / 2.0;
        ds[0] = ds[0] / 2.0;
        dn[0] = dn[0] / 2.0;
        for (j = 0; j <= qs; ++j) {
            for (k = 0; k <= pn; ++k) {
                m.set(j + k, j, dn[k]);
            }
        }
        for (j = 0; j <= qn; ++j) {
            for (k = 0; k <= ps; ++k) {
                m.set(j + k, j + xs, ds[k]);
            }
        }
        for (j = 0; j <= qs; ++j) {
            for (k = 0; k <= pn; ++k) {
                i2 = j - k;
                if (i2 < 0) {
                    i2 = -i2;
                }
                m.set(i2, j, m.get(i2, j) + dn[k]);
            }
        }
        for (j = 0; j <= qn; ++j) {
            for (k = 0; k <= ps; ++k) {
                i2 = j - k;
                if (i2 < 0) {
                    i2 = -i2;
                }
                m.set(i2, j + xs, m.get(i2, j + xs) + ds[k]);
            }
        }
        double[] sq = new double[x];
        for (int i3 = 0; i3 <= q; ++i3) {
            sq[i3] = n[i3];
        }
        LinearSystemSolver.robustSolver().solve(m, DataBlock.of(sq));
        double[] rcs = new double[xs];
        double[] rcn = new double[xn];
        for (i = 0; i < rcs.length; ++i) {
            rcs[i] = sq[i];
        }
        for (i = 0; i < rcn.length; ++i) {
            rcn[i] = sq[xs + i];
        }
        rcs[0] = rcs[0] * 2.0;
        rcn[0] = rcn[0] * 2.0;
        SymmetricFilter sma = SymmetricFilter.ofInternal(rcs);
        SymmetricFilter nma = SymmetricFilter.ofInternal(rcn);
        this.signal = new ArimaModel(this.m_sar, this.m_sur, sma);
        this.noise = new ArimaModel(this.m_nar, this.m_nur, nma);
    }

    private boolean checkSpecialCases() {
        if (this.m_sfds.length() <= 1) {
            this.signal = new ArimaModel(BackFilter.ONE, this.m_sur, BackFilter.ONE, 0.0);
            this.noise = new ArimaModel(this.m_nar, this.m_nur, this.m_sma);
            return false;
        }
        return true;
    }

    @Override
    protected void clear() {
        super.clear();
        this.m_sur = null;
        this.m_nur = null;
        this.m_sar = null;
        this.m_nar = null;
        this.m_sfds = null;
        this.m_sfdn = null;
        this.m_sma = null;
    }

    public IRootSelector getSelector() {
        return this.m_selector;
    }

    public void setSelector(IRootSelector value) {
        this.m_selector = value;
        this.clear();
    }

    private void splitRoots() {
        this.m_selector.select(this.model.getStationaryAr().asPolynomial());
        this.m_sar = this.m_selector.getSelection() != null ? new BackFilter(this.m_selector.getSelection()) : BackFilter.ONE;
        this.m_nar = this.m_selector.getOutofSelection() != null ? new BackFilter(this.m_selector.getOutofSelection()) : BackFilter.ONE;
        this.m_selector.selectUnitRoots(this.model.getNonStationaryAr().asPolynomial());
        this.m_sur = this.m_selector.getSelection() != null ? new BackFilter(this.m_selector.getSelection()) : BackFilter.ONE;
        this.m_nur = this.m_selector.getOutofSelection() != null ? new BackFilter(this.m_selector.getOutofSelection()) : BackFilter.ONE;
    }
}

