## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library(leaflet)
library(leafsync)

## ----setup--------------------------------------------------------------------
library(smartmap)

## ----echo = FALSE-------------------------------------------------------------
cities <- data.frame(
  city = c("Bregenz", "Eisenstadt", "Wiener Neustadt",
    "Graz", "Klagenfurt", "Linz", "Salzburg", "Innsbruck",
    "Vienna"),
  LaTituDE = c(47.51669707, 47.83329908, 47.81598187,
    47.0777582, 46.62034426, 48.31923281, 47.81047833,
    47.28040733, 48.20001528),
  lng = c(9.766701588, 16.53329747, 16.24995357,
    15.41000484, 14.3100203, 14.28878129, 13.0400203,
    11.4099906, 16.36663896),
  pop = c(26928, 13165, 60621.5, 242780, 88588, 265161.5,
    178274, 133840.5, 2065500),
  country = c("Austria", "Austria", "Austria", "Austria",
    "Austria", "Austria", "Austria", "Austria", "Austria"),
  province = c("Vorarlberg", "Burgenland",
    "Niederösterreich", "Steiermark", "Kärnten",
    "Oberösterreich", "Salzburg", "Tirol", "Wien")
)

## ----eval = FALSE-------------------------------------------------------------
# print(cities)
# smap(cities)

## ----out.width = "100%", echo = FALSE-----------------------------------------
print(cities)
smap(cities)

## ----cache = TRUE, out.width = "100%"-----------------------------------------
# disabled url broken
# smap("https://www.naturalearthdata.com/http//www.naturalearthdata.com/download/50m/cultural/ne_50m_admin_0_countries.zip")


## ----eval = FALSE-------------------------------------------------------------
# smap(c(16.422524, 48.185686))
# smap(c(LAT = 48.185686, LoNgItuDE = 16.422524))

## ----out.width = "100%", echo = FALSE-----------------------------------------
smap(c(LAT = 48.185686, LoNgItuDE = 16.422524))

## ----eval=FALSE---------------------------------------------------------------
# library(leaflet)
# lf <- leaflet::leaflet(height=200) %>%
#   leaflet::addCircleMarkers(lng = 16.422524, lat = 48.185686)
# 
# lf
# smap(lf)

## ----echo = FALSE-------------------------------------------------------------
library(leaflet)
lf <- leaflet::leaflet(height=200) %>% 
  leaflet::addCircleMarkers(lng = 16.422524, lat = 48.185686)

leafsync::sync(lf, smap(lf), sync.cursor = FALSE)


## ----eval = FALSE-------------------------------------------------------------
# smap(sf::st_point(c(16.373311, 48.208482)))
# smap(sf::st_sfc(sf::st_point(c(16.373311, 48.208482))))
# smap(sf::st_sf(coords = sf::st_sfc(sf::st_point(c(16.373311, 48.208482))), crs = 4326))

## ----out.width = "100%", echo = FALSE-----------------------------------------
smap(sf::st_sf(coords = sf::st_sfc(sf::st_point(c(16.373311, 48.208482))), crs = 4326))

