/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.alignment;

import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.SiteList;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.PairedDataType;
import dr.evolution.util.Taxon;
import java.util.Iterator;
import java.util.List;

public class PairedSitePatterns
implements SiteList {
    private final SiteList siteList;
    private final PairedDataType dataType;
    protected String id = null;

    public PairedSitePatterns(SiteList siteList) {
        this.siteList = siteList;
        this.dataType = new PairedDataType(siteList.getDataType());
    }

    @Override
    public int getSiteCount() {
        int n = this.siteList.getSiteCount();
        return (n - 1) * n / 2;
    }

    @Override
    public int[] getSitePattern(int n) {
        int n2 = this.siteList.getSiteCount();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                if (n5 == n) {
                    n3 = i;
                    n4 = j;
                    break;
                }
                ++n5;
            }
            if (n5 == n) break;
        }
        int[] nArray = new int[this.siteList.getTaxonCount()];
        int[] nArray2 = this.siteList.getSitePattern(n3);
        int[] nArray3 = this.siteList.getSitePattern(n4);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.dataType.getState(nArray2[i], nArray3[i]);
        }
        return nArray;
    }

    @Override
    public double[][] getUncertainSitePattern(int n) {
        throw new UnsupportedOperationException("uncertain patterns not implemented yet");
    }

    @Override
    public int getPatternIndex(int n) {
        return n;
    }

    @Override
    public int getState(int n, int n2) {
        return this.getSitePattern(n2)[n];
    }

    @Override
    public double[] getUncertainState(int n, int n2) {
        throw new UnsupportedOperationException("uncertain patterns not implemented yet");
    }

    @Override
    public int getPatternCount() {
        return this.getSiteCount();
    }

    @Override
    public int getStateCount() {
        return this.dataType.getStateCount();
    }

    @Override
    public int getPatternLength() {
        return this.getTaxonCount();
    }

    @Override
    public int[] getPattern(int n) {
        return this.getSitePattern(n);
    }

    @Override
    public double[][] getUncertainPattern(int n) {
        throw new UnsupportedOperationException("uncertain patterns not implemented yet");
    }

    @Override
    public int getPatternState(int n, int n2) {
        return this.getSitePattern(n2)[n];
    }

    @Override
    public double[] getUncertainPatternState(int n, int n2) {
        throw new UnsupportedOperationException("uncertain patterns not implemented yet");
    }

    @Override
    public double getPatternWeight(int n) {
        return 1.0;
    }

    @Override
    public double[] getPatternWeights() {
        double[] dArray = new double[this.getSiteCount()];
        for (int i = 0; i < this.getSiteCount(); ++i) {
            dArray[i] = 1.0;
        }
        return dArray;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public double[] getStateFrequencies() {
        return PatternList.Utils.empiricalStateFrequencies(this);
    }

    @Override
    public boolean areUnique() {
        return false;
    }

    @Override
    public boolean areUncertain() {
        return false;
    }

    @Override
    public int getTaxonCount() {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxonCount();
    }

    @Override
    public Taxon getTaxon(int n) {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxon(n);
    }

    @Override
    public String getTaxonId(int n) {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxonId(n);
    }

    @Override
    public int getTaxonIndex(String string) {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxonIndex(string);
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxonIndex(taxon);
    }

    @Override
    public List<Taxon> asList() {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.asList();
    }

    @Override
    public Iterator<Taxon> iterator() {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.iterator();
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        if (this.siteList == null) {
            throw new RuntimeException("SitePatterns has no alignment");
        }
        return this.siteList.getTaxonAttribute(n, string);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }
}

