/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.simplets;

import ec.benchmarking.DisaggregationData;
import ec.benchmarking.DisaggregationModel;
import ec.benchmarking.ssf.SsfDisaggregation;
import ec.benchmarking.ssf.SsfDisaggregationMapper;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.eco.CoefficientEstimation;
import ec.tstoolkit.eco.DiffuseConcentratedLikelihood;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.realfunctions.GridSearch;
import ec.tstoolkit.maths.realfunctions.IFunction;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import ec.tstoolkit.maths.realfunctions.IFunctionMinimizer;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.ISsqFunction;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionInstance;
import ec.tstoolkit.maths.realfunctions.ProxyMinimizer;
import ec.tstoolkit.maths.realfunctions.SsqNumericalDerivatives;
import ec.tstoolkit.maths.realfunctions.levmar.LevenbergMarquardtMethod;
import ec.tstoolkit.ssf.AkfAlgorithm;
import ec.tstoolkit.ssf.DiffuseFilteringResults;
import ec.tstoolkit.ssf.DisturbanceSmoother;
import ec.tstoolkit.ssf.Filter;
import ec.tstoolkit.ssf.FilteringResults;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ISsfData;
import ec.tstoolkit.ssf.RegSsf;
import ec.tstoolkit.ssf.Smoother;
import ec.tstoolkit.ssf.SmoothingResults;
import ec.tstoolkit.ssf.SsfAlgorithm;
import ec.tstoolkit.ssf.SsfData;
import ec.tstoolkit.ssf.SsfFunction;
import ec.tstoolkit.ssf.SsfFunctionInstance;
import ec.tstoolkit.ssf.SsfModel;
import ec.tstoolkit.ssf.SsfRefData;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;

public class TsDisaggregation<S extends ISsf> {
    private S ssf_;
    private S ssfRslt_;
    private IFunction fn_;
    private IFunctionInstance fnRslt_;
    private IParametricMapping<S> mapping_;
    private IFunctionMinimizer min_;
    private double eps_ = 1.0E-7;
    private boolean converged_;
    private int ndiffuseRegressors_;
    private boolean calcVar_ = false;
    private boolean ml_ = true;
    private boolean noDisturbanceSmoother_;
    private SsfOption ssfOption_ = SsfOption.DKF;
    private DisaggregationModel model_;
    private DisaggregationData data_;
    private DiffuseConcentratedLikelihood ll_;
    private Matrix information_;
    private double[] score_;
    private double[] yl_;
    private double[] vyl_;

    public double getEpsilon() {
        return this.eps_;
    }

    public void setEpsilon(double eps_) {
        this.eps_ = eps_;
    }

    private void AkfInterpolation(ISsfData ssfdata) {
        int[] iregs = null;
        if (this.data_.hEX != null && this.ndiffuseRegressors_ != 0) {
            int nx = this.ndiffuseRegressors_ < 0 ? this.data_.hEX.getColumnsCount() : this.ndiffuseRegressors_;
            iregs = new int[nx];
            for (int i = 0; i < nx; ++i) {
                iregs[i] = i;
            }
        }
        SsfModel<S> ssfmodel = new SsfModel<S>(this.ssf_, ssfdata, this.EX(false), iregs);
        AkfAlgorithm<S> alg = new AkfAlgorithm<S>();
        alg.useDiffuseInitialization(this.ssfOption_ == SsfOption.AKF_Diffuse);
        alg.useML(this.ml_);
        if (this.mapping_ != null) {
            SsfFunction<S> fn;
            this.fn_ = fn = new SsfFunction<S>(ssfmodel, this.mapping_, alg);
            IFunctionMinimizer min = this.minimizer();
            this.converged_ = min.minimize(this.fn_, this.fn_.evaluate(this.mapping_.map(this.ssf_)));
            SsfFunctionInstance rslt = (SsfFunctionInstance)min.getResult();
            this.fnRslt_ = rslt;
            this.ssfRslt_ = rslt.ssf;
            this.ll_ = rslt.getLikelihood();
            this.computeInformation(fn, rslt);
        } else {
            this.ssfRslt_ = this.ssf_;
            this.converged_ = true;
            this.ll_ = alg.evaluate(ssfmodel).getLikelihood();
        }
    }

    private boolean calcInterpolatedSeries() {
        double[] yc = this.YC();
        if (!this.calcVar_ && !this.noDisturbanceSmoother_) {
            DisturbanceSmoother dsm = new DisturbanceSmoother();
            dsm.setSsf((ISsf)this.ssfRslt_);
            if (!dsm.process(new SsfData(yc, null))) {
                return false;
            }
            SmoothingResults srslts = dsm.calcSmoothedStates();
            this.yl_ = new double[yc.length];
            for (int i = 0; i < this.yl_.length; ++i) {
                this.yl_[i] = this.ssf_.ZX(i, srslts.A(i));
            }
            SubMatrix x = this.X(true);
            if (x != null) {
                DataBlock rcy = new DataBlock(this.yl_);
                DataBlockIterator cols = x.columns();
                DataBlock col = cols.getData();
                DataBlock b = this.coeff();
                do {
                    rcy.addAY(b.get(cols.getPosition()), col);
                } while (cols.next());
            }
        } else if (this.noDisturbanceSmoother_) {
            Smoother sm = new Smoother();
            sm.setSsf((ISsf)this.ssfRslt_);
            SmoothingResults srslts = new SmoothingResults();
            if (!sm.process(new SsfData(yc, null), srslts)) {
                return false;
            }
            this.yl_ = new double[yc.length];
            for (int i = 0; i < this.yl_.length; ++i) {
                this.yl_[i] = this.ssf_.ZX(i, srslts.A(i));
            }
            SubMatrix x = this.X(true);
            if (x != null) {
                DataBlock rcy = new DataBlock(this.yl_);
                DataBlockIterator cols = x.columns();
                DataBlock col = cols.getData();
                DataBlock b = this.coeff();
                do {
                    rcy.addAY(b.get(cols.getPosition()), col);
                } while (cols.next());
            }
        } else {
            Smoother smoother = new Smoother();
            smoother.setCalcVar(this.calcVar_);
            smoother.setSsf((ISsf)this.ssfRslt_);
            SmoothingResults srslts = new SmoothingResults();
            if (!smoother.process(new SsfData(yc, null), srslts)) {
                return false;
            }
            this.yl_ = new double[yc.length];
            this.vyl_ = new double[yc.length];
            double sig = this.ll_.getSigma();
            for (int i = 0; i < this.yl_.length; ++i) {
                this.yl_[i] = this.ssfRslt_.ZX(i, srslts.A(i));
                this.vyl_[i] = sig * this.ssfRslt_.ZVZ(i, srslts.P(i));
            }
            SubMatrix x = this.X(true);
            SubMatrix xc = this.EX(true);
            if (x != null) {
                int nrows = x.getRowsCount();
                Matrix xl = new Matrix(nrows, x.getColumnsCount());
                DataBlockIterator xccols = xc.columns();
                DataBlockIterator xlcols = xl.columns();
                DataBlock xccol = xccols.getData();
                DataBlock xlcol = xlcols.getData();
                DisturbanceSmoother dsm = new DisturbanceSmoother();
                dsm.setSsf((ISsf)this.ssfRslt_);
                DiffuseFilteringResults dfrslts = smoother.getFilteringResults();
                double[] tmp = new double[nrows];
                do {
                    xccol.copyTo(tmp, 0);
                    dfrslts.getVarianceFilter().process(dfrslts.getFilteredData(), 0, tmp, null);
                    if (!dsm.process(new SsfData(tmp, null), dfrslts)) {
                        return false;
                    }
                    srslts = dsm.calcSmoothedStates();
                    for (int i = 0; i < nrows; ++i) {
                        xlcol.set(i, this.ssfRslt_.ZX(i, srslts.A(i)));
                    }
                } while (xccols.next() && xlcols.next());
                DataBlock rcy = new DataBlock(this.yl_);
                DataBlockIterator xcols = x.columns();
                DataBlock xcol = xcols.getData();
                DataBlock b = this.coeff();
                do {
                    rcy.addAY(b.get(xcols.getPosition()), xcol);
                } while (xcols.next());
                DataBlockIterator xrows = x.rows();
                DataBlockIterator xlrows = xl.rows();
                DataBlock xrow = xrows.getData();
                DataBlock xlrow = xlrows.getData();
                SubMatrix bvar = this.coeffVar();
                do {
                    xlrow.sub(xrow);
                    int n = xlrows.getPosition();
                    this.vyl_[n] = this.vyl_[n] + SymmetricMatrix.quadraticForm(bvar, xlrow);
                } while (xrows.next() && xlrows.next());
            }
            for (int i = 0; i < this.vyl_.length; ++i) {
                if (!(this.vyl_[i] < 1.0E-12)) continue;
                this.vyl_[i] = 0.0;
            }
        }
        return true;
    }

    private boolean calcSmoothedSeries() {
        double[] yc = this.YC();
        if (!this.calcVar_ && !this.noDisturbanceSmoother_) {
            DisturbanceSmoother dsm = new DisturbanceSmoother();
            SsfDisaggregation<S> ssf = new SsfDisaggregation<S>(this.data_.FrequencyRatio, this.ssfRslt_);
            dsm.setSsf(ssf);
            if (!dsm.process(new SsfData(yc, null))) {
                return false;
            }
            SmoothingResults srslts = dsm.calcSmoothedStates();
            this.yl_ = new double[yc.length];
            for (int i = 0; i < this.yl_.length; ++i) {
                this.yl_[i] = this.ssf_.ZX(i, srslts.A(i).drop(1, 0));
            }
            SubMatrix x = this.X(true);
            if (x != null) {
                DataBlock rcy = new DataBlock(this.yl_);
                DataBlockIterator cols = x.columns();
                DataBlock col = cols.getData();
                DataBlock b = this.coeff();
                do {
                    rcy.addAY(b.get(cols.getPosition()), col);
                } while (cols.next());
            }
        } else if (this.noDisturbanceSmoother_) {
            Smoother sm = new Smoother();
            SsfDisaggregation<S> ssf = new SsfDisaggregation<S>(this.data_.FrequencyRatio, this.ssfRslt_);
            sm.setSsf(ssf);
            SmoothingResults srslts = new SmoothingResults();
            if (!sm.process(new SsfData(yc, null), srslts)) {
                return false;
            }
            this.yl_ = new double[yc.length];
            for (int i = 0; i < this.yl_.length; ++i) {
                this.yl_[i] = this.ssf_.ZX(i, srslts.A(i).drop(1, 0));
            }
            SubMatrix x = this.X(true);
            if (x != null) {
                DataBlock rcy = new DataBlock(this.yl_);
                DataBlockIterator cols = x.columns();
                DataBlock col = cols.getData();
                DataBlock b = this.coeff();
                do {
                    rcy.addAY(b.get(cols.getPosition()), col);
                } while (cols.next());
            }
        } else {
            Smoother smoother = new Smoother();
            smoother.setCalcVar(this.calcVar_);
            SsfDisaggregation<S> ssf = new SsfDisaggregation<S>(this.data_.FrequencyRatio, this.ssfRslt_);
            smoother.setSsf(ssf);
            SmoothingResults srslts = new SmoothingResults();
            if (!smoother.process(new SsfData(yc, null), srslts)) {
                return false;
            }
            this.yl_ = new double[yc.length];
            this.vyl_ = new double[yc.length];
            int dim = ssf.getStateDim();
            double sig = this.ll_.getSigma();
            for (int i = 0; i < this.yl_.length; ++i) {
                this.yl_[i] = this.ssfRslt_.ZX(i, srslts.A(i).drop(1, 0));
                this.vyl_[i] = sig * this.ssfRslt_.ZVZ(i, srslts.P(i).extract(1, dim, 1, dim));
            }
            SubMatrix x = this.X(true);
            SubMatrix xc = this.EX(true);
            if (x != null) {
                int nrows = x.getRowsCount();
                Matrix xl = new Matrix(nrows, x.getColumnsCount());
                DataBlockIterator xccols = xc.columns();
                DataBlockIterator xlcols = xl.columns();
                DisturbanceSmoother dsm = new DisturbanceSmoother();
                dsm.setSsf(ssf);
                DiffuseFilteringResults dfrslts = smoother.getFilteringResults();
                DataBlock xccol = xccols.getData();
                DataBlock xlcol = xlcols.getData();
                double[] tmp = new double[nrows];
                do {
                    xccol.copyTo(tmp, 0);
                    dfrslts.getVarianceFilter().process(dfrslts.getFilteredData(), 0, tmp, null);
                    if (!dsm.process(new SsfData(tmp, null), dfrslts)) {
                        return false;
                    }
                    srslts = dsm.calcSmoothedStates();
                    for (int i = 0; i < nrows; ++i) {
                        xlcol.set(i, this.ssfRslt_.ZX(i, srslts.A(i).drop(1, 0)));
                    }
                } while (xccols.next() && xlcols.next());
                DataBlock rcy = new DataBlock(this.yl_);
                DataBlockIterator xcols = x.columns();
                DataBlock xcol = xcols.getData();
                DataBlock b = this.coeff();
                do {
                    rcy.addAY(b.get(xcols.getPosition()), xcol);
                } while (xcols.next());
                DataBlockIterator xrows = x.rows();
                DataBlockIterator xlrows = xl.rows();
                DataBlock xrow = xrows.getData();
                DataBlock xlrow = xlrows.getData();
                SubMatrix bvar = this.coeffVar();
                do {
                    xlrow.sub(xrow);
                    int n = xlrows.getPosition();
                    this.vyl_[n] = this.vyl_[n] + SymmetricMatrix.quadraticForm(bvar, xlrow);
                } while (xrows.next() && xlrows.next());
            }
            for (int i = 0; i < this.vyl_.length; ++i) {
                if (!(this.vyl_[i] < 1.0E-12)) continue;
                this.vyl_[i] = 0.0;
            }
        }
        return true;
    }

    public void calculateVariance(boolean value) {
        this.calcVar_ = value;
    }

    private void clearResults() {
        this.data_ = null;
        this.ll_ = null;
        this.ssfRslt_ = null;
        this.yl_ = null;
        this.vyl_ = null;
        this.information_ = null;
        this.score_ = null;
        this.fnRslt_ = null;
    }

    private DataBlock coeff() {
        double[] b = this.ll_.getB();
        if (this.ssfOption_ == SsfOption.DKF) {
            return new DataBlock(b);
        }
        return new DataBlock(b, this.ssf_.getNonStationaryDim(), b.length, 1);
    }

    private SubMatrix coeffVar() {
        if (this.ssfOption_ == SsfOption.DKF) {
            return this.ll_.bvar().subMatrix();
        }
        int n = this.ll_.bvar().getRowsCount();
        int start = this.ssf_.getNonStationaryDim();
        return this.ll_.bvar().subMatrix(start, n, start, n);
    }

    private void DKFInterpolation(ISsfData ssfdata) {
        int[] iregs = null;
        if (this.data_.hEX != null && this.ndiffuseRegressors_ != 0) {
            int nx = this.ndiffuseRegressors_ < 0 ? this.data_.hEX.getColumnsCount() : this.ndiffuseRegressors_;
            iregs = new int[nx];
            for (int i = 0; i < nx; ++i) {
                iregs[i] = i;
            }
        }
        SsfModel<S> ssfmodel = new SsfModel<S>(this.ssf_, ssfdata, this.EX(false), iregs);
        SsfAlgorithm<S> alg = new SsfAlgorithm<S>();
        alg.useML(this.ml_);
        if (this.mapping_ != null) {
            SsfFunction<S> fn;
            this.fn_ = fn = new SsfFunction<S>(ssfmodel, this.mapping_, alg);
            IFunctionMinimizer min = this.minimizer();
            this.converged_ = min.minimize(this.fn_, this.fn_.evaluate(this.mapping_.map(this.ssf_)));
            SsfFunctionInstance rslt = (SsfFunctionInstance)min.getResult();
            this.ssfRslt_ = rslt.ssf;
            this.fnRslt_ = rslt;
            this.ll_ = rslt.getLikelihood();
            this.computeInformation(fn, rslt);
        } else {
            this.ssfRslt_ = this.ssf_;
            this.converged_ = true;
            this.ll_ = alg.evaluate(ssfmodel).getLikelihood();
        }
    }

    private SubMatrix EX(boolean full) {
        if (this.data_.hEX == null) {
            return null;
        }
        if (!full) {
            int xstart = this.data_.hEDom.getStart().minus(this.data_.hDom.getStart());
            int nx = this.data_.hEDom.getLength();
            int ny = this.data_.hEX.getColumnsCount();
            return this.data_.hEX.subMatrix(xstart, xstart + nx, 0, ny);
        }
        return this.data_.hEX.subMatrix();
    }

    private ISsf extendedSsf() {
        if (this.ssfRslt_ == null || this.data_ == null) {
            return null;
        }
        SsfDisaggregation<S> ssf = new SsfDisaggregation<S>(this.data_.FrequencyRatio, this.ssfRslt_);
        if (this.data_.hEX == null) {
            return ssf;
        }
        return new RegSsf(ssf, this.EX(false));
    }

    private ISsfData extendedY() {
        if (this.data_ == null) {
            return null;
        }
        int xstart = this.data_.hEDom.getStart().minus(this.data_.hDom.getStart());
        int nx = this.data_.hEDom.getLength();
        return new SsfRefData(new DataBlock(this.data_.hY, xstart, xstart + nx, 1), null);
    }

    public DisaggregationData getData() {
        return this.data_;
    }

    public int getDiffuseRegressorsCount() {
        return this.ndiffuseRegressors_;
    }

    public S getEstimatedSsf() {
        return this.ssfRslt_;
    }

    public IFunction getEstimationFunction() {
        return this.fn_;
    }

    public Matrix getObservedInformation() {
        return this.information_;
    }

    public double[] getScore() {
        return this.score_;
    }

    public DiffuseConcentratedLikelihood getLikelihood() {
        return this.ll_;
    }

    public IParametricMapping<S> getMapping() {
        return this.mapping_;
    }

    public IFunctionMinimizer getMinimizer() {
        return this.min_;
    }

    public IFunction getObjectiveFunction() {
        return this.fn_;
    }

    public IFunctionInstance getMin() {
        return this.fnRslt_;
    }

    public DisaggregationModel getModel() {
        return this.model_;
    }

    public TsData getFullResiduals() {
        if (this.ll_ == null) {
            return null;
        }
        Filter<S> filter = new Filter<S>();
        filter.setSsf(this.ssfRslt_);
        double[] yc = this.YC();
        FilteringResults frslts = new FilteringResults();
        filter.process(new SsfData(yc, null), frslts);
        double[] xres = frslts.getFilteredData().data(true, true);
        if (this.model_.getAggregationType() == TsAggregationType.Average) {
            int i = 0;
            while (i < xres.length) {
                int n = i++;
                xres[n] = xres[n] / (double)this.data_.FrequencyRatio;
            }
        }
        TsPeriod rend = new TsPeriod(this.model_.getY().getFrequency());
        rend.set(this.data_.hEDom.getEnd().firstday());
        rend.move(-xres.length);
        TsData s = new TsData(rend, xres, true);
        return s;
    }

    public TsData getSmoothedSeries() {
        if (this.yl_ == null) {
            return null;
        }
        return new TsData(this.data_.hDom.getStart(), this.yl_, true);
    }

    public TsData getSmoothedSeriesVariance() {
        if (this.vyl_ == null) {
            return null;
        }
        return new TsData(this.data_.hDom.getStart(), this.vyl_, true);
    }

    public S getSsf() {
        return this.ssf_;
    }

    public SsfOption getSsfOption() {
        return this.ssfOption_;
    }

    public boolean hasConverged() {
        return this.converged_;
    }

    public boolean isCalculatingVariance() {
        return this.calcVar_;
    }

    public boolean isUsingDisturbanceSmoother() {
        return !this.noDisturbanceSmoother_;
    }

    public boolean isUsingML() {
        return this.ml_;
    }

    private IFunctionMinimizer minimizer() {
        if (this.min_ != null) {
            this.min_.setConvergenceCriterion(this.eps_);
            return this.min_;
        }
        if (this.mapping_ != null && this.mapping_.getDim() == 1) {
            double a = this.mapping_.lbound(0);
            double b = this.mapping_.ubound(0);
            if (!Double.isInfinite(a) && !Double.isInfinite(b)) {
                GridSearch search = new GridSearch();
                search.setBounds(a, b);
                search.setConvergenceCriterion(this.eps_);
                search.setPrecision(this.eps_);
                return search;
            }
        }
        return new ProxyMinimizer(new LevenbergMarquardtMethod());
    }

    public boolean process(DisaggregationModel model, TsDomain domain) {
        this.clearResults();
        this.model_ = model;
        this.data_ = model.data(domain, false);
        if (this.data_ == null) {
            return false;
        }
        ISsfData ssfdata = this.extendedY();
        if (model.getAggregationType() == TsAggregationType.Sum || model.getAggregationType() == TsAggregationType.Average) {
            if (this.ssfOption_ == SsfOption.DKF) {
                this.processDKF(ssfdata);
            } else {
                this.processAkf(ssfdata);
            }
            this.calcSmoothedSeries();
        } else {
            if (this.ssfOption_ == SsfOption.DKF) {
                this.DKFInterpolation(ssfdata);
            } else {
                this.AkfInterpolation(ssfdata);
            }
            this.calcInterpolatedSeries();
        }
        this.rescale();
        this.data_ = model.data(domain, false);
        if (this.model_.getAggregationType() == TsAggregationType.Average) {
            for (int i = 0; i < this.data_.hY.length; ++i) {
                if (!Double.isFinite(this.data_.hY[i])) continue;
                int n = i;
                this.data_.hY[n] = this.data_.hY[n] * (double)this.data_.FrequencyRatio;
            }
        }
        return true;
    }

    private void processAkf(ISsfData ssfdata) {
        SsfDisaggregation<S> xssf = new SsfDisaggregation<S>(this.data_.FrequencyRatio, this.ssf_);
        int[] iregs = null;
        if (this.data_.hEX != null && this.ndiffuseRegressors_ != 0) {
            int nx = this.ndiffuseRegressors_ < 0 ? this.data_.hEX.getColumnsCount() : this.ndiffuseRegressors_;
            iregs = new int[nx];
            for (int i = 0; i < nx; ++i) {
                iregs[i] = i;
            }
        }
        SsfModel<SsfDisaggregation<S>> ssfmodel = new SsfModel<SsfDisaggregation<S>>(xssf, ssfdata, this.EX(false), iregs);
        AkfAlgorithm<SsfDisaggregation<S>> alg = new AkfAlgorithm<SsfDisaggregation<S>>();
        alg.useDiffuseInitialization(this.ssfOption_ == SsfOption.AKF_Diffuse);
        alg.useML(this.ml_);
        if (this.mapping_ != null) {
            SsfFunction<SsfDisaggregation<SsfDisaggregation<S>>> fn;
            this.fn_ = fn = new SsfFunction<SsfDisaggregation<SsfDisaggregation<S>>>(ssfmodel, new SsfDisaggregationMapper<S>(this.mapping_, this.data_.FrequencyRatio), alg);
            IFunctionMinimizer min = this.minimizer();
            this.converged_ = min.minimize(this.fn_, this.fn_.evaluate(this.mapping_.map(this.ssf_)));
            SsfFunctionInstance rslt = (SsfFunctionInstance)min.getResult();
            this.fnRslt_ = rslt;
            this.ssfRslt_ = ((SsfDisaggregation)rslt.ssf).getInternalSsf();
            this.ll_ = rslt.getLikelihood();
            this.computeInformation(fn, rslt);
        } else {
            this.ssfRslt_ = this.ssf_;
            this.converged_ = true;
            this.ll_ = alg.evaluate(ssfmodel).getLikelihood();
        }
    }

    private void processDKF(ISsfData ssfdata) {
        SsfDisaggregation<S> xssf = new SsfDisaggregation<S>(this.data_.FrequencyRatio, this.ssf_);
        int[] iregs = null;
        if (this.data_.hEX != null && this.ndiffuseRegressors_ != 0) {
            int nx = this.ndiffuseRegressors_ < 0 ? this.data_.hEX.getColumnsCount() : this.ndiffuseRegressors_;
            iregs = new int[nx];
            for (int i = 0; i < nx; ++i) {
                iregs[i] = i;
            }
        }
        SsfModel<SsfDisaggregation<S>> ssfmodel = new SsfModel<SsfDisaggregation<S>>(xssf, ssfdata, this.EX(false), iregs);
        SsfAlgorithm<SsfDisaggregation<S>> alg = new SsfAlgorithm<SsfDisaggregation<S>>();
        alg.useML(this.ml_);
        if (this.mapping_ != null) {
            SsfFunction<SsfDisaggregation<SsfDisaggregation<S>>> fn;
            this.fn_ = fn = new SsfFunction<SsfDisaggregation<SsfDisaggregation<S>>>(ssfmodel, new SsfDisaggregationMapper<S>(this.mapping_, this.data_.FrequencyRatio), alg);
            IFunctionMinimizer min = this.minimizer();
            this.converged_ = min.minimize(this.fn_, this.fn_.evaluate(this.mapping_.map(this.ssf_)));
            SsfFunctionInstance rslt = (SsfFunctionInstance)min.getResult();
            this.fnRslt_ = rslt;
            this.ssfRslt_ = ((SsfDisaggregation)rslt.ssf).getInternalSsf();
            this.ll_ = rslt.getLikelihood();
            this.computeInformation(fn, rslt);
        } else {
            this.converged_ = true;
            this.ssfRslt_ = this.ssf_;
            this.ll_ = alg.evaluate(ssfmodel).getLikelihood();
        }
    }

    private void computeInformation(ISsqFunction fn, ISsqFunctionInstance p) {
        SsqNumericalDerivatives d = new SsqNumericalDerivatives(fn, p);
        this.information_ = d.getHessian().clone();
        this.score_ = d.getGradient();
        double obj = p.getSsqE();
        int ndf = this.ll_.getDegreesOfFreedom(true, this.mapping_ != null ? this.mapping_.getDim() : 0);
        this.information_.mul(0.5 * (double)ndf / obj);
        int i = 0;
        while (i < this.score_.length) {
            int n = i++;
            this.score_[n] = this.score_[n] * (-0.5 * (double)ndf / obj);
        }
    }

    private void rescale() {
        double[] xf;
        double yf = 1.0 / this.data_.yfactor;
        if (this.model_.getAggregationType() == TsAggregationType.Average) {
            yf *= (double)this.data_.FrequencyRatio;
        }
        if (yf != 1.0) {
            int i = 0;
            while (i < this.yl_.length) {
                int n = i++;
                this.yl_[n] = this.yl_[n] * yf;
            }
            if (this.vyl_ != null) {
                double vyf = yf * yf;
                int i2 = 0;
                while (i2 < this.yl_.length) {
                    int n = i2++;
                    this.vyl_[n] = this.vyl_[n] * vyf;
                }
            }
        }
        double[] dArray = xf = this.data_.xfactor != null ? (double[])this.data_.xfactor.clone() : null;
        if (xf != null && this.model_.getAggregationType() == TsAggregationType.Average) {
            int i = 0;
            while (i < xf.length) {
                int n = i++;
                xf[n] = xf[n] * (double)this.data_.FrequencyRatio;
            }
        }
        if (this.ssfOption_ == SsfOption.DKF || this.ssf_.getNonStationaryDim() == 0) {
            this.ll_.rescale(this.data_.yfactor, xf);
        } else {
            int i;
            int ns = this.ssf_.getNonStationaryDim();
            int nx = this.data_.xfactor == null ? 0 : this.data_.xfactor.length;
            double[] xfactor = new double[ns + nx];
            for (i = 0; i < ns; ++i) {
                xfactor[i] = 1.0;
            }
            for (i = 0; i < nx; ++i) {
                xfactor[i + ns] = xf[i];
            }
            this.ll_.rescale(this.data_.yfactor, xfactor);
        }
    }

    public void setDiffuseRegressorsCount(int value) {
        this.ndiffuseRegressors_ = value;
    }

    public void setMapping(IParametricMapping<S> value) {
        this.mapping_ = value;
    }

    public void setMinimizer(IFunctionMinimizer value) {
        this.min_ = value;
    }

    public void setSsf(S value) {
        this.ssf_ = value;
    }

    public void setSsfOption(SsfOption value) {
        this.ssfOption_ = value;
    }

    public void useDisturbanceSmoother(boolean value) {
        this.noDisturbanceSmoother_ = !value;
    }

    public void useML(boolean value) {
        this.ml_ = value;
    }

    private SubMatrix X(boolean full) {
        if (this.data_.hX == null) {
            return null;
        }
        if (!full) {
            int xstart = this.data_.hEDom.getStart().minus(this.data_.hDom.getStart());
            int nx = this.data_.hEDom.getLength();
            int ny = this.data_.hEX.getColumnsCount();
            return this.data_.hX.subMatrix(xstart, xstart + nx, 0, ny);
        }
        return this.data_.hX.subMatrix();
    }

    public CoefficientEstimation X(int i) {
        if (this.ll_ == null) {
            return null;
        }
        double b = this.ll_.getB()[i];
        int hp = this.mapping_ == null ? 0 : this.mapping_.getDim();
        double v = this.ll_.bser(i, true, hp);
        return new CoefficientEstimation(b, v);
    }

    private double[] YC() {
        SubMatrix x = this.EX(true);
        if (x != null) {
            double[] yc = (double[])this.data_.hY.clone();
            DataBlock rcy = new DataBlock(yc);
            DataBlockIterator cols = x.columns();
            DataBlock col = cols.getData();
            DataBlock b = this.coeff();
            do {
                rcy.addAY(-b.get(cols.getPosition()), col);
            } while (cols.next());
            return yc;
        }
        return this.data_.hY;
    }

    public static enum SsfOption {
        DKF,
        AKF_Fixed,
        AKF_Diffuse;

    }
}

