/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.SSMASFLSDE;

import java.util.Arrays;
import java.util.StringTokenizer;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.SSMASFLSDE.Cromosoma;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;
import keel.Algorithms.Preprocess.Basic.KNN;
import keel.Algorithms.Preprocess.Basic.Metodo;
import keel.Algorithms.Preprocess.Basic.OutputIS;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.InstanceAttributes;
import keel.Dataset.InstanceSet;
import org.core.Fichero;
import org.core.Files;
import org.core.Randomize;

public class SSMASFLSDE
extends Metodo {
    private long semilla;
    private int tamPoblacion;
    private double nEval;
    private double pCross;
    private double pMut;
    private int kNeigh;
    public String Script;
    private PrototypeSet trainingDataSet;
    private PrototypeSet testDataSet;
    private PrototypeGenerator generador;
    private int k;
    private int PopulationSize;
    private int ParticleSize;
    private int MaxIter;
    private double ScalingFactor;
    private double CrossOverRate;
    private int Strategy;
    private String CrossoverType;
    private double[] tau = new double[4];
    private double Fl;
    private double Fu;
    private int iterSFGSS;
    private int iterSFHC;
    protected int numberOfClass;
    protected int numberOfPrototypes;
    protected int numberOfStrategies;

    public SSMASFLSDE(String ficheroScript) {
        super(ficheroScript);
    }

    public SSMASFLSDE(String ficheroScript, InstanceSet train) {
        super(ficheroScript, train);
    }

    public void establishTrain(PrototypeSet trainPG) {
        this.trainingDataSet = trainPG.clone();
    }

    public static PrototypeSet readPrototypeSet(String nameOfFile) {
        Attributes.clearAll();
        InstanceSet training = new InstanceSet();
        try {
            training.readSet(nameOfFile, true);
            training.setAttributesAsNonStatic();
            InstanceAttributes att = training.getAttributeDefinitions();
            Prototype.setAttributesTypes(att);
        }
        catch (Exception e) {
            System.err.println("readPrototypeSet has failed!");
            e.printStackTrace();
        }
        return new PrototypeSet(training);
    }

    public static PrototypeSet readPrototypeSet2(InstanceSet training) {
        Attributes.clearAll();
        try {
            training.setAttributesAsNonStatic();
            InstanceAttributes att = training.getAttributeDefinitions();
            Prototype.setAttributesTypes(att);
        }
        catch (Exception e) {
            System.err.println("readPrototypeSet has failed!");
            e.printStackTrace();
        }
        return new PrototypeSet(training);
    }

    public void inic_vector_sin(int[] vector, int without) {
        for (int i = 0; i < vector.length; ++i) {
            if (i == without) continue;
            vector[i] = i;
        }
    }

    public void desordenar_vector_sin(int[] vector) {
        for (int i = 0; i < vector.length - 1; ++i) {
            int pos = Randomize.Randint(0, vector.length - 1);
            int tmp = vector[i];
            vector[i] = vector[pos];
            vector[pos] = tmp;
        }
    }

    public PrototypeSet mutant(PrototypeSet[] population, int actual, int mejor, double SFi) {
        PrototypeSet mutant = new PrototypeSet(population.length);
        int[] lista = new int[population.length];
        this.inic_vector_sin(lista, actual);
        this.desordenar_vector_sin(lista);
        PrototypeSet r1 = population[lista[0]];
        PrototypeSet r2 = population[lista[1]];
        PrototypeSet r3 = population[lista[2]];
        PrototypeSet r4 = population[lista[3]];
        PrototypeSet r5 = population[lista[4]];
        switch (this.Strategy) {
            case 1: {
                PrototypeSet resta = r2.restar(r3);
                PrototypeSet producto = resta.mulEscalar(SFi);
                mutant = producto.sumar(r1);
                break;
            }
            case 2: {
                PrototypeSet resta = r2.restar(r3);
                PrototypeSet producto = resta.mulEscalar(SFi);
                mutant = population[mejor].sumar(producto);
                break;
            }
            case 3: {
                PrototypeSet resta = r1.restar(r2);
                PrototypeSet resta2 = population[mejor].restar(population[actual]);
                PrototypeSet producto = resta.mulEscalar(SFi);
                PrototypeSet producto2 = resta2.mulEscalar(SFi);
                PrototypeSet result = population[actual].sumar(producto);
                mutant = result.sumar(producto2);
                break;
            }
            case 4: {
                PrototypeSet resta = r1.restar(r2);
                PrototypeSet resta2 = r3.restar(r4);
                PrototypeSet producto = resta.mulEscalar(SFi);
                PrototypeSet producto2 = resta2.mulEscalar(SFi);
                PrototypeSet result = population[mejor].sumar(producto);
                mutant = result.sumar(producto2);
                break;
            }
            case 5: {
                PrototypeSet resta = r2.restar(r3);
                PrototypeSet resta2 = r4.restar(r5);
                PrototypeSet producto = resta.mulEscalar(SFi);
                PrototypeSet producto2 = resta2.mulEscalar(SFi);
                PrototypeSet result = r1.sumar(producto);
                mutant = result.sumar(producto2);
                break;
            }
            case 6: {
                PrototypeSet resta = r1.restar(r2);
                PrototypeSet resta2 = r3.restar(r4);
                PrototypeSet resta3 = population[mejor].restar(population[actual]);
                PrototypeSet producto = resta.mulEscalar(SFi);
                PrototypeSet producto2 = resta2.mulEscalar(SFi);
                PrototypeSet producto3 = resta3.mulEscalar(SFi);
                PrototypeSet result = population[actual].sumar(producto);
                result = result.sumar(producto2);
                mutant = result.sumar(producto3);
            }
        }
        mutant.applyThresholds();
        return mutant;
    }

    public double lsff(double Fi, double CRi, PrototypeSet[] population, int actual, int mejor) {
        double FitnessFi = 0.0;
        PrototypeSet mutant = new PrototypeSet(population[actual].size());
        mutant = this.mutant(population, actual, mejor, Fi);
        PrototypeSet crossover = new PrototypeSet(population[actual]);
        for (int j = 0; j < population[actual].size(); ++j) {
            double randNumber = RandomGenerator.Randdouble(0.0, 1.0);
            if (!(randNumber < CRi)) continue;
            crossover.set(j, mutant.get(j));
        }
        PrototypeSet nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(crossover);
        FitnessFi = this.classficationAccuracy1NN(nominalPopulation, this.trainingDataSet);
        return FitnessFi;
    }

    public PrototypeSet SFGSS(PrototypeSet[] population, int actual, int mejor, double CRi) {
        double a = 0.1;
        double b = 1.0;
        double fi1 = 0.0;
        double fi2 = 0.0;
        double fitnessFi1 = 0.0;
        double fitnessFi2 = 0.0;
        double phi = (1.0 + Math.sqrt(5.0)) / 5.0;
        for (int i = 0; i < this.iterSFGSS; ++i) {
            fi1 = b - (b - a) / phi;
            fi2 = a + (b - a) / phi;
            fitnessFi1 = this.lsff(fi1, CRi, population, actual, mejor);
            if (fitnessFi1 > (fitnessFi2 = this.lsff(fi2, CRi, population, actual, mejor))) {
                b = fi2;
                continue;
            }
            a = fi1;
        }
        double scaling = fitnessFi1 > fitnessFi2 ? fi1 : fi2;
        PrototypeSet mutant = new PrototypeSet(population[actual].size());
        mutant = this.mutant(population, actual, mejor, scaling);
        PrototypeSet crossover = new PrototypeSet(population[actual]);
        for (int j = 0; j < population[actual].size(); ++j) {
            double randNumber = RandomGenerator.Randdouble(0.0, 1.0);
            if (!(randNumber < CRi)) continue;
            crossover.set(j, mutant.get(j));
        }
        return crossover;
    }

    public PrototypeSet SFHC(PrototypeSet[] population, int actual, int mejor, double SFi, double CRi) {
        double h = 0.5;
        for (int i = 0; i < this.iterSFHC; ++i) {
            double bestFi;
            double fitnessFi1 = this.lsff(SFi - h, CRi, population, actual, mejor);
            double fitnessFi2 = this.lsff(SFi, CRi, population, actual, mejor);
            double fitnessFi3 = this.lsff(SFi + h, CRi, population, actual, mejor);
            if (fitnessFi1 >= fitnessFi2 && fitnessFi1 >= fitnessFi3) {
                bestFi = SFi - h;
            } else if (fitnessFi2 >= fitnessFi1 && fitnessFi2 >= fitnessFi3) {
                bestFi = SFi;
                h /= 2.0;
            } else {
                bestFi = SFi;
            }
            SFi = bestFi;
        }
        PrototypeSet mutant = new PrototypeSet(population[actual].size());
        mutant = this.mutant(population, actual, mejor, SFi);
        PrototypeSet crossover = new PrototypeSet(population[actual]);
        for (int j = 0; j < population[actual].size(); ++j) {
            double randNumber = RandomGenerator.Randdouble(0.0, 1.0);
            if (!(randNumber < CRi)) continue;
            crossover.set(j, mutant.get(j));
        }
        return crossover;
    }

    public static Prototype _1nn(Prototype current, PrototypeSet dataSet) {
        Prototype nearestNeighbor = (Prototype)dataSet.get(0);
        int indexNN = 0;
        double minDist = Double.POSITIVE_INFINITY;
        int _size = dataSet.size();
        for (int i = 0; i < _size; ++i) {
            Prototype pi = (Prototype)dataSet.get(i);
            double currDist = Distance.euclideanDistance(pi, current);
            if (!(currDist > 0.0) || !(currDist < minDist)) continue;
            minDist = currDist;
            indexNN = i;
        }
        return (Prototype)dataSet.get(indexNN);
    }

    public double classficationAccuracy1NN(PrototypeSet training, PrototypeSet test) {
        int wellClassificated = 0;
        for (Prototype p : test) {
            Prototype nearestNeighbor = SSMASFLSDE._1nn(p, training);
            if (p.getOutput(0) != nearestNeighbor.getOutput(0)) continue;
            ++wellClassificated;
        }
        return 100.0 * ((double)wellClassificated / (double)test.size());
    }

    public PrototypeSet reduceSet(PrototypeSet initial) {
        int i;
        System.out.print("\nThe algorithm  SSMA-SFLSDE is starting...\n Computing...\n");
        PrototypeSet[] population = new PrototypeSet[this.PopulationSize];
        PrototypeSet[] mutation = new PrototypeSet[this.PopulationSize];
        PrototypeSet[] crossover = new PrototypeSet[this.PopulationSize];
        double[] ScalingFactor = new double[this.PopulationSize];
        double[] CrossOverRate = new double[this.PopulationSize];
        double[] fitness = new double[this.PopulationSize];
        double[] fitness_bestPopulation = new double[this.PopulationSize];
        PrototypeSet bestParticle = new PrototypeSet();
        population[0] = new PrototypeSet(initial.clone());
        this.generador = new PrototypeGenerator(this.trainingDataSet);
        if (population[0].size() < 2) {
            int i2;
            this.numberOfPrototypes = (int)Math.round((double)this.trainingDataSet.size() * 0.02);
            population[0] = this.generador.selecRandomSet(this.numberOfPrototypes, true).clone();
            PrototypeSet[] clases = new PrototypeSet[this.numberOfClass];
            for (i2 = 0; i2 < this.numberOfClass; ++i2) {
                clases[i2] = new PrototypeSet(this.trainingDataSet.getFromClass(i2));
            }
            for (i2 = 0; i2 < population[0].size(); ++i2) {
                for (int j = 0; j < this.numberOfClass; ++j) {
                    if (population[0].getFromClass(j).size() != 0 || clases[j].size() == 0) continue;
                    population[0].add(clases[j].getRandom());
                }
            }
        }
        PrototypeSet nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(population[0]);
        fitness[0] = this.classficationAccuracy1NN(nominalPopulation, this.trainingDataSet);
        System.out.println("Best initial fitness = " + fitness[0]);
        this.numberOfClass = this.trainingDataSet.getPosibleValuesOfOutput().size();
        for (int i3 = 1; i3 < this.PopulationSize; ++i3) {
            population[i3] = new PrototypeSet();
            for (int j = 0; j < population[0].size(); ++j) {
                Prototype aux = new Prototype(this.trainingDataSet.getFromClass(((Prototype)population[0].get(j)).getOutput(0)).getRandom());
                population[i3].add(aux);
            }
            nominalPopulation = new PrototypeSet();
            nominalPopulation.formatear(population[i3]);
            fitness[i3] = this.classficationAccuracy1NN(population[i3], this.trainingDataSet);
            fitness_bestPopulation[i3] = fitness[i3];
        }
        double bestFitness = fitness[0];
        int bestFitnessIndex = 0;
        for (i = 1; i < this.PopulationSize; ++i) {
            if (!(fitness[i] > bestFitness)) continue;
            bestFitness = fitness[i];
            bestFitnessIndex = i;
        }
        for (int j = 0; j < this.PopulationSize; ++j) {
            for (int i4 = 0; i4 < population[j].size(); ++i4) {
                ((Prototype)population[j].get(i4)).setIndex(i4);
            }
        }
        for (i = 0; i < this.PopulationSize; ++i) {
            ScalingFactor[i] = RandomGenerator.Randdouble(0.0, 1.0);
            CrossOverRate[i] = RandomGenerator.Randdouble(0.0, 1.0);
        }
        double[] randj = new double[5];
        for (int iter = 0; iter < this.MaxIter; ++iter) {
            for (int i5 = 0; i5 < this.PopulationSize; ++i5) {
                int j;
                for (j = 0; j < 5; ++j) {
                    randj[j] = RandomGenerator.Randdouble(0.0, 1.0);
                }
                if (i5 == bestFitnessIndex && randj[4] < this.tau[2]) {
                    crossover[i5] = this.SFGSS(population, i5, bestFitnessIndex, CrossOverRate[i5]);
                } else if (i5 == bestFitnessIndex && this.tau[2] <= randj[4] && randj[4] < this.tau[3]) {
                    crossover[i5] = this.SFHC(population, i5, bestFitnessIndex, ScalingFactor[i5], CrossOverRate[i5]);
                } else {
                    if (randj[1] < this.tau[0]) {
                        ScalingFactor[i5] = this.Fl + this.Fu * randj[0];
                    }
                    if (randj[3] < this.tau[1]) {
                        CrossOverRate[i5] = randj[2];
                    }
                    mutation[i5] = new PrototypeSet(population[i5].size());
                    mutation[i5] = this.mutant(population, i5, bestFitnessIndex, ScalingFactor[i5]);
                    crossover[i5] = new PrototypeSet(population[i5]);
                    for (j = 0; j < population[i5].size(); ++j) {
                        double randNumber = RandomGenerator.Randdouble(0.0, 1.0);
                        if (!(randNumber < CrossOverRate[i5])) continue;
                        crossover[i5].set(j, mutation[i5].get(j));
                    }
                }
                nominalPopulation = new PrototypeSet();
                nominalPopulation.formatear(population[i5]);
                fitness[i5] = this.classficationAccuracy1NN(nominalPopulation, this.trainingDataSet);
                nominalPopulation = new PrototypeSet();
                nominalPopulation.formatear(crossover[i5]);
                double trialVector = this.classficationAccuracy1NN(nominalPopulation, this.trainingDataSet);
                if (trialVector > fitness[i5]) {
                    population[i5] = new PrototypeSet(crossover[i5]);
                    fitness[i5] = trialVector;
                }
                if (!(fitness[i5] > bestFitness)) continue;
                bestFitness = fitness[i5];
                bestFitnessIndex = i5;
            }
        }
        nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(population[bestFitnessIndex]);
        System.err.println("\n% de acierto en training Nominal " + this.classficationAccuracy1NN(nominalPopulation, this.trainingDataSet));
        return nominalPopulation;
    }

    public void ejecutar() {
        int j;
        double[][] dMatrix;
        int i;
        int nSel = 0;
        double ev = 0.0;
        double GAeffort = 0.0;
        double LSeffort = 0.0;
        double fAcierto = 0.0;
        double fReduccion = 0.0;
        int contAcierto = 0;
        int contReduccion = 0;
        long tiempo = System.currentTimeMillis();
        int nClases = 0;
        for (i = 0; i < this.clasesTrain.length; ++i) {
            if (this.clasesTrain[i] <= nClases) continue;
            nClases = this.clasesTrain[i];
        }
        ++nClases;
        boolean veryLarge = this.datosTrain.length > 9000;
        if (!veryLarge) {
            dMatrix = new double[this.datosTrain.length][this.datosTrain.length];
            for (i = 0; i < dMatrix.length; ++i) {
                for (j = i + 1; j < dMatrix[i].length; ++j) {
                    dMatrix[i][j] = KNN.distancia((double[])this.datosTrain[i], (double[])this.realTrain[i], (int[])this.nominalTrain[i], (boolean[])this.nulosTrain[i], (double[])this.datosTrain[j], (double[])this.realTrain[j], (int[])this.nominalTrain[j], (boolean[])this.nulosTrain[j], (boolean)this.distanceEu);
                }
            }
            for (i = 0; i < dMatrix.length; ++i) {
                dMatrix[i][i] = Double.POSITIVE_INFINITY;
            }
            for (i = 0; i < dMatrix.length; ++i) {
                for (j = i - 1; j >= 0; --j) {
                    dMatrix[i][j] = dMatrix[j][i];
                }
            }
        } else {
            dMatrix = null;
        }
        Randomize.setSeed(this.semilla);
        Object[] poblacion = new Cromosoma[this.tamPoblacion];
        for (i = 0; i < this.tamPoblacion; ++i) {
            poblacion[i] = new Cromosoma(this.kNeigh, this.datosTrain.length, dMatrix, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.distanceEu);
        }
        for (i = 0; i < this.tamPoblacion; ++i) {
            poblacion[i].evaluacionCompleta(nClases, this.kNeigh, this.clasesTrain);
        }
        double umbralOpt = 0.0;
        while (ev < this.nEval) {
            int comp2;
            Arrays.sort(poblacion);
            contAcierto = fAcierto >= ((Cromosoma)poblacion[0]).getFitnessAc() * 100.0 / (double)this.datosTrain.length ? ++contAcierto : 0;
            fAcierto = ((Cromosoma)poblacion[0]).getFitnessAc() * 100.0 / (double)this.datosTrain.length;
            contReduccion = fReduccion >= (1.0 - (double)((Cromosoma)poblacion[0]).genesActivos() / (double)this.datosTrain.length) * 100.0 ? ++contReduccion : 0;
            fReduccion = (1.0 - (double)((Cromosoma)poblacion[0]).genesActivos() / (double)this.datosTrain.length) * 100.0;
            if (contReduccion >= 10 || contAcierto >= 10) {
                if (Randomize.Randint(0, 1) == 0) {
                    if (contAcierto >= 10) {
                        contAcierto = 0;
                        umbralOpt += 1.0;
                    } else {
                        contReduccion = 0;
                        umbralOpt -= 1.0;
                    }
                } else if (contReduccion >= 10) {
                    contReduccion = 0;
                    umbralOpt -= 1.0;
                } else {
                    contAcierto = 0;
                    umbralOpt += 1.0;
                }
            }
            int comp1 = Randomize.Randint(0, this.tamPoblacion - 1);
            while ((comp2 = Randomize.Randint(0, this.tamPoblacion - 1)) == comp1) {
            }
            int sel1 = ((Cromosoma)poblacion[comp1]).getFitness() > ((Cromosoma)poblacion[comp2]).getFitness() ? comp1 : comp2;
            comp1 = Randomize.Randint(0, this.tamPoblacion - 1);
            while ((comp2 = Randomize.Randint(0, this.tamPoblacion - 1)) == comp1) {
            }
            int sel2 = ((Cromosoma)poblacion[comp1]).getFitness() > ((Cromosoma)poblacion[comp2]).getFitness() ? comp1 : comp2;
            Cromosoma[] hijos = new Cromosoma[]{new Cromosoma(this.kNeigh, (Cromosoma)poblacion[sel1], (Cromosoma)poblacion[sel2], this.pCross, this.datosTrain.length), new Cromosoma(this.kNeigh, (Cromosoma)poblacion[sel2], (Cromosoma)poblacion[sel1], this.pCross, this.datosTrain.length)};
            hijos[0].mutation(this.kNeigh, this.pMut, dMatrix, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.distanceEu);
            hijos[1].mutation(this.kNeigh, this.pMut, dMatrix, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.distanceEu);
            hijos[0].evaluacionCompleta(nClases, this.kNeigh, this.clasesTrain);
            hijos[1].evaluacionCompleta(nClases, this.kNeigh, this.clasesTrain);
            GAeffort += 2.0;
            double temporal = ev += 2.0;
            if (hijos[0].getFitness() > ((Cromosoma)poblacion[this.tamPoblacion - 1]).getFitness() || Randomize.Rand() < 0.0625) {
                ev += hijos[0].optimizacionLocal(nClases, this.kNeigh, this.clasesTrain, dMatrix, umbralOpt, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.distanceEu);
            }
            if (hijos[1].getFitness() > ((Cromosoma)poblacion[this.tamPoblacion - 1]).getFitness() || Randomize.Rand() < 0.0625) {
                ev += hijos[1].optimizacionLocal(nClases, this.kNeigh, this.clasesTrain, dMatrix, umbralOpt, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.distanceEu);
            }
            LSeffort += ev - temporal;
            if (hijos[0].getFitness() > ((Cromosoma)poblacion[this.tamPoblacion - 1]).getFitness()) {
                poblacion[this.tamPoblacion - 1] = new Cromosoma(this.kNeigh, this.datosTrain.length, hijos[0]);
            }
            if (!(hijos[1].getFitness() > ((Cromosoma)poblacion[this.tamPoblacion - 2]).getFitness())) continue;
            poblacion[this.tamPoblacion - 2] = new Cromosoma(this.kNeigh, this.datosTrain.length, hijos[1]);
        }
        Arrays.sort(poblacion);
        nSel = ((Cromosoma)poblacion[0]).genesActivos();
        double[][] conjS = new double[nSel][this.datosTrain[0].length];
        double[][] conjR = new double[nSel][this.datosTrain[0].length];
        int[][] conjN = new int[nSel][this.datosTrain[0].length];
        boolean[][] conjM = new boolean[nSel][this.datosTrain[0].length];
        int[] clasesS = new int[nSel];
        int l = 0;
        for (i = 0; i < this.datosTrain.length; ++i) {
            if (!((Cromosoma)poblacion[0]).getGen(i)) continue;
            for (j = 0; j < this.datosTrain[i].length; ++j) {
                conjS[l][j] = this.datosTrain[i][j];
                conjR[l][j] = this.realTrain[i][j];
                conjN[l][j] = this.nominalTrain[i][j];
                conjM[l][j] = this.nulosTrain[i][j];
            }
            clasesS[l] = this.clasesTrain[i];
            ++l;
        }
        System.out.println("SSMA " + this.relation + " " + (double)(System.currentTimeMillis() - tiempo) / 1000.0 + "s");
        OutputIS.escribeSalida((String)this.ficheroSalida[0], (double[][])conjR, (int[][])conjN, (boolean[][])conjM, (int[])clasesS, (Attribute[])this.entradas, (Attribute)this.salida, (int)this.nEntradas, (String)this.relation);
        OutputIS.escribeSalida((String)this.ficheroSalida[1], (InstanceSet)this.test, (Attribute[])this.entradas, (Attribute)this.salida, (int)this.nEntradas, (String)this.relation);
        Parameters.assertBasicArgs(this.ficheroSalida);
        if (!this.Script.equals("NOFILE")) {
            PrototypeGenerationAlgorithm.readParametersFile(this.Script);
            PrototypeGenerationAlgorithm.printParameters();
            this.trainingDataSet = SSMASFLSDE.readPrototypeSet(this.ficheroTraining);
            this.testDataSet = SSMASFLSDE.readPrototypeSet(this.ficheroTest);
        }
        PrototypeSet training = SSMASFLSDE.readPrototypeSet(this.ficheroSalida[0]);
        PrototypeSet SADE = this.reduceSet(training);
        SADE.save(this.ficheroSalida[0]);
        SADE.print();
        System.out.println("Time elapse:" + (double)(System.currentTimeMillis() - tiempo) / 1000.0 + "s");
        if (!this.Script.equals("NOFILE")) {
            int[][] trainRealClass = new int[this.datosTrain.length][1];
            int[][] trainPrediction = new int[this.datosTrain.length][1];
            nClases = SADE.getPosibleValuesOfOutput().size();
            int cont = 0;
            for (i = 0; i < this.trainingDataSet.size(); ++i) {
                trainRealClass[i][0] = (int)((Prototype)this.trainingDataSet.get(i)).getOutput(0);
                trainPrediction[i][0] = SSMASFLSDE.evaluate(((Prototype)this.trainingDataSet.get(i)).getInputs(), SADE.prototypeSetTodouble(), nClases, SADE.getClases(), 1);
                if (trainRealClass[i][0] != trainPrediction[i][0]) continue;
                ++cont;
            }
            System.out.println("Acierto = " + (double)cont * 1.0 / (double)this.trainingDataSet.size());
            Attribute[] entradas = Attributes.getInputAttributes();
            Attribute salida = Attributes.getOutputAttribute(0);
            String relation = Attributes.getRelationName();
            SSMASFLSDE.writeOutput(this.ficheroSalida[0], trainRealClass, trainPrediction, entradas, salida, relation);
            int[][] realClass = new int[this.datosTest.length][1];
            int[][] prediction = new int[this.datosTest.length][1];
            for (i = 0; i < realClass.length; ++i) {
                realClass[i][0] = (int)((Prototype)this.testDataSet.get(i)).getOutput(0);
                prediction[i][0] = SSMASFLSDE.evaluate(((Prototype)this.testDataSet.get(i)).getInputs(), SADE.prototypeSetTodouble(), nClases, SADE.getClases(), 1);
            }
            SSMASFLSDE.writeOutput(this.ficheroSalida[1], realClass, prediction, entradas, salida, relation);
        }
    }

    public static void writeOutput(String filename, int[][] realClass, int[][] prediction, Attribute[] inputs, Attribute output, String relation) {
        int j;
        int i;
        String text = "";
        text = text + "@relation " + relation + "\n";
        for (i = 0; i < inputs.length; ++i) {
            text = text + "@attribute " + inputs[i].getName() + " ";
            if (inputs[i].getType() == 0) {
                text = text + "{";
                for (j = 0; j < inputs[i].getNominalValuesList().size(); ++j) {
                    text = text + (String)inputs[i].getNominalValuesList().elementAt(j);
                    if (j >= inputs[i].getNominalValuesList().size() - 1) continue;
                    text = text + ", ";
                }
                text = text + "}\n";
                continue;
            }
            text = inputs[i].getType() == 1 ? text + "integer" : text + "real";
            text = text + " [" + String.valueOf(inputs[i].getMinAttribute()) + ", " + String.valueOf(inputs[i].getMaxAttribute()) + "]\n";
        }
        text = text + "@attribute " + output.getName() + " ";
        if (output.getType() == 0) {
            text = text + "{";
            for (int j2 = 0; j2 < output.getNominalValuesList().size(); ++j2) {
                text = text + (String)output.getNominalValuesList().elementAt(j2);
                if (j2 >= output.getNominalValuesList().size() - 1) continue;
                text = text + ", ";
            }
            text = text + "}\n";
        } else {
            text = text + "integer [" + String.valueOf(output.getMinAttribute()) + ", " + String.valueOf(output.getMaxAttribute()) + "]\n";
        }
        text = text + "@data\n";
        Files.writeFile(filename, text);
        if (output.getType() == 1) {
            text = "";
            for (i = 0; i < realClass.length; ++i) {
                for (j = 0; j < realClass[0].length; ++j) {
                    text = text + "" + realClass[i][j] + " ";
                }
                for (j = 0; j < realClass[0].length; ++j) {
                    text = text + "" + prediction[i][j] + " ";
                }
                text = text + "\n";
                if (i % 10 != 9) continue;
                Files.addToFile(filename, text);
                text = "";
            }
            if (realClass.length % 10 != 0) {
                Files.addToFile(filename, text);
            }
        } else {
            text = "";
            for (i = 0; i < realClass.length; ++i) {
                for (j = 0; j < realClass[0].length; ++j) {
                    text = text + "" + (String)output.getNominalValuesList().elementAt(realClass[i][j]) + " ";
                }
                for (j = 0; j < realClass[0].length; ++j) {
                    text = prediction[i][j] > -1 ? text + "" + (String)output.getNominalValuesList().elementAt(prediction[i][j]) + " " : text + "Unclassified ";
                }
                text = text + "\n";
                if (i % 10 != 9) continue;
                Files.addToFile(filename, text);
                text = "";
            }
            if (realClass.length % 10 != 0) {
                Files.addToFile(filename, text);
            }
        }
    }

    protected static double distance(double[] instance1, double[] instance2) {
        double length = 0.0;
        for (int i = 0; i < instance1.length; ++i) {
            length += (instance1[i] - instance2[i]) * (instance1[i] - instance2[i]);
        }
        length = Math.sqrt(length);
        return length;
    }

    protected static double distanceWeighting(double[] instance1, double[] instance2, double[] Weights) {
        double length = 0.0;
        for (int i = 0; i < instance1.length; ++i) {
            length += (instance1[i] - instance2[i]) * (instance1[i] - instance2[i]) * Weights[i];
        }
        length = Math.sqrt(length);
        return length;
    }

    public static int evaluate(double[] example, double[][] trainData, int nClasses, int[] trainOutput, int k) {
        int i;
        int[] nearestN = new int[k];
        double[] minDist = new double[k];
        for (i = 0; i < k; ++i) {
            nearestN[i] = 0;
            minDist[i] = Double.MAX_VALUE;
        }
        for (i = 0; i < trainData.length; ++i) {
            double dist = SSMASFLSDE.distance(trainData[i], example);
            if (!(dist > 0.0)) continue;
            boolean stop = false;
            for (int j = 0; j < k && !stop; ++j) {
                if (!(dist < minDist[j])) continue;
                for (int l = k - 1; l >= j + 1; --l) {
                    minDist[l] = minDist[l - 1];
                    nearestN[l] = nearestN[l - 1];
                }
                minDist[j] = dist;
                nearestN[j] = i;
                stop = true;
            }
        }
        int[] selectedClasses = new int[nClasses];
        for (i = 0; i < nClasses; ++i) {
            selectedClasses[i] = 0;
        }
        for (i = 0; i < k; ++i) {
            int n = trainOutput[nearestN[i]];
            selectedClasses[n] = selectedClasses[n] + 1;
        }
        int prediction = 0;
        int predictionValue = selectedClasses[0];
        for (i = 1; i < nClasses; ++i) {
            if (predictionValue >= selectedClasses[i]) continue;
            predictionValue = selectedClasses[i];
            prediction = i;
        }
        return prediction;
    }

    public void leerConfiguracion(String ficheroScript) {
        this.ficheroSalida = new String[2];
        if (ficheroScript.equals("NOFILE")) {
            System.out.println("There is no configuration file: Applying Auto-parameters");
            this.ficheroSalida[0] = "salida.dat";
            this.ficheroSalida[1] = "otro.dat";
            this.ficheroTraining = "intermediate.dat";
            this.tamPoblacion = 30;
            this.nEval = 10000.0;
            this.pCross = 0.5;
            this.pMut = 0.001;
            this.kNeigh = 1;
            this.distanceEu = true;
            this.PopulationSize = 50;
            this.MaxIter = 500;
            this.iterSFGSS = 8;
            this.iterSFHC = 20;
            this.Fl = 0.1;
            this.Fu = 0.9;
            this.tau = new double[4];
            this.tau[0] = 0.1;
            this.tau[1] = 0.1;
            this.tau[2] = 0.03;
            this.tau[3] = 0.07;
            this.Strategy = 3;
        } else {
            String fichero = Fichero.leeFichero(ficheroScript);
            StringTokenizer lineasFichero = new StringTokenizer(fichero, "\n\r");
            lineasFichero.nextToken();
            String linea = lineasFichero.nextToken();
            StringTokenizer tokens = new StringTokenizer(linea, "=");
            tokens.nextToken();
            String token = tokens.nextToken();
            byte[] line = token.getBytes();
            int i = 0;
            while (line[i] != 34) {
                ++i;
            }
            int j = ++i;
            while (line[j] != 34) {
                ++j;
            }
            this.ficheroTraining = new String(line, i, j - i);
            i = j + 1;
            while (line[i] != 34) {
                ++i;
            }
            j = ++i;
            while (line[j] != 34) {
                ++j;
            }
            this.ficheroValidation = new String(line, i, j - i);
            i = j + 1;
            while (line[i] != 34) {
                ++i;
            }
            j = ++i;
            while (line[j] != 34) {
                ++j;
            }
            this.ficheroTest = new String(line, i, j - i);
            linea = lineasFichero.nextToken();
            tokens = new StringTokenizer(linea, "=");
            tokens.nextToken();
            token = tokens.nextToken();
            line = token.getBytes();
            i = 0;
            while (line[i] != 34) {
                ++i;
            }
            j = ++i;
            while (line[j] != 34) {
                ++j;
            }
            this.ficheroSalida[0] = new String(line, i, j - i);
            i = j + 1;
            while (line[i] != 34) {
                ++i;
            }
            j = ++i;
            while (line[j] != 34) {
                ++j;
            }
            this.ficheroSalida[1] = new String(line, i, j - i);
            linea = lineasFichero.nextToken();
            tokens = new StringTokenizer(linea, "=");
            tokens.nextToken();
            this.semilla = Long.parseLong(tokens.nextToken().substring(1));
            linea = lineasFichero.nextToken();
            tokens = new StringTokenizer(linea, "=");
            tokens.nextToken();
            this.tamPoblacion = Integer.parseInt(tokens.nextToken().substring(1));
            linea = lineasFichero.nextToken();
            tokens = new StringTokenizer(linea, "=");
            tokens.nextToken();
            this.nEval = Double.parseDouble(tokens.nextToken().substring(1));
            linea = lineasFichero.nextToken();
            tokens = new StringTokenizer(linea, "=");
            tokens.nextToken();
            this.pCross = Double.parseDouble(tokens.nextToken().substring(1));
            linea = lineasFichero.nextToken();
            tokens = new StringTokenizer(linea, "=");
            tokens.nextToken();
            this.pMut = Double.parseDouble(tokens.nextToken().substring(1));
            linea = lineasFichero.nextToken();
            tokens = new StringTokenizer(linea, "=");
            tokens.nextToken();
            this.kNeigh = Integer.parseInt(tokens.nextToken().substring(1));
            linea = lineasFichero.nextToken();
            tokens = new StringTokenizer(linea, "=");
            tokens.nextToken();
            this.distanceEu = tokens.nextToken().substring(1).equalsIgnoreCase("Euclidean");
            linea = lineasFichero.nextToken();
            tokens = new StringTokenizer(linea, "=");
            tokens.nextToken();
            this.PopulationSize = Integer.parseInt(tokens.nextToken().substring(1));
            linea = lineasFichero.nextToken();
            tokens = new StringTokenizer(linea, "=");
            tokens.nextToken();
            this.MaxIter = Integer.parseInt(tokens.nextToken().substring(1));
            linea = lineasFichero.nextToken();
            tokens = new StringTokenizer(linea, "=");
            tokens.nextToken();
            this.iterSFGSS = Integer.parseInt(tokens.nextToken().substring(1));
            linea = lineasFichero.nextToken();
            tokens = new StringTokenizer(linea, "=");
            tokens.nextToken();
            this.iterSFHC = Integer.parseInt(tokens.nextToken().substring(1));
            linea = lineasFichero.nextToken();
            tokens = new StringTokenizer(linea, "=");
            tokens.nextToken();
            this.Fl = Double.parseDouble(tokens.nextToken().substring(1));
            linea = lineasFichero.nextToken();
            tokens = new StringTokenizer(linea, "=");
            tokens.nextToken();
            this.Fu = Double.parseDouble(tokens.nextToken().substring(1));
            this.tau = new double[4];
            linea = lineasFichero.nextToken();
            tokens = new StringTokenizer(linea, "=");
            tokens.nextToken();
            this.tau[0] = Double.parseDouble(tokens.nextToken().substring(1));
            linea = lineasFichero.nextToken();
            tokens = new StringTokenizer(linea, "=");
            tokens.nextToken();
            this.tau[1] = Double.parseDouble(tokens.nextToken().substring(1));
            linea = lineasFichero.nextToken();
            tokens = new StringTokenizer(linea, "=");
            tokens.nextToken();
            this.tau[2] = Double.parseDouble(tokens.nextToken().substring(1));
            linea = lineasFichero.nextToken();
            tokens = new StringTokenizer(linea, "=");
            tokens.nextToken();
            this.tau[3] = Double.parseDouble(tokens.nextToken().substring(1));
            linea = lineasFichero.nextToken();
            tokens = new StringTokenizer(linea, "=");
            tokens.nextToken();
            this.Strategy = Integer.parseInt(tokens.nextToken().substring(1));
            System.out.print("\nIsaac dice:  tau3" + this.tau[3] + "\n");
        }
    }
}

