
<!-- README.md is generated from README.Rmd. Please edit that file -->

# guardianapi

[![License:
MIT](https://img.shields.io/badge/License-MIT-blue.svg)](https://opensource.org/licenses/MIT)
[![CRAN
status](https://www.r-pkg.org/badges/version/guardianapi)](https://cran.r-project.org/package=guardianapi)
[![GitHub
tag](https://img.shields.io/github/tag/evanodell/guardianapi.svg)](https://github.com/evanodell/guardianapi)
[![](https://cranlogs.r-pkg.org/badges/grand-total/guardianapi)](https://dgrtwo.shinyapps.io/cranview/)
[![AppVeyor build
status](https://ci.appveyor.com/api/projects/status/github/evanodell/guardianapi?branch=master&svg=true)](https://ci.appveyor.com/project/evanodell/guardianapi)
[![Travis build
status](https://travis-ci.org/evanodell/guardianapi.svg?branch=master)](https://travis-ci.org/evanodell/guardianapi)
[![Coverage
status](https://codecov.io/gh/evanodell/guardianapi/branch/master/graph/badge.svg)](https://codecov.io/github/evanodell/guardianapi?branch=master)
[![DOI](https://zenodo.org/badge/167837281.svg)](https://zenodo.org/badge/latestdoi/167837281)

Access to the Guardian open API
<https://open-platform.theguardian.com/>, containing all articles
published in the [Guardian](https://www.theguardian.com/) from 1999 to
the present. An API key is required, sign up
[here](https://open-platform.theguardian.com/access/).

## Installation

`guardianapi` is available on CRAN:

``` r
install.packages("guardianapi")
```

You can install the development version `guardianapi` from github with:

``` r
# install.packages("devtools")
devtools::install_github("evanodell/guardianapi")
```

## Usage

Save your API key as the environmental variable `GU_API_KEY`, or use the
`gu_api_key()` function to set a key for a single session.

`guardianapi` contains functions to query and retrieve articles, tags,
editions and sections. For example, return all tags containing the
string “apple”, which includes both the technology company and Fiona
Apple, amongst others.

``` r
library(guardianapi)

tags1 <- gu_tags(query = "apple")
#> Retrieving page 1

tibble::glimpse(tags1)
#> Observations: 10
#> Variables: 13
#> $ id               <chr> "technology/apple", "technology/apple-tv", "tec…
#> $ type             <chr> "keyword", "keyword", "keyword", "contributor",…
#> $ section_id       <chr> "technology", "technology", "technology", NA, "…
#> $ section_name     <chr> "Technology", "Technology", "Technology", NA, "…
#> $ web_title        <chr> "Apple", "Apple TV", "Apple WWDC", "Emily Apple…
#> $ web_url          <chr> "https://www.theguardian.com/technology/apple",…
#> $ api_url          <chr> "https://content.guardianapis.com/technology/ap…
#> $ references       <list> [<data.frame[1 x 2]>, <data.frame[0 x 0]>, <da…
#> $ bio              <chr> NA, NA, NA, "<p>Emily Apple is the co-founder o…
#> $ byline_image_url <chr> NA, NA, NA, "https://static.guim.co.uk/sys-imag…
#> $ first_name       <chr> NA, NA, NA, "apple", NA, NA, NA, NA, NA, "chia-…
#> $ last_name        <chr> NA, NA, NA, "emily", NA, NA, NA, NA, NA, "(appl…
#> $ description      <chr> NA, NA, NA, NA, NA, NA, NA, "Guardian journalis…
```

Return all articles with the string “relationships” and the tag
“lifeandstyle/sex” from December 2018:

``` r
relations_sex <- gu_content(query = "relationships", from_date = "2018-12-01",
                            to_date = "2018-12-31", tag = "lifeandstyle/sex")
#> Retrieving page 1

tibble::glimpse(relations_sex)
#> Observations: 5
#> Variables: 40
#> $ id                               <chr> "lifeandstyle/2018/dec/10/im-in…
#> $ type                             <chr> "article", "article", "article"…
#> $ section_id                       <chr> "lifeandstyle", "lifeandstyle",…
#> $ section_name                     <chr> "Life and style", "Life and sty…
#> $ web_publication_date             <dttm> 2018-12-10 08:00:39, 2018-12-2…
#> $ web_title                        <chr> "I’m in a relationship with ano…
#> $ web_url                          <chr> "https://www.theguardian.com/li…
#> $ api_url                          <chr> "https://content.guardianapis.c…
#> $ tags                             <list> [<data.frame[10 x 13]>, <data.…
#> $ is_hosted                        <lgl> FALSE, FALSE, FALSE, FALSE, FAL…
#> $ pillar_id                        <chr> "pillar/lifestyle", "pillar/lif…
#> $ pillar_name                      <chr> "Lifestyle", "Lifestyle", "Life…
#> $ headline                         <chr> "I’m in a relationship with ano…
#> $ standfirst                       <chr> "We kiss and cuddle, but he won…
#> $ trail_text                       <chr> "We kiss and cuddle, but he won…
#> $ byline                           <chr> "Pamela Stephenson Connolly", "…
#> $ main                             <chr> "<figure class=\"element elemen…
#> $ body                             <chr> "<p><strong>Until last year, I …
#> $ newspaper_page_number            <chr> "7", "66", "83", NA, "44"
#> $ wordcount                        <chr> "387", "307", "2189", "759", "1…
#> $ comment_close_date               <dttm> 2018-12-13 08:00:39, 2018-12-2…
#> $ commentable                      <chr> "true", "true", "true", "false"…
#> $ first_publication_date           <dttm> 2018-12-10 08:00:39, 2018-12-2…
#> $ is_inappropriate_for_sponsorship <chr> "false", "false", "false", "fal…
#> $ is_premoderated                  <chr> "true", "true", "true", "false"…
#> $ last_modified                    <chr> "2018-12-10T08:00:39Z", "2018-1…
#> $ newspaper_edition_date           <date> 2018-12-10, 2018-12-22, 2018-1…
#> $ production_office                <chr> "UK", "UK", "UK", "UK", "UK"
#> $ publication                      <chr> "The Guardian", "The Guardian",…
#> $ short_url                        <chr> "https://gu.com/p/a5fad", "http…
#> $ should_hide_adverts              <chr> "false", "false", "false", "fal…
#> $ show_in_related_content          <chr> "true", "true", "true", "true",…
#> $ thumbnail                        <chr> "https://media.guim.co.uk/35fd3…
#> $ legally_sensitive                <chr> "false", "false", "false", "fal…
#> $ sensitive                        <chr> "true", NA, NA, NA, "true"
#> $ lang                             <chr> "en", "en", "en", "en", "en"
#> $ body_text                        <chr> "Until last year, I identified …
#> $ char_count                       <chr> "2192", "1729", "12190", "4404"…
#> $ should_hide_reader_revenue       <chr> "false", "false", "false", "fal…
#> $ show_affiliate_links             <chr> "false", "false", "false", "fal…
```

See the full package documentation at
[docs.evanodell.com/guardianapi](https://docs.evanodell.com/guardianapi).

## Meta

Please note that the ‘guardianapi’ project is released with a
[Contributor Code of
Conduct](https://github.com/evanodell/guardianapi/blob/master/CODE_OF_CONDUCT.md).
By contributing to this project, you agree to abide by its terms.

This package is not affiliated with or supported by The Guardian.
