/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling.disjunctive;

import choco.cp.solver.constraints.global.scheduling.AbstractResourceSConstraint;
import choco.cp.solver.constraints.global.scheduling.disjunctive.ExtendedBitSet;
import choco.kernel.common.opres.ssp.BellmanWithLists;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.ITask;
import choco.kernel.solver.variables.scheduling.TaskVar;
import java.util.List;

public class ForbiddenIntervals
extends AbstractResourceSConstraint {
    private final ExtendedBitSet forbidden;
    private final int load;

    public ForbiddenIntervals(Solver solver, String name, TaskVar[] taskvars, IntDomainVar upperBound) {
        super(solver, name, taskvars, upperBound);
        int[] p = new int[this.getNbTasks()];
        int l = 0;
        for (int i = 0; i < p.length; ++i) {
            IntDomainVar d = ((TaskVar)this.getTask(i)).duration();
            if (!d.isInstantiated()) {
                throw new SolverException("forbidden intervals are only available for resources with constant duration");
            }
            p[i] = d.getVal();
            l += p[i];
        }
        this.load = l;
        BellmanWithLists bell = new BellmanWithLists(p, this.load);
        bell.run();
        this.forbidden = new ExtendedBitSet(bell.getCoveredSet(), this.load);
    }

    @Override
    public void readOptions(List<String> options) {
    }

    private boolean checkHead(int head, int ub) {
        int before;
        int after;
        return !this.forbidden.get(head) && (after = this.load - (before = this.forbidden.prevSetBit(head))) + head > ub;
    }

    private void updateHead(int operation) throws ContradictionException {
        ITask t = this.getTask(operation);
        int ub = ((IntDomainVar[])this.vars)[this.indexUB].getSup();
        int head = ((TaskVar)t).getEST();
        if (this.checkHead(head, ub)) {
            this.rtasks[operation].updateEST(this.forbidden.nextSetBit(head));
        }
        if (this.checkHead(head = ((TaskVar)t).getECT(), ub)) {
            this.rtasks[operation].updateECT(this.forbidden.nextSetBit(head));
        }
    }

    private int checkTail(int tail, int ub) {
        int before;
        int after;
        if (!this.forbidden.get(tail) && tail > (after = ub - (this.load - (before = this.forbidden.prevSetBit(tail))))) {
            return after;
        }
        return Integer.MIN_VALUE;
    }

    private void updateTail(int operation) throws ContradictionException {
        ITask t = this.getTask(operation);
        int ub = ((IntDomainVar[])this.vars)[this.indexUB].getSup();
        int val = this.checkTail(((TaskVar)t).getLST(), ub);
        if (val >= 0) {
            this.rtasks[operation].updateLST(val);
        }
        if ((val = this.checkTail(((TaskVar)t).getLCT(), ub)) >= 0) {
            this.rtasks[operation].updateLCT(val);
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx < this.getNbTasks()) {
            this.updateHead(idx);
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx < this.getNbTasks()) {
            this.updateHead(idx);
            this.updateTail(idx);
        } else if (idx == this.indexUB) {
            this.propagate();
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx == this.indexUB) {
            this.propagate();
        } else if (idx >= this.startOffset) {
            this.updateTail(idx - this.startOffset);
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        for (int o = 0; o < this.getNbTasks(); ++o) {
            this.updateHead(o);
            this.updateTail(o);
        }
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int n = this.getNbTasks();
        int makespan = tuple[this.indexUB];
        for (int i = 0; i < n; ++i) {
            int end = tuple[this.startOffset + i];
            int tail = this.checkTail(end, makespan);
            if (!this.checkHead(tuple[i], makespan) && (tail < 0 || tail >= end)) continue;
            return false;
        }
        return true;
    }
}

