/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.extractors;

import java.util.function.IntToDoubleFunction;
import jdplus.sa.base.core.diagnostics.CombinedSeasonalityTests;
import jdplus.sa.base.core.diagnostics.GenericSaTests;
import jdplus.sa.base.core.diagnostics.ResidualSeasonalityTests;
import jdplus.sa.base.core.diagnostics.ResidualTradingDaysTests;
import jdplus.sa.base.core.tests.SpectralPeaks;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.information.InformationMapping;
import jdplus.toolkit.base.api.stats.AutoCovariances;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.core.regarima.tests.OneStepAheadForecastingTest;

public class GenericSaTestsExtractor
extends InformationMapping<GenericSaTests> {
    public static final String LOG_STAT = "logstat";
    public static final String LEVEL_STAT = "levelstat";
    public static final String IC_RATIO = "ic-ratio";
    public static final String IC_RATIO_HENDERSON = "ic-ratio-henderson";
    public static final String MSR_GLOBAL = "msr-global";
    public static final String MSR = "msr";

    public Class getSourceClass() {
        return GenericSaTests.class;
    }

    public GenericSaTestsExtractor() {
        this.delegate(null, CombinedSeasonalityTests.class, source -> source.combinedSeasonalityTests());
        this.delegate(null, OneStepAheadForecastingTest.class, source -> source.forecastingTest());
        this.set("seas-res-f", StatisticalTest.class, source -> {
            ResidualSeasonalityTests test = source.residualSeasonalityTestsOnResiduals();
            if (test != null) {
                return test.fTest();
            }
            return null;
        });
        this.set("seas-res-qs", StatisticalTest.class, source -> {
            ResidualSeasonalityTests test = source.residualSeasonalityTestsOnResiduals();
            if (test != null) {
                return test.qsTest();
            }
            return null;
        });
        this.set("seas-res-kw", StatisticalTest.class, source -> {
            ResidualSeasonalityTests test = source.residualSeasonalityTestsOnResiduals();
            if (test != null) {
                return test.kruskalWallisTest();
            }
            return null;
        });
        this.set("seas-res-friedman", StatisticalTest.class, source -> {
            ResidualSeasonalityTests test = source.residualSeasonalityTestsOnResiduals();
            if (test != null) {
                return test.friedmanTest();
            }
            return null;
        });
        this.set("seas-res-periodogram", StatisticalTest.class, source -> {
            ResidualSeasonalityTests test = source.residualSeasonalityTestsOnResiduals();
            if (test != null) {
                return test.periodogramTest();
            }
            return null;
        });
        this.set("seas-res-spectralpeaks", String.class, source -> {
            SpectralPeaks[] p;
            ResidualSeasonalityTests test = source.residualSeasonalityTestsOnResiduals();
            if (test != null && (p = test.spectralPeaks()) != null) {
                return SpectralPeaks.format(p);
            }
            return null;
        });
        this.set("seas-i-f", StatisticalTest.class, source -> {
            ResidualSeasonalityTests test = source.residualSeasonalityTestsOnIrregular();
            if (test != null) {
                return test.fTest();
            }
            return null;
        });
        this.set("seas-i-qs", StatisticalTest.class, source -> {
            ResidualSeasonalityTests test = source.residualSeasonalityTestsOnIrregular();
            if (test != null) {
                return test.qsTest();
            }
            return null;
        });
        this.set("seas-i-kw", StatisticalTest.class, source -> {
            ResidualSeasonalityTests test = source.residualSeasonalityTestsOnIrregular();
            if (test != null) {
                return test.kruskalWallisTest();
            }
            return null;
        });
        this.set("seas-i-periodogram", StatisticalTest.class, source -> {
            ResidualSeasonalityTests test = source.residualSeasonalityTestsOnIrregular();
            if (test != null) {
                return test.periodogramTest();
            }
            return null;
        });
        this.set("seas-i-friedman", StatisticalTest.class, source -> {
            ResidualSeasonalityTests test = source.residualSeasonalityTestsOnIrregular();
            if (test != null) {
                return test.friedmanTest();
            }
            return null;
        });
        this.set("seas-i-spectralpeaks", String.class, source -> {
            SpectralPeaks[] p;
            ResidualSeasonalityTests test = source.residualSeasonalityTestsOnIrregular();
            if (test != null && (p = test.spectralPeaks()) != null) {
                return SpectralPeaks.format(p);
            }
            return null;
        });
        this.set("seas-sa-f", StatisticalTest.class, source -> {
            ResidualSeasonalityTests test = source.residualSeasonalityTestsOnSa();
            if (test != null) {
                return test.fTest();
            }
            return null;
        });
        this.set("seas-sa-qs", StatisticalTest.class, source -> {
            ResidualSeasonalityTests test = source.residualSeasonalityTestsOnSa();
            if (test != null) {
                return test.qsTest();
            }
            return null;
        });
        this.set("seas-sa-kw", StatisticalTest.class, source -> {
            ResidualSeasonalityTests test = source.residualSeasonalityTestsOnSa();
            if (test != null) {
                return test.kruskalWallisTest();
            }
            return null;
        });
        this.set("seas-sa-friedman", StatisticalTest.class, source -> {
            ResidualSeasonalityTests test = source.residualSeasonalityTestsOnSa();
            if (test != null) {
                return test.friedmanTest();
            }
            return null;
        });
        this.set("seas-sa-periodogram", StatisticalTest.class, source -> {
            ResidualSeasonalityTests test = source.residualSeasonalityTestsOnSa();
            if (test != null) {
                return test.periodogramTest();
            }
            return null;
        });
        this.set("seas-sa-spectralpeaks", String.class, source -> {
            SpectralPeaks[] p;
            ResidualSeasonalityTests test = source.residualSeasonalityTestsOnSa();
            if (test != null && (p = test.spectralPeaks()) != null) {
                return SpectralPeaks.format(p);
            }
            return null;
        });
        this.set("seas-lin-f", StatisticalTest.class, source -> {
            ResidualSeasonalityTests test = source.seasonalityTestsOnLinearized();
            if (test != null) {
                return test.fTest();
            }
            return null;
        });
        this.set("seas-lin-qs", StatisticalTest.class, source -> {
            ResidualSeasonalityTests test = source.seasonalityTestsOnLinearized();
            if (test != null) {
                return test.qsTest();
            }
            return null;
        });
        this.set("seas-lin-kw", StatisticalTest.class, source -> {
            ResidualSeasonalityTests test = source.seasonalityTestsOnLinearized();
            if (test != null) {
                return test.kruskalWallisTest();
            }
            return null;
        });
        this.set("seas-lin-friedman", StatisticalTest.class, source -> {
            ResidualSeasonalityTests test = source.seasonalityTestsOnLinearized();
            if (test != null) {
                return test.friedmanTest();
            }
            return null;
        });
        this.set("seas-lin-periodogram", StatisticalTest.class, source -> {
            ResidualSeasonalityTests test = source.seasonalityTestsOnLinearized();
            if (test != null) {
                return test.periodogramTest();
            }
            return null;
        });
        this.set("seas-lin-spectralpeaks", String.class, source -> {
            SpectralPeaks[] p;
            ResidualSeasonalityTests test = source.seasonalityTestsOnLinearized();
            if (test != null && (p = test.spectralPeaks()) != null) {
                return SpectralPeaks.format(p);
            }
            return null;
        });
        this.set("seas-sa-ac1", Double.class, source -> {
            DoubleSeq dsa = source.getLsa().delta(1).getValues();
            IntToDoubleFunction ac = AutoCovariances.autoCorrelationFunction((DoubleSeq)dsa, (double)dsa.average());
            return ac.applyAsDouble(1);
        });
        this.set("td-sa-all", StatisticalTest.class, source -> {
            ResidualTradingDaysTests td = source.residualTradingDaysTests();
            if (td != null) {
                return td.saTest(false);
            }
            return null;
        });
        this.set("td-sa-last", StatisticalTest.class, source -> {
            ResidualTradingDaysTests td = source.residualTradingDaysTests();
            if (td != null) {
                return td.saTest(true);
            }
            return null;
        });
        this.set("td-i-all", StatisticalTest.class, source -> {
            ResidualTradingDaysTests td = source.residualTradingDaysTests();
            if (td != null) {
                return td.irrTest(false);
            }
            return null;
        });
        this.set("td-i-last", StatisticalTest.class, source -> {
            ResidualTradingDaysTests td = source.residualTradingDaysTests();
            if (td != null) {
                return td.irrTest(true);
            }
            return null;
        });
        this.set("td-res-all", StatisticalTest.class, source -> {
            ResidualTradingDaysTests td = source.residualTradingDaysTests();
            if (td != null) {
                return td.residualsTest(false);
            }
            return null;
        });
        this.set("td-res-last", StatisticalTest.class, source -> {
            ResidualTradingDaysTests td = source.residualTradingDaysTests();
            if (td != null) {
                return td.residualsTest(true);
            }
            return null;
        });
    }
}

