/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.AdditiveOutlier;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;

class AOFactory
implements RegressionVariableFactory<AdditiveOutlier> {
    static AOFactory FACTORY = new AOFactory();

    private AOFactory() {
    }

    @Override
    public boolean fill(AdditiveOutlier var, TsPeriod start, FastMatrix buffer, ProcessingLog log) {
        TsPeriod p = start.withDate(var.getPosition());
        int opos = start.until(p);
        if (opos >= 0 && opos < buffer.getRowsCount()) {
            buffer.set(opos, 0, 1.0);
        }
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(AdditiveOutlier var, D domain, FastMatrix buffer, ProcessingLog log) {
        long pos = domain.indexOf(var.getPosition());
        if (pos >= 0L) {
            buffer.set((int)pos, 0, 1.0);
        }
        return true;
    }
}

