/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.akf;

import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.UpdateInformation;
import jdplus.toolkit.base.core.ssf.akf.AugmentedState;
import jdplus.toolkit.base.core.ssf.akf.AugmentedUpdateInformation;
import jdplus.toolkit.base.core.ssf.akf.IQFilteringResults;
import jdplus.toolkit.base.core.ssf.akf.QAugmentation;
import jdplus.toolkit.base.core.ssf.likelihood.DiffuseLikelihood;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.PredictionErrorDecomposition;

public class QPredictionErrorDecomposition
extends PredictionErrorDecomposition
implements IQFilteringResults {
    private int nd;
    private int ncollapsed;
    private final QAugmentation Q = new QAugmentation();

    public QPredictionErrorDecomposition(boolean res) {
        super(res);
    }

    @Override
    public void prepare(ISsf ssf, int n) {
        super.prepare(ssf, n);
        this.nd = ssf.getDiffuseDim();
        this.Q.prepare(this.nd, 1);
    }

    @Override
    public void close(int pos) {
    }

    @Override
    public void clear() {
        super.clear();
        this.Q.clear();
        this.res = null;
    }

    @Override
    public void save(int t, AugmentedUpdateInformation pe) {
        if (pe.isMissing() || pe.getStatus() != UpdateInformation.Status.OBSERVATION) {
            return;
        }
        if (pe.isDiffuse()) {
            this.Q.update(pe);
        } else {
            super.save(t, pe);
        }
    }

    @Override
    public void save(int t, AugmentedState state, StateInfo info) {
    }

    @Override
    public boolean canCollapse() {
        return this.Q.canCollapse();
    }

    @Override
    public boolean collapse(int pos, AugmentedState state) {
        if (this.Q.collapse(state)) {
            this.ncollapsed = pos;
            return true;
        }
        return false;
    }

    @Override
    public int getCollapsingPosition() {
        return this.ncollapsed;
    }

    @Override
    public QAugmentation getAugmentation() {
        return this.Q;
    }

    @Override
    public DiffuseLikelihood likelihood(boolean scalingfactor) {
        DiffuseLikelihood ll = this.Q.likelihood(scalingfactor);
        return ll.add(super.likelihood(scalingfactor));
    }
}

