/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.api.timeseries;

import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import lombok.Generated;
import lombok.NonNull;

@Deprecated
public final class InternalFixme {
    private static final int[] CUMULATEDMONTHDAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};

    public static int getAsInt(TsUnit freq) {
        return OldFreq.of(freq).toInt();
    }

    public static int getId(TsPeriod p) {
        return (int)p.getId();
    }

    public static int getPosition(TsPeriod p) {
        if (p.getEpoch() != TsPeriod.DEFAULT_EPOCH) {
            throw new UnsupportedOperationException("Unsupported origin");
        }
        OldFreq freq = OldFreq.of(p.getUnit());
        return (p.start().getMonthValue() - 1) * freq.toInt() / 12;
    }

    public static int getCumulatedMonthDays(int month) {
        return CUMULATEDMONTHDAYS[month];
    }

    @Generated
    private InternalFixme() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static enum OldFreq {
        Undefined(0, TsUnit.UNDEFINED),
        Yearly(1, TsUnit.P1Y),
        HalfYearly(2, TsUnit.P6M),
        Quarterly(4, TsUnit.P3M),
        Monthly(12, TsUnit.P1M);

        final int annualFrequency;
        final TsUnit freq;

        public int toInt() {
            return this.annualFrequency;
        }

        @NonNull
        public static OldFreq parse(int value) throws IllegalArgumentException {
            for (OldFreq o : OldFreq.values()) {
                if (o.annualFrequency != value) continue;
                return o;
            }
            throw new IllegalArgumentException("Cannot parse " + value);
        }

        public static OldFreq of(TsUnit freq) {
            switch (freq.getChronoUnit()) {
                case YEARS: {
                    if (freq.getAmount() != 1L) break;
                    return Yearly;
                }
                case MONTHS: {
                    if (freq.getAmount() == 6L) {
                        return HalfYearly;
                    }
                    if (freq.getAmount() == 3L) {
                        return Quarterly;
                    }
                    if (freq.getAmount() != 1L) break;
                    return Monthly;
                }
            }
            throw new UnsupportedOperationException(freq.toString());
        }

        @Generated
        private OldFreq(int annualFrequency, TsUnit freq) {
            this.annualFrequency = annualFrequency;
            this.freq = freq;
        }
    }
}

