/*
 * Decompiled with CFR 0.152.
 */
package af.statguitoolkit.gui.datatable;

import af.statguitoolkit.gui.datatable.CellValue;
import java.rmi.RemoteException;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.af.jhlir.call.RDataFrame;
import org.af.jhlir.call.RFactor;
import org.af.jhlir.call.RLegalName;
import org.af.jhlir.call.RVector;
import org.af.jhlir.call.RVectorFactor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTableModel
extends AbstractTableModel {
    protected RDataFrame df;

    public DataTableModel(RDataFrame df) {
        this.df = df;
    }

    @Override
    public int getColumnCount() {
        return this.df.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.df.getRowCount();
    }

    @Override
    public String getColumnName(int col) {
        return this.df.getColName(col);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return CellValue.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.getDataFrame().setValue(row, col, value);
        this.fireTableChanged(new TableModelEvent(this, row));
    }

    @Override
    public CellValue getValueAt(int row, int col) {
        return new CellValue(this.df.get(row, col), this.df.getCol(col));
    }

    public void addRow(int row) throws RemoteException {
        this.df.addRow(row);
        this.fireTableRowsInserted(row, row);
    }

    public void addRow(int row, RLegalName name) throws RemoteException {
        this.df.addRow(row, name);
        this.fireTableRowsInserted(row, row);
    }

    public void addCol(int col, RLegalName name, RVector v) throws RemoteException {
        this.df.addCol(col, name, v);
        this.fireTableStructureChanged();
    }

    public void addCol(int col, RLegalName name, RFactor v) throws RemoteException {
        this.df.addCol(col, name, v);
        this.fireTableStructureChanged();
    }

    public void addCol(RLegalName name, RVectorFactor v) throws RemoteException {
        this.df.addCol(name, v);
        this.fireTableStructureChanged();
    }

    public void delRow(int row) throws RemoteException {
        this.df.delRow(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void delCol(int col) throws RemoteException {
        this.df.delCol(col);
        this.fireTableStructureChanged();
    }

    public RDataFrame getDataFrame() {
        return this.df;
    }
}

