## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ---- eval=FALSE--------------------------------------------------------------
#  install.packages("qwalkr")

## ---- eval=FALSE--------------------------------------------------------------
#  # install.packages("devtools")
#  devtools::install_github("vitormarquesr/qwalkr")

## -----------------------------------------------------------------------------
library(qwalkr)


## -----------------------------------------------------------------------------

K3 <- rbind(c(0, 1, 1),
           c(1, 0, 1),
           c(1, 1, 0))
w <- ctqwalk(hamiltonian = K3)

## -----------------------------------------------------------------------------
w

## -----------------------------------------------------------------------------
A <- rbind(c(0, 1, 1),
           c(1, 0, 1),
           c(1, 1, 0))

s <- spectral(A)


## -----------------------------------------------------------------------------
s

## -----------------------------------------------------------------------------

get_eigspace(s, id = 2)


## -----------------------------------------------------------------------------

get_eigspace(s, id=1)


## -----------------------------------------------------------------------------

E2 <- get_eigproj(s, id=2)
E2


## -----------------------------------------------------------------------------

tr(E2)


## -----------------------------------------------------------------------------
E1 <- get_eigproj(s, id=1)
E1

tr(E1)


## -----------------------------------------------------------------------------
w

get_eigspace(w, id=2)

class(w)


## -----------------------------------------------------------------------------
unitary_matrix(w, t=pi/3)


## -----------------------------------------------------------------------------
mixing_matrix(w, t=pi/3)


## -----------------------------------------------------------------------------
avg_matrix(w)


## -----------------------------------------------------------------------------
set.seed(10)
gavg_matrix(w, R=rexp(1000))


