/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.monitors;

import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.chocosolver.solver.Solver;

public class SolvingStatisticsFlow {
    private static final LinkedHashMap<String, Function<Solver, String>> elements = new LinkedHashMap();
    private final Solver solver;

    public SolvingStatisticsFlow(Solver solver) {
        this.solver = solver;
    }

    public String toJSON() {
        return SolvingStatisticsFlow.toJSON(this.solver);
    }

    public static String toJSON(Solver solver) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        elements.forEach((k, v) -> sb.append("\"").append((String)k).append("\":\"").append((String)v.apply(solver)).append("\","));
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }

    private static String toHHmmss(long etime) {
        return String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(etime), TimeUnit.MILLISECONDS.toMinutes(etime) % TimeUnit.HOURS.toMinutes(1L), TimeUnit.MILLISECONDS.toSeconds(etime) % TimeUnit.MINUTES.toSeconds(1L));
    }

    private static String memory(Solver solver) {
        try {
            long mem = solver.getModel().getEstimatedMemory();
            return String.format("%d", mem);
        }
        catch (Exception e) {
            return "-1";
        }
    }

    static {
        elements.put("variables", solver -> Long.toString(solver.getModel().getNbVars()));
        elements.put("constraints", solver -> Long.toString(solver.getModel().getNbCstrs()));
        elements.put("objective", solver -> solver.hasObjective() ? solver.getBestSolutionValue().toString() : "--");
        elements.put("solutions", solver -> Long.toString(solver.getSolutionCount()));
        elements.put("nodes", solver -> Long.toString(solver.getNodeCount()));
        elements.put("fails", solver -> Long.toString(solver.getFailCount()));
        elements.put("backtracks", solver -> Long.toString(solver.getBackTrackCount()));
        elements.put("backjumps", solver -> Long.toString(solver.getBackjumpCount()));
        elements.put("restarts", solver -> Long.toString(solver.getRestartCount()));
        elements.put("fixpoints", solver -> Long.toString(solver.getFixpointCount()));
        elements.put("depth", solver -> Long.toString(solver.getMeasures().getCurrentDepth()));
        elements.put("time", solver -> SolvingStatisticsFlow.toHHmmss((long)(solver.getTimeCount() * 1000.0f)));
        elements.put("memory", SolvingStatisticsFlow::memory);
    }
}

