/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier;

import dmLab.array.FArray;
import dmLab.experiment.ExperimentParams;
import dmLab.mcfs.mcfsEngine.MCFSAutoParams;
import dmLab.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

public abstract class Params {
    protected String fileType = "cfg";
    public boolean verbose = false;

    public Params() {
        this.setDefault();
    }

    public abstract boolean setDefault();

    public abstract boolean check(FArray var1);

    protected abstract boolean update(Properties var1);

    /*
     * WARNING - void declaration
     */
    protected final void set$703ae1fd(ExperimentParams p) {
        void var1_1;
        this.fileType = p.fileType;
        this.verbose = var1_1.verbose;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean load(String path, String inputFileName) {
        void var3_4;
        Properties properties = new Properties();
        if (path == null || inputFileName == null) {
            return this.setDefault();
        }
        String myPath = "";
        String ext = FileUtils.getFileExtension(inputFileName);
        if (path.length() != 0) {
            myPath = path + "//";
        }
        String filePath = ext.equalsIgnoreCase(this.fileType) ? myPath + inputFileName : myPath + inputFileName + "." + this.fileType;
        try {
            FileInputStream cfgFile = new FileInputStream(filePath);
            properties.load(cfgFile);
            cfgFile.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Config file: '" + filePath + "' not found. Default params will be used.");
            return this.setDefault();
        }
        catch (IOException e) {
            void var2_3;
            void var1_1;
            System.err.println("Error: Loading config file. File" + (String)var1_1);
            var2_3.printStackTrace();
            return false;
        }
        this.verbose = Boolean.valueOf(properties.getProperty("verbose", "false"));
        return this.update((Properties)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean save(String path, String filename) {
        String cfgFilePath = path + "//" + filename + "." + this.fileType;
        if (path.length() == 0) {
            void var2_4;
            cfgFilePath = (String)var2_4 + this.fileType;
        }
        File cfgFile = new File(cfgFilePath);
        try {
            FileWriter writer = new FileWriter(cfgFile);
        }
        catch (IOException e) {
            System.err.println("Error: Cannot create the file. File: " + cfgFilePath);
            e.printStackTrace();
            return false;
        }
        try {
            e.write(this.toString());
            e.close();
        }
        catch (IOException e) {
            void var1_3;
            void var3_5;
            System.err.println("Error: Saving and Closing config file. File: " + (String)var3_5);
            var1_3.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append("verbose=" + this.verbose).append('\n');
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String intParamToString(int paramValue, String paramName) {
        void var2_2;
        int n;
        StringBuffer tmp = new StringBuffer();
        if (paramValue > 0) {
            tmp.append(paramName).append(" is ON");
        } else if (paramValue == 0) {
            tmp.append(paramName).append(" is OFF");
        } else if (n == MCFSAutoParams.AUTO) {
            tmp.append(paramName).append(" is AUTO");
        } else {
            void var1_1;
            tmp.append((String)var1_1).append(" is Unknown");
        }
        return var2_2.toString();
    }
}

