/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine.metadata;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.dataengine.interfaces.IMetadataSource;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGArray;
import com.amazon.redshift.dataengine.PGResultSet;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;

public class PGProcedureColumnsMetadatSourceFromQuery
extends PGResultSet
implements IMetadataSource {
    private int m_paramsnumbers = 0;
    private int m_paramsIndex = -1;
    private String[] m_paramsOids;
    private String[] m_paramsNames;

    public PGProcedureColumnsMetadatSourceFromQuery(PGMessagingContext pGMessagingContext, int n, ILogger iLogger) {
        super(pGMessagingContext, iLogger);
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return super.getData(0, l, l2, dataWrapper);
            }
            case SCHEMA_NAME: {
                return super.getData(1, l, l2, dataWrapper);
            }
            case PROCEDURE_NAME: {
                return super.getData(2, l, l2, dataWrapper);
            }
            case COLUMN_NAME: {
                if (0 == this.m_paramsIndex) {
                    return super.getData(3, l, l2, dataWrapper);
                }
                if (this.m_paramsnumbers > 1) {
                    if (0 == this.m_paramsNames.length) {
                        dataWrapper.setVarChar("$" + Integer.toString(this.m_paramsIndex));
                    } else {
                        dataWrapper.setVarChar(this.m_paramsNames[this.m_paramsIndex - 1]);
                    }
                    return false;
                }
            }
            case PROCEDURE_COLUMN_TYPE: {
                if (0 == this.m_paramsIndex) {
                    return super.getData(4, l, l2, dataWrapper);
                }
                if (this.m_paramsnumbers > 1) {
                    dataWrapper.setSmallInt(1);
                    return false;
                }
            }
            case DATA_TYPE: {
                if (0 == this.m_paramsIndex) {
                    super.getData(5, l, l2, dataWrapper);
                    try {
                        dataWrapper.setSmallInt(PGDataTypeUtilities.oidToSQLType(dataWrapper.getBigInt().intValue()));
                    }
                    catch (IncorrectTypeException incorrectTypeException) {
                        throw DSIDriver.s_DSIMessages.createGeneralException(PGJDBCMessageKey.PG_CATALOG_FUNCTION_ERR.name(), (Throwable)incorrectTypeException, ExceptionType.DATA);
                    }
                    return false;
                }
                if (this.m_paramsnumbers > 1) {
                    dataWrapper.setSmallInt(PGDataTypeUtilities.oidToSQLType(Integer.parseInt(this.m_paramsOids[this.m_paramsIndex - 1])));
                    return false;
                }
            }
            case DATA_TYPE_NAME: {
                if (0 == this.m_paramsIndex) {
                    super.getData(5, l, l2, dataWrapper);
                    try {
                        int n = PGDataTypeUtilities.oidToSQLType(dataWrapper.getBigInt().intValue());
                        dataWrapper.setVarChar(PGDataTypeUtilities.sqlTypeToString((short)n));
                    }
                    catch (IncorrectTypeException incorrectTypeException) {
                        throw DSIDriver.s_DSIMessages.createGeneralException(PGJDBCMessageKey.PG_CATALOG_FUNCTION_ERR.name(), (Throwable)incorrectTypeException, ExceptionType.DATA);
                    }
                    return false;
                }
                if (this.m_paramsnumbers > 1) {
                    int n = PGDataTypeUtilities.oidToSQLType(Integer.parseInt(this.m_paramsOids[this.m_paramsIndex - 1]));
                    dataWrapper.setVarChar(PGDataTypeUtilities.sqlTypeToString((short)n));
                    return false;
                }
            }
            case COLUMN_SIZE: {
                return super.getData(6, l, l2, dataWrapper);
            }
            case BUFFER_LENGTH: {
                return super.getData(7, l, l2, dataWrapper);
            }
            case DECIMAL_DIGITS: {
                return super.getData(8, l, l2, dataWrapper);
            }
            case NUM_PREC_RADIX: {
                return super.getData(9, l, l2, dataWrapper);
            }
            case NULLABLE: {
                return super.getData(10, l, l2, dataWrapper);
            }
            case REMARKS: {
                return super.getData(11, l, l2, dataWrapper);
            }
            case COLUMN_DEF: {
                return super.getData(12, l, l2, dataWrapper);
            }
            case SQL_DATA_TYPE: {
                return super.getData(13, l, l2, dataWrapper);
            }
            case SQL_DATETIME_SUB: {
                return super.getData(14, l, l2, dataWrapper);
            }
            case CHAR_OCTET_LENGTH: {
                return super.getData(15, l, l2, dataWrapper);
            }
            case ORDINAL_POSITION: {
                dataWrapper.setInteger(this.m_paramsIndex);
                return false;
            }
            case IS_NULLABLE: {
                return super.getData(17, l, l2, dataWrapper);
            }
            case SPECIFIC_NAME: {
                return super.getData(18, l, l2, dataWrapper);
            }
            case IS_RESULT_SET: {
                dataWrapper.setBoolean(false);
                return false;
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), new String[]{metadataSourceColumnTag.toString()}, ExceptionType.DEFAULT);
    }

    @Override
    public boolean moveToNextRow() {
        boolean bl = false;
        try {
            if (this.m_paramsIndex == this.m_paramsnumbers - 1) {
                this.m_paramsIndex = 0;
                this.m_paramsnumbers = 1;
                this.m_paramsOids = new String[0];
                this.m_paramsNames = new String[0];
                bl = super.moveToNextRow();
                DataWrapper dataWrapper = new DataWrapper();
                super.getData(19, 0L, -1L, dataWrapper);
                String string = dataWrapper.getVarChar();
                if (null != string && !string.equals("")) {
                    this.m_paramsOids = string.split(" ");
                    this.m_paramsnumbers = this.m_paramsOids.length + 1;
                    this.m_paramsIndex = 0;
                    dataWrapper = new DataWrapper();
                    super.getData(20, 0L, -1L, dataWrapper);
                    PGArray pGArray = (PGArray)dataWrapper.getArray();
                    if (null != pGArray) {
                        String string2 = pGArray.getStringRepresentation();
                        string2 = string2.substring(1, string2.length() - 1);
                        this.m_paramsNames = string2.split(",");
                    }
                }
            } else {
                ++this.m_paramsIndex;
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }
}

