/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.rewrite.handler.PatternRule;
import org.eclipse.jetty.util.annotation.Name;

public class ResponsePatternRule
extends PatternRule {
    private int _code;
    private String _message;

    public ResponsePatternRule() {
        this(null, null, null);
    }

    public ResponsePatternRule(@Name(value="pattern") String pattern, @Name(value="code") String code, @Name(value="message") String message) {
        super(pattern);
        this._handling = true;
        this._terminating = true;
        this.setCode(code);
        this.setMessage(message);
    }

    public void setCode(String code) {
        this._code = code == null ? 0 : Integer.parseInt(code);
    }

    public void setMessage(String message) {
        this._message = message;
    }

    @Override
    public String apply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this._code > 0) {
            if (this._message != null && !this._message.isEmpty()) {
                response.sendError(this._code, this._message);
            } else {
                response.setStatus(this._code);
            }
        }
        return target;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this._code + "," + this._message + "]";
    }
}

