/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.asterix.common.config.CompilerProperties;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.config.OptimizationConfUtil;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.indexing.IndexingConstants;
import org.apache.asterix.external.operators.ExternalIndexBulkLoadOperatorDescriptor;
import org.apache.asterix.external.operators.ExternalIndexBulkModifyOperatorDescriptor;
import org.apache.asterix.external.operators.ExternalScanOperatorDescriptor;
import org.apache.asterix.formats.base.IDataFormat;
import org.apache.asterix.formats.nontagged.BinaryBooleanInspector;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.formats.nontagged.TypeTraitProvider;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.lock.ExternalDatasetsRegistry;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.ExternalIndexingOperations;
import org.apache.asterix.metadata.utils.ISecondaryIndexOperationsHelper;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.metadata.utils.SampleOperationsHelper;
import org.apache.asterix.metadata.utils.SecondaryArrayIndexBTreeOperationsHelper;
import org.apache.asterix.metadata.utils.SecondaryBTreeOperationsHelper;
import org.apache.asterix.metadata.utils.SecondaryInvertedIndexOperationsHelper;
import org.apache.asterix.metadata.utils.SecondaryRTreeOperationsHelper;
import org.apache.asterix.metadata.utils.TypeUtil;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.AbstractFunctionDescriptor;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionManager;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.functions.AndDescriptor;
import org.apache.asterix.runtime.evaluators.functions.IsUnknownDescriptor;
import org.apache.asterix.runtime.evaluators.functions.NotDescriptor;
import org.apache.asterix.runtime.evaluators.functions.OrDescriptor;
import org.apache.asterix.runtime.operators.LSMIndexBulkLoadOperatorDescriptor;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraintHelper;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.data.ISerializerDeserializerProvider;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.evaluators.ColumnAccessEvalFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.AlgebricksMetaOperatorDescriptor;
import org.apache.hyracks.algebricks.runtime.operators.std.AssignRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.std.StreamSelectRuntimeFactory;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.hyracks.dataflow.std.sort.ExternalSortOperatorDescriptor;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexDropOperatorDescriptor;
import org.apache.hyracks.storage.am.common.dataflow.TreeIndexBulkLoadOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicyFactory;

public abstract class SecondaryIndexOperationsHelper
implements ISecondaryIndexOperationsHelper {
    protected final MetadataProvider metadataProvider;
    protected final Dataset dataset;
    protected final Index index;
    protected final ARecordType itemType;
    protected final ARecordType metaType;
    protected final ARecordType enforcedItemType;
    protected final ARecordType enforcedMetaType;
    protected ISerializerDeserializer metaSerde;
    protected ISerializerDeserializer payloadSerde;
    protected IFileSplitProvider primaryFileSplitProvider;
    protected AlgebricksPartitionConstraint primaryPartitionConstraint;
    protected IFileSplitProvider secondaryFileSplitProvider;
    protected AlgebricksPartitionConstraint secondaryPartitionConstraint;
    protected boolean anySecondaryKeyIsNullable = false;
    protected long numElementsHint;
    protected IBinaryComparatorFactory[] primaryComparatorFactories;
    protected int[] primaryBloomFilterKeyFields;
    protected RecordDescriptor primaryRecDesc;
    protected IBinaryComparatorFactory[] secondaryComparatorFactories;
    protected ITypeTraits[] secondaryTypeTraits;
    protected int[] secondaryBloomFilterKeyFields;
    protected RecordDescriptor secondaryRecDesc;
    protected IScalarEvaluatorFactory[] secondaryFieldAccessEvalFactories;
    protected ILSMMergePolicyFactory mergePolicyFactory;
    protected Map<String, String> mergePolicyProperties;
    protected RecordDescriptor enforcedRecDesc;
    protected int numFilterFields;
    protected List<String> filterFieldName;
    protected ITypeTraits[] filterTypeTraits;
    protected IBinaryComparatorFactory[] filterCmpFactories;
    protected int[] secondaryFilterFields;
    protected int[] primaryFilterFields;
    protected int[] primaryBTreeFields;
    protected int[] secondaryBTreeFields;
    protected List<ExternalFile> externalFiles;
    protected int numPrimaryKeys;
    protected final SourceLocation sourceLoc;
    protected final int sortNumFrames;

    protected SecondaryIndexOperationsHelper(Dataset dataset, Index index, MetadataProvider metadataProvider, SourceLocation sourceLoc) throws AlgebricksException {
        this.dataset = dataset;
        this.index = index;
        this.metadataProvider = metadataProvider;
        this.itemType = (ARecordType)metadataProvider.findType(dataset.getItemTypeDataverseName(), dataset.getItemTypeName());
        this.metaType = DatasetUtil.getMetaType(metadataProvider, dataset);
        Pair<ARecordType, ARecordType> enforcedTypes = SecondaryIndexOperationsHelper.getEnforcedType(index, this.itemType, this.metaType);
        this.enforcedItemType = (ARecordType)enforcedTypes.first;
        this.enforcedMetaType = (ARecordType)enforcedTypes.second;
        this.sourceLoc = sourceLoc;
        this.sortNumFrames = SecondaryIndexOperationsHelper.getSortNumFrames(metadataProvider, sourceLoc);
    }

    private static Pair<ARecordType, ARecordType> getEnforcedType(Index index, ARecordType aRecordType, ARecordType metaRecordType) throws AlgebricksException {
        return index.getIndexDetails().isOverridingKeyFieldTypes() ? TypeUtil.createEnforcedType(aRecordType, metaRecordType, Collections.singletonList(index)) : new Pair(null, null);
    }

    private static int getSortNumFrames(MetadataProvider metadataProvider, SourceLocation sourceLoc) throws AlgebricksException {
        return OptimizationConfUtil.getSortNumFrames((CompilerProperties)metadataProvider.getApplicationContext().getCompilerProperties(), metadataProvider.getConfig(), (SourceLocation)sourceLoc);
    }

    public static ISecondaryIndexOperationsHelper createIndexOperationsHelper(Dataset dataset, Index index, MetadataProvider metadataProvider, SourceLocation sourceLoc) throws AlgebricksException {
        ISecondaryIndexOperationsHelper indexOperationsHelper;
        switch (index.getIndexType()) {
            case ARRAY: {
                indexOperationsHelper = new SecondaryArrayIndexBTreeOperationsHelper(dataset, index, metadataProvider, sourceLoc);
                break;
            }
            case BTREE: {
                indexOperationsHelper = new SecondaryBTreeOperationsHelper(dataset, index, metadataProvider, sourceLoc);
                break;
            }
            case RTREE: {
                indexOperationsHelper = new SecondaryRTreeOperationsHelper(dataset, index, metadataProvider, sourceLoc);
                break;
            }
            case SINGLE_PARTITION_WORD_INVIX: 
            case SINGLE_PARTITION_NGRAM_INVIX: 
            case LENGTH_PARTITIONED_WORD_INVIX: 
            case LENGTH_PARTITIONED_NGRAM_INVIX: {
                indexOperationsHelper = new SecondaryInvertedIndexOperationsHelper(dataset, index, metadataProvider, sourceLoc);
                break;
            }
            case SAMPLE: {
                indexOperationsHelper = new SampleOperationsHelper(dataset, index, metadataProvider, sourceLoc);
                break;
            }
            default: {
                throw new CompilationException(ErrorCode.COMPILATION_UNKNOWN_INDEX_TYPE, sourceLoc, new Serializable[]{index.getIndexType()});
            }
        }
        indexOperationsHelper.init();
        return indexOperationsHelper;
    }

    @Override
    public abstract JobSpecification buildCreationJobSpec() throws AlgebricksException;

    @Override
    public abstract JobSpecification buildLoadingJobSpec() throws AlgebricksException;

    @Override
    public abstract JobSpecification buildCompactJobSpec() throws AlgebricksException;

    @Override
    public abstract JobSpecification buildDropJobSpec(Set<IndexDropOperatorDescriptor.DropOption> var1) throws AlgebricksException;

    protected abstract void setSecondaryRecDescAndComparators() throws AlgebricksException;

    protected abstract int getNumSecondaryKeys();

    @Override
    public void init() throws AlgebricksException {
        this.payloadSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)this.itemType);
        this.metaSerde = this.metaType == null ? null : SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)this.metaType);
        Pair<IFileSplitProvider, AlgebricksPartitionConstraint> secondarySplitsAndConstraint = this.metadataProvider.getSplitProviderAndConstraints(this.dataset, this.index.getIndexName());
        this.secondaryFileSplitProvider = (IFileSplitProvider)secondarySplitsAndConstraint.first;
        this.secondaryPartitionConstraint = (AlgebricksPartitionConstraint)secondarySplitsAndConstraint.second;
        this.numPrimaryKeys = this.dataset.getPrimaryKeys().size();
        if (this.dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            this.filterFieldName = DatasetUtil.getFilterField(this.dataset);
            this.numFilterFields = this.filterFieldName != null ? 1 : 0;
            Pair<IFileSplitProvider, AlgebricksPartitionConstraint> primarySplitsAndConstraint = this.metadataProvider.getSplitProviderAndConstraints(this.dataset);
            this.primaryFileSplitProvider = (IFileSplitProvider)primarySplitsAndConstraint.first;
            this.primaryPartitionConstraint = (AlgebricksPartitionConstraint)primarySplitsAndConstraint.second;
            this.setPrimaryRecDescAndComparators();
        }
        this.setSecondaryRecDescAndComparators();
        this.numElementsHint = this.metadataProvider.getCardinalityPerPartitionHint(this.dataset);
        Pair<ILSMMergePolicyFactory, Map<String, String>> compactionInfo = DatasetUtil.getMergePolicyFactory(this.dataset, this.metadataProvider.getMetadataTxnContext());
        this.mergePolicyFactory = (ILSMMergePolicyFactory)compactionInfo.first;
        this.mergePolicyProperties = (Map)compactionInfo.second;
        if (this.numFilterFields > 0) {
            this.setFilterTypeTraitsAndComparators();
        }
    }

    private void setFilterTypeTraitsAndComparators() throws AlgebricksException {
        int i;
        this.filterTypeTraits = new ITypeTraits[this.numFilterFields];
        this.filterCmpFactories = new IBinaryComparatorFactory[this.numFilterFields];
        this.secondaryFilterFields = new int[this.numFilterFields];
        this.primaryFilterFields = new int[this.numFilterFields];
        this.primaryBTreeFields = new int[this.numPrimaryKeys + 1];
        this.secondaryBTreeFields = new int[this.getNumSecondaryKeys() + this.numPrimaryKeys];
        for (i = 0; i < this.primaryBTreeFields.length; ++i) {
            this.primaryBTreeFields[i] = i;
        }
        for (i = 0; i < this.secondaryBTreeFields.length; ++i) {
            this.secondaryBTreeFields[i] = i;
        }
        IAType type = ((InternalDatasetDetails)this.dataset.getDatasetDetails()).getFilterSourceIndicator() == 0 ? this.itemType.getSubFieldType(this.filterFieldName, (IAType)this.itemType) : this.metaType.getSubFieldType(this.filterFieldName, (IAType)this.metaType);
        this.filterCmpFactories[0] = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)type, true);
        this.filterTypeTraits[0] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)type);
        this.secondaryFilterFields[0] = this.getNumSecondaryKeys() + this.numPrimaryKeys;
        this.primaryFilterFields[0] = this.numPrimaryKeys + 1;
    }

    private void setPrimaryRecDescAndComparators() throws AlgebricksException {
        List<List<String>> partitioningKeys = this.dataset.getPrimaryKeys();
        ISerializerDeserializer[] primaryRecFields = new ISerializerDeserializer[this.numPrimaryKeys + 1 + (this.dataset.hasMetaPart() ? 1 : 0)];
        ITypeTraits[] primaryTypeTraits = new ITypeTraits[this.numPrimaryKeys + 1 + (this.dataset.hasMetaPart() ? 1 : 0)];
        this.primaryComparatorFactories = new IBinaryComparatorFactory[this.numPrimaryKeys];
        this.primaryBloomFilterKeyFields = new int[this.numPrimaryKeys];
        ISerializerDeserializerProvider serdeProvider = this.metadataProvider.getDataFormat().getSerdeProvider();
        List<Integer> indicators = null;
        if (this.dataset.hasMetaPart()) {
            indicators = ((InternalDatasetDetails)this.dataset.getDatasetDetails()).getKeySourceIndicator();
        }
        for (int i = 0; i < this.numPrimaryKeys; ++i) {
            IAType keyType = indicators == null || indicators.get(i) == 0 ? this.itemType.getSubFieldType(partitioningKeys.get(i)) : this.metaType.getSubFieldType(partitioningKeys.get(i));
            primaryRecFields[i] = serdeProvider.getSerializerDeserializer((Object)keyType);
            this.primaryComparatorFactories[i] = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)keyType, true);
            primaryTypeTraits[i] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)keyType);
            this.primaryBloomFilterKeyFields[i] = i;
        }
        primaryRecFields[this.numPrimaryKeys] = this.payloadSerde;
        primaryTypeTraits[this.numPrimaryKeys] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)this.itemType);
        if (this.dataset.hasMetaPart()) {
            primaryRecFields[this.numPrimaryKeys + 1] = this.payloadSerde;
            primaryTypeTraits[this.numPrimaryKeys + 1] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)this.metaType);
        }
        this.primaryRecDesc = new RecordDescriptor(primaryRecFields, primaryTypeTraits);
    }

    protected IScalarEvaluatorFactory createFieldAccessor(ARecordType recordType, int recordColumn, List<String> fieldName) throws AlgebricksException {
        IFunctionManager funManger = this.metadataProvider.getFunctionManager();
        IDataFormat dataFormat = this.metadataProvider.getDataFormat();
        return dataFormat.getFieldAccessEvaluatorFactory(funManger, recordType, fieldName, recordColumn, this.sourceLoc);
    }

    protected IScalarEvaluatorFactory createFieldCast(IScalarEvaluatorFactory fieldEvalFactory, boolean isOverridingKeyFieldTypes, IAType enforcedRecordType, ARecordType recordType, IAType targetType) throws AlgebricksException {
        IScalarEvaluatorFactory castFieldEvalFactory;
        boolean castIndexedField;
        IFunctionManager funManger = this.metadataProvider.getFunctionManager();
        IDataFormat dataFormat = this.metadataProvider.getDataFormat();
        boolean bl = castIndexedField = isOverridingKeyFieldTypes && (!enforcedRecordType.equals(recordType) || IndexUtil.castDefaultNull(this.index));
        if (!castIndexedField) {
            return fieldEvalFactory;
        }
        if (IndexUtil.castDefaultNull(this.index)) {
            castFieldEvalFactory = this.createConstructorFunction(funManger, dataFormat, fieldEvalFactory, targetType);
        } else if (this.index.isEnforced()) {
            IScalarEvaluatorFactory[] castArg = new IScalarEvaluatorFactory[]{fieldEvalFactory};
            castFieldEvalFactory = this.createCastFunction(targetType, (IAType)BuiltinType.ANY, true, this.sourceLoc).createEvaluatorFactory(castArg);
        } else {
            IScalarEvaluatorFactory[] castArg = new IScalarEvaluatorFactory[]{fieldEvalFactory};
            castFieldEvalFactory = this.createCastFunction(targetType, (IAType)BuiltinType.ANY, false, this.sourceLoc).createEvaluatorFactory(castArg);
        }
        return castFieldEvalFactory;
    }

    protected IScalarEvaluatorFactory createConstructorFunction(IFunctionManager funManager, IDataFormat dataFormat, IScalarEvaluatorFactory fieldEvalFactory, IAType fieldType) throws AlgebricksException {
        IScalarEvaluatorFactory[] args;
        IAType targetType = TypeComputeUtils.getActualType((IAType)fieldType);
        Pair<FunctionIdentifier, IAObject> constructorWithFmt = IndexUtil.getTypeConstructorDefaultNull(this.index, targetType, this.sourceLoc);
        FunctionIdentifier typeConstructorFun = (FunctionIdentifier)constructorWithFmt.first;
        IFunctionDescriptor typeConstructor = funManager.lookupFunction(typeConstructorFun, this.sourceLoc);
        if (constructorWithFmt.second != null) {
            IScalarEvaluatorFactory fmtEvalFactory = dataFormat.getConstantEvalFactory((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)constructorWithFmt.second));
            args = new IScalarEvaluatorFactory[]{fieldEvalFactory, fmtEvalFactory};
        } else {
            args = new IScalarEvaluatorFactory[]{fieldEvalFactory};
        }
        typeConstructor.setSourceLocation(this.sourceLoc);
        return typeConstructor.createEvaluatorFactory(args);
    }

    protected AlgebricksMetaOperatorDescriptor createAssignOp(JobSpecification spec, int numSecondaryKeyFields, RecordDescriptor secondaryRecDesc) throws AlgebricksException {
        int i;
        int[] outColumns = new int[numSecondaryKeyFields + this.numFilterFields];
        int[] projectionList = new int[numSecondaryKeyFields + this.numPrimaryKeys + this.numFilterFields];
        for (int i2 = 0; i2 < numSecondaryKeyFields + this.numFilterFields; ++i2) {
            outColumns[i2] = this.numPrimaryKeys + i2;
        }
        int projCount = 0;
        for (i = 0; i < numSecondaryKeyFields; ++i) {
            projectionList[projCount++] = this.numPrimaryKeys + i;
        }
        i = 0;
        while (i < this.numPrimaryKeys) {
            projectionList[projCount++] = i++;
        }
        if (this.numFilterFields > 0) {
            projectionList[projCount] = this.numPrimaryKeys + numSecondaryKeyFields;
        }
        IScalarEvaluatorFactory[] sefs = new IScalarEvaluatorFactory[this.secondaryFieldAccessEvalFactories.length];
        for (int i3 = 0; i3 < this.secondaryFieldAccessEvalFactories.length; ++i3) {
            sefs[i3] = this.secondaryFieldAccessEvalFactories[i3];
        }
        AssignRuntimeFactory assign = new AssignRuntimeFactory(outColumns, sefs, projectionList);
        assign.setSourceLocation(this.sourceLoc);
        AlgebricksMetaOperatorDescriptor asterixAssignOp = new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 1, new IPushRuntimeFactory[]{assign}, new RecordDescriptor[]{secondaryRecDesc});
        asterixAssignOp.setSourceLocation(this.sourceLoc);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)asterixAssignOp, (AlgebricksPartitionConstraint)this.primaryPartitionConstraint);
        return asterixAssignOp;
    }

    protected AlgebricksMetaOperatorDescriptor createCastOp(JobSpecification spec, DatasetConfig.DatasetType dsType, boolean strictCast) throws AlgebricksException {
        int recordIdx;
        int[] outColumns = new int[1];
        int[] projectionList = new int[(this.dataset.hasMetaPart() ? 2 : 1) + this.numPrimaryKeys];
        if (dsType == DatasetConfig.DatasetType.EXTERNAL) {
            recordIdx = 0;
            outColumns[0] = 0;
        } else {
            recordIdx = this.numPrimaryKeys;
            outColumns[0] = this.numPrimaryKeys;
        }
        for (int i = 0; i <= this.numPrimaryKeys; ++i) {
            projectionList[i] = i;
        }
        if (this.dataset.hasMetaPart()) {
            projectionList[this.numPrimaryKeys + 1] = this.numPrimaryKeys + 1;
        }
        IScalarEvaluatorFactory[] castEvalFact = new IScalarEvaluatorFactory[]{new ColumnAccessEvalFactory(recordIdx)};
        IScalarEvaluatorFactory[] sefs = new IScalarEvaluatorFactory[]{this.createCastFunction(strictCast, this.sourceLoc).createEvaluatorFactory(castEvalFact)};
        AssignRuntimeFactory castAssign = new AssignRuntimeFactory(outColumns, sefs, projectionList);
        castAssign.setSourceLocation(this.sourceLoc);
        return new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 1, new IPushRuntimeFactory[]{castAssign}, new RecordDescriptor[]{this.enforcedRecDesc});
    }

    protected IFunctionDescriptor createCastFunction(boolean strictCast, SourceLocation sourceLoc) throws AlgebricksException {
        return this.createCastFunction((IAType)this.enforcedItemType, (IAType)this.itemType, strictCast, sourceLoc);
    }

    protected IFunctionDescriptor createCastFunction(IAType targetType, IAType inputType, boolean strictCast, SourceLocation sourceLoc) throws AlgebricksException {
        IFunctionDescriptor castFuncDesc = this.metadataProvider.getFunctionManager().lookupFunction(strictCast ? BuiltinFunctions.CAST_TYPE : BuiltinFunctions.CAST_TYPE_LAX, sourceLoc);
        castFuncDesc.setSourceLocation(sourceLoc);
        castFuncDesc.setImmutableStates(new Object[]{targetType, inputType});
        return castFuncDesc;
    }

    protected ExternalSortOperatorDescriptor createSortOp(JobSpecification spec, IBinaryComparatorFactory[] secondaryComparatorFactories, RecordDescriptor secondaryRecDesc) {
        int[] sortFields = new int[secondaryComparatorFactories.length];
        for (int i = 0; i < secondaryComparatorFactories.length; ++i) {
            sortFields[i] = i;
        }
        ExternalSortOperatorDescriptor sortOp = new ExternalSortOperatorDescriptor((IOperatorDescriptorRegistry)spec, this.sortNumFrames, sortFields, secondaryComparatorFactories, secondaryRecDesc);
        sortOp.setSourceLocation(this.sourceLoc);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)sortOp, (AlgebricksPartitionConstraint)this.primaryPartitionConstraint);
        return sortOp;
    }

    protected static boolean excludeUnknownKeys(Index index, Index.ValueIndexDetails details, boolean anySecKeyIsNullable) {
        return IndexUtil.excludesUnknowns(index) && (anySecKeyIsNullable || details.isOverridingKeyFieldTypes());
    }

    protected LSMIndexBulkLoadOperatorDescriptor createTreeIndexBulkLoadOp(JobSpecification spec, int[] fieldPermutation, IIndexDataflowHelperFactory dataflowHelperFactory, float fillFactor) {
        IndexDataflowHelperFactory primaryIndexDataflowHelperFactory = new IndexDataflowHelperFactory(this.metadataProvider.getStorageComponentProvider().getStorageManager(), this.primaryFileSplitProvider);
        LSMIndexBulkLoadOperatorDescriptor treeIndexBulkLoadOp = new LSMIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, this.secondaryRecDesc, fieldPermutation, fillFactor, false, this.numElementsHint, false, dataflowHelperFactory, (IIndexDataflowHelperFactory)primaryIndexDataflowHelperFactory, LSMIndexBulkLoadOperatorDescriptor.BulkLoadUsage.CREATE_INDEX, this.dataset.getDatasetId(), null);
        treeIndexBulkLoadOp.setSourceLocation(this.sourceLoc);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)treeIndexBulkLoadOp, (AlgebricksPartitionConstraint)this.secondaryPartitionConstraint);
        return treeIndexBulkLoadOp;
    }

    protected TreeIndexBulkLoadOperatorDescriptor createExternalIndexBulkLoadOp(JobSpecification spec, int[] fieldPermutation, IIndexDataflowHelperFactory dataflowHelperFactory, float fillFactor) {
        ExternalIndexBulkLoadOperatorDescriptor treeIndexBulkLoadOp = new ExternalIndexBulkLoadOperatorDescriptor((IOperatorDescriptorRegistry)spec, this.secondaryRecDesc, fieldPermutation, fillFactor, false, this.numElementsHint, false, dataflowHelperFactory, ExternalDatasetsRegistry.INSTANCE.getAndLockDatasetVersion(this.dataset, this.metadataProvider), null);
        treeIndexBulkLoadOp.setSourceLocation(this.sourceLoc);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)treeIndexBulkLoadOp, (AlgebricksPartitionConstraint)this.secondaryPartitionConstraint);
        return treeIndexBulkLoadOp;
    }

    public AlgebricksMetaOperatorDescriptor createFilterAllUnknownsSelectOp(JobSpecification spec, int numSecondaryKeyFields, RecordDescriptor secondaryRecDesc) throws AlgebricksException {
        return this.createFilterSelectOp(spec, numSecondaryKeyFields, secondaryRecDesc, OrDescriptor::new);
    }

    public AlgebricksMetaOperatorDescriptor createFilterAnyUnknownSelectOp(JobSpecification spec, int numSecondaryKeyFields, RecordDescriptor secondaryRecDesc) throws AlgebricksException {
        return this.createFilterSelectOp(spec, numSecondaryKeyFields, secondaryRecDesc, AndDescriptor::new);
    }

    public AlgebricksMetaOperatorDescriptor createCastFilterAnyUnknownSelectOp(JobSpecification spec, int numSecondaryKeyFields, RecordDescriptor secondaryRecDesc, List<IAType> castFieldTypes) throws AlgebricksException {
        return this.createFilterSelectOp(spec, numSecondaryKeyFields, secondaryRecDesc, AndDescriptor::new, castFieldTypes);
    }

    private AlgebricksMetaOperatorDescriptor createFilterSelectOp(JobSpecification spec, int numSecondaryKeyFields, RecordDescriptor secondaryRecDesc, Supplier<AbstractFunctionDescriptor> predicatesCombinerFuncSupplier) throws AlgebricksException {
        return this.createFilterSelectOp(spec, numSecondaryKeyFields, secondaryRecDesc, predicatesCombinerFuncSupplier, Collections.emptyList());
    }

    private AlgebricksMetaOperatorDescriptor createFilterSelectOp(JobSpecification spec, int numSecondaryKeyFields, RecordDescriptor secondaryRecDesc, Supplier<AbstractFunctionDescriptor> predicatesCombinerFuncSupplier, List<IAType> castFieldTypes) throws AlgebricksException {
        IScalarEvaluatorFactory selectCond;
        IScalarEvaluatorFactory[] predicateArgsEvalFactories = new IScalarEvaluatorFactory[numSecondaryKeyFields];
        NotDescriptor notDesc = new NotDescriptor();
        notDesc.setSourceLocation(this.sourceLoc);
        IsUnknownDescriptor isUnknownDesc = new IsUnknownDescriptor();
        isUnknownDesc.setSourceLocation(this.sourceLoc);
        for (int i = 0; i < numSecondaryKeyFields; ++i) {
            IScalarEvaluatorFactory notEvalFactory;
            ColumnAccessEvalFactory columnAccessEvalFactory;
            ColumnAccessEvalFactory evalFactory = columnAccessEvalFactory = new ColumnAccessEvalFactory(i);
            if (castFieldTypes != null && !castFieldTypes.isEmpty()) {
                IScalarEvaluatorFactory[] castArg = new IScalarEvaluatorFactory[]{columnAccessEvalFactory};
                evalFactory = this.createCastFunction(castFieldTypes.get(i), (IAType)BuiltinType.ANY, this.index.isEnforced(), this.sourceLoc).createEvaluatorFactory(castArg);
            }
            IScalarEvaluatorFactory isUnknownEvalFactory = isUnknownDesc.createEvaluatorFactory(new IScalarEvaluatorFactory[]{evalFactory});
            predicateArgsEvalFactories[i] = notEvalFactory = notDesc.createEvaluatorFactory(new IScalarEvaluatorFactory[]{isUnknownEvalFactory});
        }
        if (numSecondaryKeyFields > 1) {
            AbstractFunctionDescriptor predicatesCombiner = predicatesCombinerFuncSupplier.get();
            predicatesCombiner.setSourceLocation(this.sourceLoc);
            selectCond = predicatesCombiner.createEvaluatorFactory(predicateArgsEvalFactories);
        } else {
            selectCond = predicateArgsEvalFactories[0];
        }
        StreamSelectRuntimeFactory select = new StreamSelectRuntimeFactory(selectCond, null, BinaryBooleanInspector.FACTORY, false, -1, null);
        select.setSourceLocation(this.sourceLoc);
        AlgebricksMetaOperatorDescriptor asterixSelectOp = new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 1, new IPushRuntimeFactory[]{select}, new RecordDescriptor[]{secondaryRecDesc});
        asterixSelectOp.setSourceLocation(this.sourceLoc);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)asterixSelectOp, (AlgebricksPartitionConstraint)this.primaryPartitionConstraint);
        return asterixSelectOp;
    }

    protected ExternalScanOperatorDescriptor createExternalIndexingOp(JobSpecification spec) throws AlgebricksException {
        Pair<ExternalScanOperatorDescriptor, AlgebricksPartitionConstraint> indexingOpAndConstraints;
        ISerializerDeserializer[] serdes = new ISerializerDeserializer[1 + this.numPrimaryKeys];
        ITypeTraits[] typeTraits = new ITypeTraits[1 + this.numPrimaryKeys];
        serdes[0] = this.payloadSerde;
        typeTraits[0] = TypeTraitProvider.INSTANCE.getTypeTrait((Object)this.itemType);
        for (int i = 1; i < serdes.length; ++i) {
            serdes[i] = IndexingConstants.getSerializerDeserializer((int)(i - 1));
            typeTraits[i] = IndexingConstants.getTypeTraits((int)(i - 1));
        }
        RecordDescriptor indexerDesc = new RecordDescriptor(serdes, typeTraits);
        try {
            indexingOpAndConstraints = ExternalIndexingOperations.createExternalIndexingOp(spec, this.metadataProvider, this.dataset, this.itemType, indexerDesc, this.externalFiles, this.sourceLoc);
        }
        catch (Exception e) {
            throw new AlgebricksException((Throwable)e);
        }
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)((IOperatorDescriptor)indexingOpAndConstraints.first), (AlgebricksPartitionConstraint)((AlgebricksPartitionConstraint)indexingOpAndConstraints.second));
        this.primaryPartitionConstraint = (AlgebricksPartitionConstraint)indexingOpAndConstraints.second;
        return (ExternalScanOperatorDescriptor)indexingOpAndConstraints.first;
    }

    protected AlgebricksMetaOperatorDescriptor createExternalAssignOp(JobSpecification spec, int numSecondaryKeys, RecordDescriptor secondaryRecDesc) {
        int i;
        int[] outColumns = new int[numSecondaryKeys];
        int[] projectionList = new int[numSecondaryKeys + this.numPrimaryKeys];
        for (int i2 = 0; i2 < numSecondaryKeys; ++i2) {
            outColumns[i2] = i2 + this.numPrimaryKeys + 1;
            projectionList[i2] = i2 + this.numPrimaryKeys + 1;
        }
        IScalarEvaluatorFactory[] sefs = new IScalarEvaluatorFactory[this.secondaryFieldAccessEvalFactories.length];
        for (i = 0; i < this.secondaryFieldAccessEvalFactories.length; ++i) {
            sefs[i] = this.secondaryFieldAccessEvalFactories[i];
        }
        for (i = 0; i < this.numPrimaryKeys; ++i) {
            projectionList[numSecondaryKeys + i] = i + 1;
        }
        AssignRuntimeFactory assign = new AssignRuntimeFactory(outColumns, sefs, projectionList);
        return new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 1, new IPushRuntimeFactory[]{assign}, new RecordDescriptor[]{secondaryRecDesc});
    }

    protected ExternalIndexBulkModifyOperatorDescriptor createExternalIndexBulkModifyOp(JobSpecification spec, int[] fieldPermutation, IIndexDataflowHelperFactory dataflowHelperFactory, float fillFactor) {
        int numOfDeletedFiles = 0;
        for (ExternalFile file : this.externalFiles) {
            if (file.getPendingOp() != DatasetConfig.ExternalFilePendingOp.DROP_OP) continue;
            ++numOfDeletedFiles;
        }
        int[] deletedFiles = new int[numOfDeletedFiles];
        int i = 0;
        for (ExternalFile file : this.externalFiles) {
            if (file.getPendingOp() != DatasetConfig.ExternalFilePendingOp.DROP_OP) continue;
            deletedFiles[i] = file.getFileNumber();
        }
        ExternalIndexBulkModifyOperatorDescriptor treeIndexBulkLoadOp = new ExternalIndexBulkModifyOperatorDescriptor((IOperatorDescriptorRegistry)spec, dataflowHelperFactory, deletedFiles, fieldPermutation, fillFactor, false, this.numElementsHint, null);
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)treeIndexBulkLoadOp, (AlgebricksPartitionConstraint)this.secondaryPartitionConstraint);
        return treeIndexBulkLoadOp;
    }

    public List<ExternalFile> getExternalFiles() {
        return this.externalFiles;
    }

    public void setExternalFiles(List<ExternalFile> externalFiles) {
        this.externalFiles = externalFiles;
    }

    @Override
    public RecordDescriptor getSecondaryRecDesc() {
        return this.secondaryRecDesc;
    }

    @Override
    public IBinaryComparatorFactory[] getSecondaryComparatorFactories() {
        return this.secondaryComparatorFactories;
    }

    @Override
    public IFileSplitProvider getSecondaryFileSplitProvider() {
        return this.secondaryFileSplitProvider;
    }

    @Override
    public AlgebricksPartitionConstraint getSecondaryPartitionConstraint() {
        return this.secondaryPartitionConstraint;
    }
}

