/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.ArrayList;
import java.util.Set;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.cc.work.AbstractHeartbeatWork;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JobletCleanupNotificationWork
extends AbstractHeartbeatWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private final JobId jobId;

    public JobletCleanupNotificationWork(ClusterControllerService ccs, JobId jobId, String nodeId) {
        super(ccs, nodeId, null);
        this.jobId = jobId;
    }

    @Override
    public void runWork() {
        LOGGER.debug("node {} finished job clean-up {}", (Object)this.nodeId, (Object)this.jobId);
        IJobManager jobManager = this.ccs.getJobManager();
        JobRun run = jobManager.get(this.jobId);
        if (run == null) {
            LOGGER.log(Level.WARN, () -> "ignoring unknown job " + this.jobId + " on notification from " + this.nodeId);
            return;
        }
        Set<String> cleanupPendingNodes = run.getCleanupPendingNodeIds();
        if (!cleanupPendingNodes.remove(this.nodeId)) {
            LOGGER.log(Level.WARN, () -> this.nodeId + " not in pending cleanup nodes set: " + cleanupPendingNodes + " for job " + this.jobId);
            return;
        }
        INodeManager nodeManager = this.ccs.getNodeManager();
        NodeControllerState ncs = nodeManager.getNodeControllerState(this.nodeId);
        if (ncs != null) {
            ncs.getActiveJobIds().remove(this.jobId);
        }
        if (cleanupPendingNodes.isEmpty()) {
            try {
                jobManager.finalComplete(run);
            }
            catch (HyracksException e) {
                ArrayList<Exception> completionException = new ArrayList<Exception>();
                if (run.getExceptions() != null && !run.getExceptions().isEmpty()) {
                    completionException.addAll(run.getExceptions());
                }
                completionException.add(0, (Exception)((Object)e));
                run.setStatus(JobStatus.FAILURE, completionException);
            }
        }
    }

    public String toString() {
        return this.getName() + " jobId:" + this.jobId + ", nodeId:" + this.nodeId;
    }

    public Level logLevel() {
        return Level.TRACE;
    }
}

