/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.util.FullTextUtil;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.object.base.AdmArrayNode;
import org.apache.asterix.object.base.AdmObjectNode;
import org.apache.asterix.object.base.AdmStringNode;
import org.apache.asterix.object.base.IAdmNode;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class CreateFullTextFilterStatement
extends AbstractStatement {
    private final DataverseName dataverseName;
    private final String filterName;
    private final boolean ifNotExists;
    private final AdmObjectNode filterNode;
    public static final String FIELD_NAME_TYPE = "type";
    public static final String FIELD_NAME_STOPWORDS_LIST = "stopwordsList";
    public static final String FIELD_TYPE_STOPWORDS = "stopwords";

    public CreateFullTextFilterStatement(DataverseName dataverseName, String filterName, boolean ifNotExists, RecordConstructor expr) throws CompilationException {
        this.dataverseName = dataverseName;
        this.filterName = filterName;
        this.ifNotExists = ifNotExists;
        this.filterNode = FullTextUtil.getFilterNode(expr);
    }

    public DataverseName getDataverseName() {
        return this.dataverseName;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public String getFilterType() throws HyracksDataException {
        return this.filterNode.getString(FIELD_NAME_TYPE);
    }

    public ImmutableList<String> getStopwordsList() throws CompilationException {
        ImmutableList.Builder listBuiler = ImmutableList.builder();
        AdmArrayNode arrayNode = (AdmArrayNode)this.filterNode.get(FIELD_NAME_STOPWORDS_LIST);
        for (IAdmNode node : arrayNode) {
            if (!(node instanceof AdmStringNode)) {
                throw new CompilationException(ErrorCode.PARSE_ERROR, this.getSourceLocation(), new Serializable[]{"error when parsing stopwords list"});
            }
            listBuiler.add((Object)((AdmStringNode)node).get());
        }
        return listBuiler.build();
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.CREATE_FULL_TEXT_FILTER;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    @Override
    public byte getCategory() {
        return 4;
    }
}

