/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.ipc;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.ipc.ExternalFunctionResultRouter;
import org.apache.asterix.external.ipc.MessageType;
import org.apache.asterix.external.ipc.PythonMessageBuilder;
import org.apache.asterix.external.library.msgpack.MsgPackPointableVisitor;
import org.apache.asterix.om.pointables.AFlatValuePointable;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.core.buffer.ArrayBufferInput;
import org.msgpack.core.buffer.MessageBufferInput;

public class PythonIPCProto {
    private final PythonMessageBuilder messageBuilder;
    private final DataOutputStream sockOut;
    private final ByteBuffer headerBuffer = ByteBuffer.allocate(21);
    private ByteBuffer recvBuffer = ByteBuffer.allocate(32768);
    private final ExternalFunctionResultRouter router;
    private long routeId;
    private Pair<ByteBuffer, Exception> bufferBox;
    private final Process pythonProc;
    private long maxFunctionId;
    private final ArrayBufferInput unpackerInput;
    private final MessageUnpacker unpacker;
    private final ArrayBackedValueStorage argsStorage;
    private final PointableAllocator pointableAllocator;
    private final MsgPackPointableVisitor pointableVisitor;

    public PythonIPCProto(OutputStream sockOut, ExternalFunctionResultRouter router, Process pythonProc) {
        this.sockOut = new DataOutputStream(sockOut);
        this.messageBuilder = new PythonMessageBuilder();
        this.router = router;
        this.pythonProc = pythonProc;
        this.maxFunctionId = 0L;
        this.unpackerInput = new ArrayBufferInput(new byte[0]);
        this.unpacker = MessagePack.newDefaultUnpacker((MessageBufferInput)this.unpackerInput);
        this.argsStorage = new ArrayBackedValueStorage();
        this.pointableAllocator = new PointableAllocator();
        this.pointableVisitor = new MsgPackPointableVisitor();
    }

    public void start() {
        Pair keyAndBufferBox = this.router.insertRoute(this.recvBuffer);
        this.routeId = (Long)keyAndBufferBox.getFirst();
        this.bufferBox = (Pair)keyAndBufferBox.getSecond();
    }

    public void helo() throws IOException, AsterixException {
        this.recvBuffer.clear();
        this.recvBuffer.position(0);
        this.recvBuffer.limit(0);
        this.messageBuilder.reset();
        this.messageBuilder.hello();
        this.sendHeader(this.routeId, this.messageBuilder.getLength());
        this.sendMsg();
        this.receiveMsg();
        if (this.getResponseType() != MessageType.HELO) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{"Expected HELO, recieved " + this.getResponseType().name()});
        }
    }

    public long init(String module, String clazz, String fn) throws IOException, AsterixException {
        long functionId = this.maxFunctionId++;
        this.recvBuffer.clear();
        this.recvBuffer.position(0);
        this.recvBuffer.limit(0);
        this.messageBuilder.reset();
        this.messageBuilder.init(module, clazz, fn);
        this.sendHeader(functionId, this.messageBuilder.getLength());
        this.sendMsg();
        this.receiveMsg();
        if (this.getResponseType() != MessageType.INIT_RSP) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{"Expected INIT_RSP, recieved " + this.getResponseType().name()});
        }
        return functionId;
    }

    public ByteBuffer call(long functionId, IAType[] argTypes, IValueReference[] argValues, boolean nullCall) throws IOException, AsterixException {
        this.recvBuffer.clear();
        this.recvBuffer.position(0);
        this.recvBuffer.limit(0);
        this.messageBuilder.reset();
        this.argsStorage.reset();
        for (int i = 0; i < argTypes.length; ++i) {
            PythonIPCProto.visitValueRef(argTypes[i], this.argsStorage.getDataOutput(), argValues[i], this.pointableAllocator, this.pointableVisitor, nullCall);
        }
        int len = this.argsStorage.getLength() + 5;
        this.sendHeader(functionId, len);
        this.messageBuilder.call(argValues.length, len);
        this.sendMsg(this.argsStorage);
        this.receiveMsg();
        if (this.getResponseType() != MessageType.CALL_RSP) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{"Expected CALL_RSP, recieved " + this.getResponseType().name()});
        }
        return this.recvBuffer;
    }

    public ByteBuffer callMulti(long key, ArrayBackedValueStorage args, int numTuples) throws IOException, AsterixException {
        this.recvBuffer.clear();
        this.recvBuffer.position(0);
        this.recvBuffer.limit(0);
        this.messageBuilder.reset();
        int len = args.getLength() + 4;
        this.sendHeader(key, len);
        this.messageBuilder.callMulti(0, numTuples);
        this.sendMsg(args);
        this.receiveMsg();
        if (this.getResponseType() != MessageType.CALL_RSP) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{"Expected CALL_RSP, recieved " + this.getResponseType().name()});
        }
        return this.recvBuffer;
    }

    public void quit() throws HyracksDataException {
        this.messageBuilder.quit();
        this.router.removeRoute(Long.valueOf(this.routeId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMsg() throws IOException, AsterixException {
        Exception except;
        try {
            Pair<ByteBuffer, Exception> pair = this.bufferBox;
            synchronized (pair) {
                while ((((ByteBuffer)this.bufferBox.getFirst()).limit() == 0 || this.bufferBox.getSecond() != null) && this.pythonProc.isAlive()) {
                    this.bufferBox.wait(100L);
                }
            }
            except = this.router.getAndRemoveException(Long.valueOf(this.routeId));
            if (!this.pythonProc.isAlive()) {
                except = new IOException("Python process exited with code: " + this.pythonProc.exitValue());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AsterixException(org.apache.asterix.common.exceptions.ErrorCode.EXTERNAL_UDF_EXCEPTION, (Throwable)e, new Serializable[0]);
        }
        if (except != null) {
            throw new AsterixException((Throwable)except);
        }
        if (this.bufferBox.getFirst() != this.recvBuffer) {
            this.recvBuffer = (ByteBuffer)this.bufferBox.getFirst();
        }
        this.messageBuilder.readHead(this.recvBuffer);
        if (this.messageBuilder.type == MessageType.ERROR) {
            this.unpackerInput.reset(this.recvBuffer.array(), this.recvBuffer.position() + this.recvBuffer.arrayOffset(), this.recvBuffer.remaining());
            this.unpacker.reset((MessageBufferInput)this.unpackerInput);
            throw new AsterixException(this.unpacker.unpackString());
        }
    }

    public void sendHeader(long key, int msgLen) throws IOException {
        this.headerBuffer.clear();
        this.headerBuffer.position(0);
        this.headerBuffer.putInt(21 + msgLen);
        this.headerBuffer.putLong(key);
        this.headerBuffer.putLong(this.routeId);
        this.headerBuffer.put((byte)0);
        this.sockOut.write(this.headerBuffer.array(), 0, 21);
        this.sockOut.flush();
    }

    public void sendMsg(ArrayBackedValueStorage content) throws IOException {
        this.sockOut.write(this.messageBuilder.getBuf().array(), this.messageBuilder.getBuf().arrayOffset(), this.messageBuilder.getBuf().position());
        this.sockOut.write(content.getByteArray(), content.getStartOffset(), content.getLength());
        this.sockOut.flush();
    }

    public void sendMsg() throws IOException {
        this.sockOut.write(this.messageBuilder.getBuf().array(), this.messageBuilder.getBuf().arrayOffset(), this.messageBuilder.getBuf().position());
        this.sockOut.flush();
    }

    public MessageType getResponseType() {
        return this.messageBuilder.type;
    }

    public long getRouteId() {
        return this.routeId;
    }

    public DataOutputStream getSockOut() {
        return this.sockOut;
    }

    public static void visitValueRef(IAType type, DataOutput out, IValueReference valueReference, PointableAllocator pointableAllocator, MsgPackPointableVisitor pointableVisitor, boolean visitNull) throws IOException {
        block0 : switch (type.getTypeTag()) {
            case OBJECT: {
                ARecordVisitablePointable pointable = pointableAllocator.allocateRecordValue(type);
                pointable.set(valueReference);
                pointableVisitor.visit(pointable, pointableVisitor.getTypeInfo(type, out));
                break;
            }
            case ARRAY: 
            case MULTISET: {
                AListVisitablePointable pointable = pointableAllocator.allocateListValue(type);
                pointable.set(valueReference);
                pointableVisitor.visit(pointable, pointableVisitor.getTypeInfo(type, out));
                break;
            }
            case ANY: {
                ATypeTag rtTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(valueReference.getByteArray()[valueReference.getStartOffset()]);
                IAType rtType = TypeTagUtil.getBuiltinTypeByTag((ATypeTag)rtTypeTag);
                switch (rtTypeTag) {
                    case OBJECT: {
                        ARecordVisitablePointable pointable = pointableAllocator.allocateRecordValue(rtType);
                        pointable.set(valueReference);
                        pointableVisitor.visit(pointable, pointableVisitor.getTypeInfo(rtType, out));
                        break block0;
                    }
                    case ARRAY: 
                    case MULTISET: {
                        AListVisitablePointable pointable = pointableAllocator.allocateListValue(rtType);
                        pointable.set(valueReference);
                        pointableVisitor.visit(pointable, pointableVisitor.getTypeInfo(rtType, out));
                        break block0;
                    }
                    case MISSING: 
                    case NULL: {
                        if (visitNull) break;
                        return;
                    }
                }
                IVisitablePointable pointable = pointableAllocator.allocateFieldValue(rtType);
                pointable.set(valueReference);
                pointableVisitor.visit((AFlatValuePointable)pointable, pointableVisitor.getTypeInfo(rtType, out));
                break;
            }
            case MISSING: 
            case NULL: {
                if (!visitNull) {
                    return;
                }
            }
            default: {
                IVisitablePointable pointable = pointableAllocator.allocateFieldValue(type);
                pointable.set(valueReference);
                pointableVisitor.visit((AFlatValuePointable)pointable, pointableVisitor.getTypeInfo(type, out));
            }
        }
    }
}

