/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.rest.PagedIterable;
import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.DataLakeServiceClientBuilder;
import com.azure.storage.file.datalake.models.ListPathsOptions;
import com.azure.storage.file.datalake.models.PathItem;
import com.google.api.gax.paging.Page;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.functions.ExternalFunctionLanguage;
import org.apache.asterix.common.library.ILibrary;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.external.api.IDataParserFactory;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IInputStreamFactory;
import org.apache.asterix.external.api.IRecordReaderFactory;
import org.apache.asterix.external.input.record.reader.abstracts.AbstractExternalInputStreamFactory;
import org.apache.asterix.external.library.JavaLibrary;
import org.apache.asterix.external.util.ExternalDataConstants;
import org.apache.asterix.external.util.HDFSUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.runtime.evaluators.common.NumberUtils;
import org.apache.asterix.runtime.evaluators.functions.StringEvaluatorUtils;
import org.apache.asterix.runtime.projection.DataProjectionInfo;
import org.apache.asterix.runtime.projection.FunctionCallInformation;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.dataflow.common.data.parsers.BooleanParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.DoubleParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.FloatParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.IntegerParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.LongParserFactory;
import org.apache.hyracks.dataflow.common.data.parsers.UTF8StringParserFactory;
import org.apache.hyracks.util.StorageUtil;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.model.S3Response;

public class ExternalDataUtils {
    private static final Map<ATypeTag, IValueParserFactory> valueParserFactoryMap = new EnumMap<ATypeTag, IValueParserFactory>(ATypeTag.class);
    private static final int DEFAULT_MAX_ARGUMENT_SZ = 0x100000;
    private static final int HEADER_FUDGE = 64;

    private ExternalDataUtils() {
    }

    public static int getOrDefaultBufferSize(Map<String, String> configuration) {
        String bufferSize = configuration.get("external-scan-buffer-size");
        return bufferSize != null ? Integer.parseInt(bufferSize) : ExternalDataConstants.DEFAULT_BUFFER_SIZE;
    }

    public static char validateGetDelimiter(Map<String, String> configuration) throws HyracksDataException {
        return ExternalDataUtils.validateCharOrDefault(configuration, "delimiter", ",".charAt(0));
    }

    public static char validateGetQuote(Map<String, String> configuration, char delimiter) throws HyracksDataException {
        char quote = ExternalDataUtils.validateCharOrDefault(configuration, "quote", "\"".charAt(0));
        ExternalDataUtils.validateDelimiterAndQuote(delimiter, quote);
        return quote;
    }

    public static char validateGetEscape(Map<String, String> configuration) throws HyracksDataException {
        return ExternalDataUtils.validateCharOrDefault(configuration, "escape", '\\');
    }

    public static char validateGetRecordStart(Map<String, String> configuration) throws HyracksDataException {
        return ExternalDataUtils.validateCharOrDefault(configuration, "record-start", '{');
    }

    public static char validateGetRecordEnd(Map<String, String> configuration) throws HyracksDataException {
        return ExternalDataUtils.validateCharOrDefault(configuration, "record-end", '}');
    }

    public static void validateDataParserParameters(Map<String, String> configuration) throws AsterixException {
        String parserFactory;
        String parser = configuration.get("format");
        if (parser == null && (parserFactory = configuration.get("parser-factory")) == null) {
            throw AsterixException.create((ErrorCode)ErrorCode.PARAMETERS_REQUIRED, (Serializable[])new Serializable[]{"format or parser-factory"});
        }
    }

    public static void validateDataSourceParameters(Map<String, String> configuration) throws AsterixException {
        String reader = configuration.get("reader");
        if (reader == null) {
            throw AsterixException.create((ErrorCode)ErrorCode.PARAMETERS_REQUIRED, (Serializable[])new Serializable[]{"reader"});
        }
    }

    public static IExternalDataSourceFactory.DataSourceType getDataSourceType(Map<String, String> configuration) {
        String reader = configuration.get("reader");
        if (reader != null && reader.equals("stream")) {
            return IExternalDataSourceFactory.DataSourceType.STREAM;
        }
        return IExternalDataSourceFactory.DataSourceType.RECORDS;
    }

    public static boolean isExternal(String aString) {
        return aString != null && aString.contains("#") && aString.trim().length() > 1;
    }

    public static String getLibraryName(String aString) {
        return aString.trim().split("#")[0];
    }

    public static String getExternalClassName(String aString) {
        return aString.trim().split("#")[1];
    }

    public static IInputStreamFactory createExternalInputStreamFactory(ILibraryManager libraryManager, DataverseName dataverse, String stream) throws HyracksDataException {
        try {
            String libraryName = ExternalDataUtils.getLibraryName(stream);
            String className = ExternalDataUtils.getExternalClassName(stream);
            ILibrary lib = libraryManager.getLibrary(dataverse, libraryName);
            if (lib.getLanguage() != ExternalFunctionLanguage.JAVA) {
                throw new HyracksDataException("Unexpected library language: " + lib.getLanguage());
            }
            ClassLoader classLoader = ((JavaLibrary)lib).getClassLoader();
            return (IInputStreamFactory)classLoader.loadClass(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeDataException(ErrorCode.UTIL_EXTERNAL_DATA_UTILS_FAIL_CREATE_STREAM_FACTORY, (Throwable)e, new Serializable[0]);
        }
    }

    public static DataverseName getDatasetDataverse(Map<String, String> configuration) throws AsterixException {
        return DataverseName.createFromCanonicalForm((String)configuration.get("dataset-dataverse"));
    }

    public static String getParserFactory(Map<String, String> configuration) {
        String parserFactory = configuration.get("parser");
        if (parserFactory != null) {
            return parserFactory;
        }
        parserFactory = configuration.get("format");
        return parserFactory != null ? parserFactory : configuration.get("parser-factory");
    }

    public static IValueParserFactory[] getValueParserFactories(ARecordType recordType) {
        int n = recordType.getFieldTypes().length;
        IValueParserFactory[] fieldParserFactories = new IValueParserFactory[n];
        for (int i = 0; i < n; ++i) {
            ATypeTag tag = null;
            if (recordType.getFieldTypes()[i].getTypeTag() == ATypeTag.UNION) {
                AUnionType unionType = (AUnionType)recordType.getFieldTypes()[i];
                if (!unionType.isUnknownableType()) {
                    throw new NotImplementedException("Non-optional UNION type is not supported.");
                }
                tag = unionType.getActualType().getTypeTag();
            } else {
                tag = recordType.getFieldTypes()[i].getTypeTag();
            }
            if (tag == null) {
                throw new NotImplementedException("Failed to get the type information for field " + i + ".");
            }
            fieldParserFactories[i] = ExternalDataUtils.getParserFactory(tag);
        }
        return fieldParserFactories;
    }

    public static IValueParserFactory getParserFactory(ATypeTag tag) {
        IValueParserFactory vpf = valueParserFactoryMap.get(tag);
        if (vpf == null) {
            throw new NotImplementedException("No value parser factory for fields of type " + tag);
        }
        return vpf;
    }

    public static boolean hasHeader(Map<String, String> configuration) {
        return ExternalDataUtils.isTrue(configuration, "header");
    }

    public static boolean isTrue(Map<String, String> configuration, String key) {
        String value = configuration.get(key);
        return value == null ? false : Boolean.valueOf(value);
    }

    public static IRecordReaderFactory<?> createExternalRecordReaderFactory(ILibraryManager libraryManager, Map<String, String> configuration) throws AsterixException {
        ILibrary lib;
        String readerFactory = configuration.get("reader-factory");
        if (readerFactory == null) {
            throw new AsterixException("to use external reader, the parameter reader-factory must be specified.");
        }
        String[] libraryAndFactory = readerFactory.split("#");
        if (libraryAndFactory.length != 2) {
            throw new AsterixException("The parameter reader-factory must follow the format \"DataverseName.LibraryName#ReaderFactoryFullyQualifiedName\"");
        }
        String[] dataverseAndLibrary = libraryAndFactory[0].split("\\.");
        if (dataverseAndLibrary.length != 2) {
            throw new AsterixException("The parameter reader-factory must follow the format \"DataverseName.LibraryName#ReaderFactoryFullyQualifiedName\"");
        }
        DataverseName dataverseName = DataverseName.createSinglePartName((String)dataverseAndLibrary[0]);
        String libraryName = dataverseAndLibrary[1];
        try {
            lib = libraryManager.getLibrary(dataverseName, libraryName);
        }
        catch (HyracksDataException e) {
            throw new AsterixException("Cannot load library", (Throwable)e);
        }
        if (lib.getLanguage() != ExternalFunctionLanguage.JAVA) {
            throw new AsterixException("Unexpected library language: " + lib.getLanguage());
        }
        ClassLoader classLoader = ((JavaLibrary)lib).getClassLoader();
        try {
            return (IRecordReaderFactory)classLoader.loadClass(libraryAndFactory[1]).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new AsterixException("Failed to create record reader factory", (Throwable)e);
        }
    }

    public static IDataParserFactory createExternalParserFactory(ILibraryManager libraryManager, DataverseName dataverse, String parserFactoryName) throws AsterixException {
        try {
            ILibrary lib;
            String library = parserFactoryName.substring(0, parserFactoryName.indexOf("#"));
            try {
                lib = libraryManager.getLibrary(dataverse, library);
            }
            catch (HyracksDataException e) {
                throw new AsterixException("Cannot load library", (Throwable)e);
            }
            if (lib.getLanguage() != ExternalFunctionLanguage.JAVA) {
                throw new AsterixException("Unexpected library language: " + lib.getLanguage());
            }
            ClassLoader classLoader = ((JavaLibrary)lib).getClassLoader();
            return (IDataParserFactory)classLoader.loadClass(parserFactoryName.substring(parserFactoryName.indexOf("#") + 1)).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new AsterixException("Failed to create an external parser factory", (Throwable)e);
        }
    }

    public static boolean isFeed(Map<String, String> configuration) {
        if (!configuration.containsKey("is-feed")) {
            return false;
        }
        return Boolean.parseBoolean(configuration.get("is-feed"));
    }

    public static void prepareFeed(Map<String, String> configuration, DataverseName dataverseName, String feedName) {
        if (!configuration.containsKey("is-feed")) {
            configuration.put("is-feed", "true");
        }
        configuration.put("dataset-dataverse", dataverseName.getCanonicalForm());
        configuration.put("feed", feedName);
    }

    public static boolean keepDataSourceOpen(Map<String, String> configuration) {
        if (!configuration.containsKey("wait-for-data")) {
            return true;
        }
        return Boolean.parseBoolean(configuration.get("wait-for-data"));
    }

    public static String getFeedName(Map<String, String> configuration) {
        return configuration.get("feed");
    }

    public static boolean isRecordWithMeta(Map<String, String> configuration) {
        return configuration.containsKey("meta-type-name");
    }

    public static void setRecordWithMeta(Map<String, String> configuration, String booleanString) {
        configuration.put("record-with-metadata", booleanString);
    }

    public static boolean isChangeFeed(Map<String, String> configuration) {
        return Boolean.parseBoolean(configuration.get("change-feed"));
    }

    public static boolean isInsertFeed(Map<String, String> configuration) {
        return Boolean.parseBoolean(configuration.get("insert-feed"));
    }

    public static int getNumberOfKeys(Map<String, String> configuration) throws AsterixException {
        String keyIndexes = configuration.get("key-indexes");
        if (keyIndexes == null) {
            throw AsterixException.create((ErrorCode)ErrorCode.PARAMETERS_REQUIRED, (Serializable[])new Serializable[]{"key-indexes"});
        }
        return keyIndexes.split(",").length;
    }

    public static void setNumberOfKeys(Map<String, String> configuration, int value) {
        configuration.put("key-size", String.valueOf(value));
    }

    public static void setChangeFeed(Map<String, String> configuration, String booleanString) {
        configuration.put("change-feed", booleanString);
    }

    public static int[] getPKIndexes(Map<String, String> configuration) {
        String keyIndexes = configuration.get("key-indexes");
        String[] stringIndexes = keyIndexes.split(",");
        int[] intIndexes = new int[stringIndexes.length];
        for (int i = 0; i < stringIndexes.length; ++i) {
            intIndexes[i] = Integer.parseInt(stringIndexes[i]);
        }
        return intIndexes;
    }

    public static int[] getPKSourceIndicators(Map<String, String> configuration) {
        String keyIndicators = configuration.get("key-indicators");
        String[] stringIndicators = keyIndicators.split(",");
        int[] intIndicators = new int[stringIndicators.length];
        for (int i = 0; i < stringIndicators.length; ++i) {
            intIndicators[i] = Integer.parseInt(stringIndicators[i]);
        }
        return intIndicators;
    }

    public static void defaultConfiguration(Map<String, String> configuration) {
        String format = configuration.get("format");
        if (format != null) {
            if (format.equals("csv")) {
                configuration.putIfAbsent("delimiter", ",");
                configuration.putIfAbsent("quote", "\"");
                configuration.putIfAbsent("escape", "\"");
            } else if (format.equals("tsv")) {
                configuration.putIfAbsent("delimiter", "\t");
                configuration.putIfAbsent("quote", "\u0000");
                configuration.putIfAbsent("escape", "\u0000");
            }
        }
    }

    public static void prepare(String adapterName, Map<String, String> configuration) {
        String inputFormat;
        if (!configuration.containsKey("reader")) {
            configuration.put("reader", adapterName);
        }
        if ("parquet-input-format".equals(inputFormat = configuration.get("input-format"))) {
            configuration.put("parser", "noop");
            configuration.put("format", "parquet");
        }
        if (!configuration.containsKey("parser") && configuration.containsKey("format")) {
            configuration.put("parser", configuration.get("format"));
        }
    }

    public static void normalize(Map<String, String> configuration) {
        String lowerCaseFormat;
        String paramValue = configuration.get("format");
        if (paramValue != null && ExternalDataConstants.ALL_FORMATS.contains(lowerCaseFormat = paramValue.toLowerCase().trim())) {
            configuration.put("format", lowerCaseFormat);
        }
        ExternalDataUtils.putToLowerIfExists(configuration, "header");
        ExternalDataUtils.putToLowerIfExists(configuration, "redact-warnings");
    }

    public static void validate(Map<String, String> configuration) throws HyracksDataException {
        String format = configuration.get("format");
        String header = configuration.get("header");
        if (format != null && ExternalDataUtils.isHeaderRequiredFor(format) && header == null) {
            throw new RuntimeDataException(ErrorCode.PARAMETERS_REQUIRED, new Serializable[]{"header"});
        }
        if (header != null && !ExternalDataUtils.isBoolean(header)) {
            throw new RuntimeDataException(ErrorCode.INVALID_REQ_PARAM_VAL, new Serializable[]{"header", header});
        }
        char delimiter = ExternalDataUtils.validateGetDelimiter(configuration);
        ExternalDataUtils.validateGetQuote(configuration, delimiter);
        ExternalDataUtils.validateGetEscape(configuration);
        String value = configuration.get("redact-warnings");
        if (value != null && !ExternalDataUtils.isBoolean(value)) {
            throw new RuntimeDataException(ErrorCode.INVALID_REQ_PARAM_VAL, new Serializable[]{"redact-warnings", value});
        }
    }

    private static boolean isHeaderRequiredFor(String format) {
        return format.equals("csv") || format.equals("tsv");
    }

    private static boolean isBoolean(String value) {
        return value.equals("true") || value.equals("false");
    }

    private static void validateDelimiterAndQuote(char delimiter, char quote) throws RuntimeDataException {
        if (quote == delimiter) {
            throw new RuntimeDataException(ErrorCode.QUOTE_DELIMITER_MISMATCH, new Serializable[]{Character.valueOf(quote), Character.valueOf(delimiter)});
        }
    }

    private static char validateCharOrDefault(Map<String, String> configuration, String key, char defaultValue) throws HyracksDataException {
        String value = configuration.get(key);
        if (value == null) {
            return defaultValue;
        }
        ExternalDataUtils.validateChar(value, key);
        return value.charAt(0);
    }

    public static void validateChar(String parameterValue, String parameterName) throws RuntimeDataException {
        if (parameterValue.length() != 1) {
            throw new RuntimeDataException(ErrorCode.INVALID_CHAR_LENGTH, new Serializable[]{parameterValue, parameterName});
        }
    }

    private static void putToLowerIfExists(Map<String, String> configuration, String key) {
        String paramValue = configuration.get(key);
        if (paramValue != null) {
            configuration.put(key, paramValue.toLowerCase().trim());
        }
    }

    public static void validateAdapterSpecificProperties(Map<String, String> configuration, SourceLocation srcLoc, IWarningCollector collector, IApplicationContext appCtx) throws CompilationException {
        String type;
        switch (type = configuration.get("type")) {
            case "S3": {
                AwsS3.validateProperties(configuration, srcLoc, collector);
                break;
            }
            case "AZUREBLOB": {
                Azure.validateAzureBlobProperties(configuration, srcLoc, collector, appCtx);
                break;
            }
            case "AZUREDATALAKE": {
                Azure.validateAzureDataLakeProperties(configuration, srcLoc, collector, appCtx);
                break;
            }
            case "GCS": {
                GCS.validateProperties(configuration, srcLoc, collector);
                break;
            }
        }
    }

    public static boolean matchPatterns(List<Matcher> matchers, String path) {
        for (Matcher matcher : matchers) {
            if (!matcher.reset(path).matches()) continue;
            return true;
        }
        return false;
    }

    public static String patternToRegex(String pattern) {
        int charPosition = 0;
        int patternLength = pattern.length();
        StringBuilder stuffBuilder = new StringBuilder();
        StringBuilder result = new StringBuilder();
        block5: while (charPosition < patternLength) {
            char c = pattern.charAt(charPosition);
            ++charPosition;
            switch (c) {
                case '*': {
                    result.append(".*");
                    continue block5;
                }
                case '?': {
                    result.append(".");
                    continue block5;
                }
                case '[': {
                    int closingBracketPosition = charPosition;
                    if (closingBracketPosition < patternLength && pattern.charAt(closingBracketPosition) == '!') {
                        ++closingBracketPosition;
                    }
                    if (closingBracketPosition < patternLength && pattern.charAt(closingBracketPosition) == ']') {
                        ++closingBracketPosition;
                    }
                    while (closingBracketPosition < patternLength && pattern.charAt(closingBracketPosition) != ']') {
                        ++closingBracketPosition;
                    }
                    if (closingBracketPosition >= patternLength) {
                        result.append("\\[");
                        continue block5;
                    }
                    String stuff = pattern.substring(charPosition, closingBracketPosition);
                    stuffBuilder.setLength(0);
                    int stuffCharPos = 0;
                    if (stuff.charAt(0) == '!') {
                        stuffBuilder.append('^');
                        ++stuffCharPos;
                    }
                    while (stuffCharPos < stuff.length()) {
                        char stuffChar = stuff.charAt(stuffCharPos);
                        if (stuffChar != '-' && Arrays.binarySearch(StringEvaluatorUtils.RESERVED_REGEX_CHARS, stuffChar) >= 0) {
                            stuffBuilder.append("\\");
                        }
                        stuffBuilder.append(stuffChar);
                        ++stuffCharPos;
                    }
                    String stuffEscaped = stuffBuilder.toString();
                    stuffEscaped = stuffEscaped.replace("&&", "\\&\\&").replace("~~", "\\~\\~").replace("||", "\\|\\|").replace("--", "\\-\\-");
                    result.append("[").append(stuffEscaped).append("]");
                    charPosition = closingBracketPosition + 1;
                    continue block5;
                }
            }
            if (Arrays.binarySearch(StringEvaluatorUtils.RESERVED_REGEX_CHARS, c) >= 0) {
                result.append("\\");
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String getPrefix(Map<String, String> configuration) {
        return ExternalDataUtils.getPrefix(configuration, true);
    }

    public static String getPrefix(Map<String, String> configuration, boolean appendSlash) {
        String definition = configuration.get("definition");
        if (definition != null && !definition.isEmpty()) {
            return appendSlash ? definition + (!definition.endsWith("/") ? "/" : "") : definition;
        }
        return "";
    }

    public static void validateIncludeExclude(Map<String, String> configuration) throws CompilationException {
        ArrayList<Map.Entry<String, String>> includes = new ArrayList<Map.Entry<String, String>>();
        ArrayList<Map.Entry<String, String>> excludes = new ArrayList<Map.Entry<String, String>>();
        for (Map.Entry<String, String> entry : configuration.entrySet()) {
            String key = entry.getKey();
            if (key.equals("include")) {
                includes.add(entry);
                continue;
            }
            if (key.equals("exclude")) {
                excludes.add(entry);
                continue;
            }
            if (!key.startsWith("include") && !key.startsWith("exclude")) continue;
            String[] splits = key.split("#");
            if (key.startsWith("include") && splits.length == 2 && splits[0].equals("include") && NumberUtils.isIntegerNumericString((String)splits[1])) {
                includes.add(entry);
                continue;
            }
            if (key.startsWith("exclude") && splits.length == 2 && splits[0].equals("exclude") && NumberUtils.isIntegerNumericString((String)splits[1])) {
                excludes.add(entry);
                continue;
            }
            throw new CompilationException(ErrorCode.INVALID_PROPERTY_FORMAT, new Serializable[]{key});
        }
        if (!includes.isEmpty() && !excludes.isEmpty()) {
            throw new CompilationException(ErrorCode.PARAMETERS_NOT_ALLOWED_AT_SAME_TIME, new Serializable[]{"include", "exclude"});
        }
    }

    public static AbstractExternalInputStreamFactory.IncludeExcludeMatcher getIncludeExcludeMatchers(Map<String, String> configuration) throws CompilationException {
        ArrayList<Matcher> includeMatchers = new ArrayList<Matcher>();
        ArrayList<Matcher> excludeMatchers = new ArrayList<Matcher>();
        String pattern = null;
        try {
            for (Map.Entry<String, String> entry : configuration.entrySet()) {
                if (entry.getKey().startsWith("include")) {
                    pattern = entry.getValue();
                    includeMatchers.add(Pattern.compile(ExternalDataUtils.patternToRegex(pattern)).matcher(""));
                    continue;
                }
                if (!entry.getKey().startsWith("exclude")) continue;
                pattern = entry.getValue();
                excludeMatchers.add(Pattern.compile(ExternalDataUtils.patternToRegex(pattern)).matcher(""));
            }
        }
        catch (PatternSyntaxException ex) {
            throw new CompilationException(ErrorCode.INVALID_REGEX_PATTERN, new Serializable[]{pattern});
        }
        AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher = !includeMatchers.isEmpty() ? new AbstractExternalInputStreamFactory.IncludeExcludeMatcher(includeMatchers, (matchers1, key) -> ExternalDataUtils.matchPatterns(matchers1, key)) : (!excludeMatchers.isEmpty() ? new AbstractExternalInputStreamFactory.IncludeExcludeMatcher(excludeMatchers, (matchers1, key) -> !ExternalDataUtils.matchPatterns(matchers1, key)) : new AbstractExternalInputStreamFactory.IncludeExcludeMatcher(Collections.emptyList(), (matchers1, key) -> true));
        return includeExcludeMatcher;
    }

    public static boolean supportsPushdown(Map<String, String> properties) {
        return ExternalDataUtils.isParquetFormat(properties);
    }

    public static void validateParquetTypeAndConfiguration(Map<String, String> properties, ARecordType datasetRecordType) throws CompilationException {
        if (ExternalDataUtils.isParquetFormat(properties)) {
            if (datasetRecordType.getFieldTypes().length != 0) {
                throw new CompilationException(ErrorCode.UNSUPPORTED_TYPE_FOR_PARQUET, new Serializable[]{datasetRecordType.getTypeName()});
            }
            if (properties.containsKey("timezone") && !ExternalDataConstants.ParquetOptions.VALID_TIME_ZONES.contains(properties.get("timezone"))) {
                throw new CompilationException(ErrorCode.INVALID_TIMEZONE, new Serializable[]{(Serializable)((Object)properties.get("timezone"))});
            }
        }
    }

    private static boolean isParquetFormat(Map<String, String> properties) {
        String inputFormat = properties.get("input-format");
        return "org.apache.asterix.external.input.record.reader.hdfs.parquet.MapredParquetInputFormat".equals(inputFormat) || "parquet-input-format".equals(inputFormat) || "parquet".equals(properties.get("format"));
    }

    public static void setExternalDataProjectionInfo(DataProjectionInfo projectionInfo, Map<String, String> properties) throws IOException {
        properties.put("requested-fields", ExternalDataUtils.serializeExpectedTypeToString(projectionInfo.getProjectionInfo()));
        properties.put("org.apache.asterix.function.info", ExternalDataUtils.serializeFunctionCallInfoToString(projectionInfo.getFunctionCallInfoMap()));
    }

    private static String serializeExpectedTypeToString(ARecordType expectedType) throws IOException {
        if (expectedType == DataProjectionInfo.EMPTY_TYPE || expectedType == DataProjectionInfo.ALL_FIELDS_TYPE) {
            return expectedType.getTypeName();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        Base64.Encoder encoder = Base64.getEncoder();
        DataProjectionInfo.writeTypeField((ARecordType)expectedType, (DataOutput)dataOutputStream);
        return encoder.encodeToString(byteArrayOutputStream.toByteArray());
    }

    static String serializeFunctionCallInfoToString(Map<String, FunctionCallInformation> functionCallInfoMap) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        Base64.Encoder encoder = Base64.getEncoder();
        DataProjectionInfo.writeFunctionCallInformationMapField(functionCallInfoMap, (DataOutput)dataOutputStream);
        return encoder.encodeToString(byteArrayOutputStream.toByteArray());
    }

    public static int roundUpToNearestFrameSize(int size, int framesize) {
        return (size / framesize + 1) * framesize;
    }

    public static int getArgBufferSize() {
        long parsedSize;
        int maxArgSz = 0x100040;
        String userArgSz = System.getProperty("udf.buf.size");
        if (userArgSz != null && (parsedSize = StorageUtil.getByteValue((String)userArgSz) + 64L) < Integer.MAX_VALUE && parsedSize > 0L) {
            maxArgSz = (int)parsedSize;
        }
        return maxArgSz;
    }

    private static Optional<String> getFirstNotNull(Map<String, String> configuration, String ... parameters) {
        return Arrays.stream(parameters).filter(field -> configuration.get(field) != null).findFirst();
    }

    static {
        valueParserFactoryMap.put(ATypeTag.INTEGER, IntegerParserFactory.INSTANCE);
        valueParserFactoryMap.put(ATypeTag.FLOAT, FloatParserFactory.INSTANCE);
        valueParserFactoryMap.put(ATypeTag.DOUBLE, DoubleParserFactory.INSTANCE);
        valueParserFactoryMap.put(ATypeTag.BIGINT, LongParserFactory.INSTANCE);
        valueParserFactoryMap.put(ATypeTag.STRING, UTF8StringParserFactory.INSTANCE);
        valueParserFactoryMap.put(ATypeTag.BOOLEAN, BooleanParserFactory.INSTANCE);
    }

    public static class GCS {
        private GCS() {
            throw new AssertionError((Object)"do not instantiate");
        }

        public static Storage buildClient(Map<String, String> configuration) throws CompilationException {
            String jsonCredentials = configuration.get("jsonCredentials");
            StorageOptions.Builder builder = StorageOptions.newBuilder();
            if (jsonCredentials != null) {
                try (ByteArrayInputStream credentialsStream = new ByteArrayInputStream(jsonCredentials.getBytes());){
                    builder.setCredentials((Credentials)ServiceAccountCredentials.fromStream((InputStream)credentialsStream));
                }
                catch (IOException ex) {
                    throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
                }
            }
            return (Storage)builder.build().getService();
        }

        public static void validateProperties(Map<String, String> configuration, SourceLocation srcLoc, IWarningCollector collector) throws CompilationException {
            if (configuration.get("format") == null) {
                throw new CompilationException(ErrorCode.PARAMETERS_REQUIRED, srcLoc, new Serializable[]{"format"});
            }
            if (ExternalDataUtils.isParquetFormat(configuration)) {
                throw new CompilationException(ErrorCode.INVALID_REQ_PARAM_VAL, srcLoc, new Serializable[]{"format", (Serializable)((Object)configuration.get("format"))});
            }
            ExternalDataUtils.validateIncludeExclude(configuration);
            String container = configuration.get("container");
            try {
                Storage.BlobListOption limitOption = Storage.BlobListOption.pageSize((long)1L);
                Storage.BlobListOption prefixOption = Storage.BlobListOption.prefix((String)ExternalDataUtils.getPrefix(configuration));
                Storage storage = GCS.buildClient(configuration);
                Page items = storage.list(container, new Storage.BlobListOption[]{limitOption, prefixOption});
                if (!items.iterateAll().iterator().hasNext() && collector.shouldWarn()) {
                    Warning warning = Warning.of((SourceLocation)srcLoc, (IError)ErrorCode.EXTERNAL_SOURCE_CONFIGURATION_RETURNED_NO_FILES, (Serializable[])new Serializable[0]);
                    collector.warn(warning);
                }
            }
            catch (CompilationException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
            }
        }
    }

    public static class Azure {
        private Azure() {
            throw new AssertionError((Object)"do not instantiate");
        }

        public static BlobServiceClient buildAzureBlobClient(IApplicationContext appCtx, Map<String, String> configuration) throws CompilationException {
            AzureSasCredential credential;
            Optional<String> provided;
            String managedIdentityId = configuration.get("managedIdentityId");
            String accountName = configuration.get("accountName");
            String accountKey = configuration.get("accountKey");
            String sharedAccessSignature = configuration.get("sharedAccessSignature");
            String tenantId = configuration.get("tenantId");
            String clientId = configuration.get("clientId");
            String clientSecret = configuration.get("clientSecret");
            String clientCertificate = configuration.get("clientCertificate");
            String clientCertificatePassword = configuration.get("clientCertificatePassword");
            String endpoint = configuration.get("endpoint");
            BlobServiceClientBuilder builder = new BlobServiceClientBuilder();
            int timeout = appCtx.getExternalProperties().getAzureRequestTimeout();
            RequestRetryOptions requestRetryOptions = new RequestRetryOptions(null, null, Integer.valueOf(timeout), null, null, null);
            builder.retryOptions(requestRetryOptions);
            if (endpoint == null) {
                throw new CompilationException(ErrorCode.PARAMETERS_REQUIRED, new Serializable[]{"endpoint"});
            }
            builder.endpoint(endpoint);
            if (accountName != null || accountKey != null) {
                if (accountName == null) {
                    throw new CompilationException(ErrorCode.REQUIRED_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"accountName", "accountKey"});
                }
                if (accountKey == null) {
                    throw new CompilationException(ErrorCode.REQUIRED_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"accountKey", "accountName"});
                }
                provided = ExternalDataUtils.getFirstNotNull(configuration, "sharedAccessSignature", "managedIdentityId", "clientId", "clientSecret", "clientCertificate", "clientCertificatePassword", "tenantId");
                if (provided.isPresent()) {
                    throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{(Serializable)((Object)provided.get()), "accountKey"});
                }
                credential = new StorageSharedKeyCredential(accountName, accountKey);
                builder.credential((StorageSharedKeyCredential)credential);
            }
            if (sharedAccessSignature != null) {
                provided = ExternalDataUtils.getFirstNotNull(configuration, "managedIdentityId", "clientId", "clientSecret", "clientCertificate", "clientCertificatePassword", "tenantId");
                if (provided.isPresent()) {
                    throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{(Serializable)((Object)provided.get()), "sharedAccessSignature"});
                }
                credential = new AzureSasCredential(sharedAccessSignature);
                builder.credential(credential);
            }
            if (managedIdentityId != null) {
                provided = ExternalDataUtils.getFirstNotNull(configuration, "clientId", "clientSecret", "clientCertificate", "clientCertificatePassword", "tenantId");
                if (provided.isPresent()) {
                    throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{(Serializable)((Object)provided.get()), "managedIdentityId"});
                }
                builder.credential((TokenCredential)new ManagedIdentityCredentialBuilder().clientId(managedIdentityId).build());
            }
            if (clientId != null) {
                if (clientSecret == null == (clientCertificate == null)) {
                    if (clientSecret != null) {
                        throw new CompilationException(ErrorCode.PARAMETERS_NOT_ALLOWED_AT_SAME_TIME, new Serializable[]{"clientSecret", "clientCertificate"});
                    }
                    throw new CompilationException(ErrorCode.REQUIRED_PARAM_OR_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"clientSecret", "clientCertificate", "clientId"});
                }
                if (tenantId == null) {
                    throw new CompilationException(ErrorCode.REQUIRED_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"tenantId", "clientId"});
                }
                if (clientCertificatePassword != null && clientSecret != null) {
                    throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{"clientCertificatePassword", "clientSecret"});
                }
                if (clientSecret != null) {
                    ClientSecretCredentialBuilder secret = new ClientSecretCredentialBuilder();
                    secret.clientId(clientId);
                    secret.tenantId(tenantId);
                    secret.clientSecret(clientSecret);
                    builder.credential((TokenCredential)secret.build());
                } else {
                    ClientCertificateCredentialBuilder certificate = new ClientCertificateCredentialBuilder();
                    certificate.clientId(clientId);
                    certificate.tenantId(tenantId);
                    try {
                        ByteArrayInputStream certificateContent = new ByteArrayInputStream(clientCertificate.getBytes(StandardCharsets.UTF_8));
                        if (clientCertificatePassword == null) {
                            Method pemCertificate = ClientCertificateCredentialBuilder.class.getDeclaredMethod("pemCertificate", InputStream.class);
                            pemCertificate.setAccessible(true);
                            pemCertificate.invoke((Object)certificate, certificateContent);
                        } else {
                            Method pemCertificate = ClientCertificateCredentialBuilder.class.getDeclaredMethod("pfxCertificate", InputStream.class, String.class);
                            pemCertificate.setAccessible(true);
                            pemCertificate.invoke((Object)certificate, certificateContent, clientCertificatePassword);
                        }
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                        throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ex.getMessage()});
                    }
                    builder.credential((TokenCredential)certificate.build());
                }
            }
            if (clientId == null && (provided = ExternalDataUtils.getFirstNotNull(configuration, "clientSecret", "clientCertificate", "clientCertificatePassword", "tenantId")).isPresent()) {
                throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{(Serializable)((Object)provided.get()), "sharedAccessSignature"});
            }
            try {
                return builder.buildClient();
            }
            catch (Exception ex) {
                throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
            }
        }

        public static DataLakeServiceClient buildAzureDatalakeClient(IApplicationContext appCtx, Map<String, String> configuration) throws CompilationException {
            AzureSasCredential credential;
            Optional<String> provided;
            String managedIdentityId = configuration.get("managedIdentityId");
            String accountName = configuration.get("accountName");
            String accountKey = configuration.get("accountKey");
            String sharedAccessSignature = configuration.get("sharedAccessSignature");
            String tenantId = configuration.get("tenantId");
            String clientId = configuration.get("clientId");
            String clientSecret = configuration.get("clientSecret");
            String clientCertificate = configuration.get("clientCertificate");
            String clientCertificatePassword = configuration.get("clientCertificatePassword");
            String endpoint = configuration.get("endpoint");
            DataLakeServiceClientBuilder builder = new DataLakeServiceClientBuilder();
            int timeout = appCtx.getExternalProperties().getAzureRequestTimeout();
            RequestRetryOptions requestRetryOptions = new RequestRetryOptions(null, null, Integer.valueOf(timeout), null, null, null);
            builder.retryOptions(requestRetryOptions);
            if (endpoint == null) {
                throw new CompilationException(ErrorCode.PARAMETERS_REQUIRED, new Serializable[]{"endpoint"});
            }
            builder.endpoint(endpoint);
            if (accountName != null || accountKey != null) {
                if (accountName == null) {
                    throw new CompilationException(ErrorCode.REQUIRED_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"accountName", "accountKey"});
                }
                if (accountKey == null) {
                    throw new CompilationException(ErrorCode.REQUIRED_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"accountKey", "accountName"});
                }
                provided = ExternalDataUtils.getFirstNotNull(configuration, "sharedAccessSignature", "managedIdentityId", "clientId", "clientSecret", "clientCertificate", "clientCertificatePassword", "tenantId");
                if (provided.isPresent()) {
                    throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{(Serializable)((Object)provided.get()), "accountKey"});
                }
                credential = new StorageSharedKeyCredential(accountName, accountKey);
                builder.credential((StorageSharedKeyCredential)credential);
            }
            if (sharedAccessSignature != null) {
                provided = ExternalDataUtils.getFirstNotNull(configuration, "managedIdentityId", "clientId", "clientSecret", "clientCertificate", "clientCertificatePassword", "tenantId");
                if (provided.isPresent()) {
                    throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{(Serializable)((Object)provided.get()), "sharedAccessSignature"});
                }
                credential = new AzureSasCredential(sharedAccessSignature);
                builder.credential(credential);
            }
            if (managedIdentityId != null) {
                provided = ExternalDataUtils.getFirstNotNull(configuration, "clientId", "clientSecret", "clientCertificate", "clientCertificatePassword", "tenantId");
                if (provided.isPresent()) {
                    throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{(Serializable)((Object)provided.get()), "managedIdentityId"});
                }
                builder.credential((TokenCredential)new ManagedIdentityCredentialBuilder().clientId(managedIdentityId).build());
            }
            if (clientId != null) {
                if (clientSecret == null == (clientCertificate == null)) {
                    if (clientSecret != null) {
                        throw new CompilationException(ErrorCode.PARAMETERS_NOT_ALLOWED_AT_SAME_TIME, new Serializable[]{"clientSecret", "clientCertificate"});
                    }
                    throw new CompilationException(ErrorCode.REQUIRED_PARAM_OR_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"clientSecret", "clientCertificate", "clientId"});
                }
                if (tenantId == null) {
                    throw new CompilationException(ErrorCode.REQUIRED_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"tenantId", "clientId"});
                }
                if (clientCertificatePassword != null && clientSecret != null) {
                    throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{"clientCertificatePassword", "clientSecret"});
                }
                if (clientSecret != null) {
                    ClientSecretCredentialBuilder secret = new ClientSecretCredentialBuilder();
                    secret.clientId(clientId);
                    secret.tenantId(tenantId);
                    secret.clientSecret(clientSecret);
                    builder.credential((TokenCredential)secret.build());
                } else {
                    ClientCertificateCredentialBuilder certificate = new ClientCertificateCredentialBuilder();
                    certificate.clientId(clientId);
                    certificate.tenantId(tenantId);
                    try {
                        ByteArrayInputStream certificateContent = new ByteArrayInputStream(clientCertificate.getBytes(StandardCharsets.UTF_8));
                        if (clientCertificatePassword == null) {
                            Method pemCertificate = ClientCertificateCredentialBuilder.class.getDeclaredMethod("pemCertificate", InputStream.class);
                            pemCertificate.setAccessible(true);
                            pemCertificate.invoke((Object)certificate, certificateContent);
                        } else {
                            Method pemCertificate = ClientCertificateCredentialBuilder.class.getDeclaredMethod("pfxCertificate", InputStream.class, String.class);
                            pemCertificate.setAccessible(true);
                            pemCertificate.invoke((Object)certificate, certificateContent, clientCertificatePassword);
                        }
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                        throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
                    }
                    builder.credential((TokenCredential)certificate.build());
                }
            }
            if (clientId == null && (provided = ExternalDataUtils.getFirstNotNull(configuration, "clientSecret", "clientCertificate", "clientCertificatePassword", "tenantId")).isPresent()) {
                throw new CompilationException(ErrorCode.PARAM_NOT_ALLOWED_IF_PARAM_IS_PRESENT, new Serializable[]{(Serializable)((Object)provided.get()), "sharedAccessSignature"});
            }
            try {
                return builder.buildClient();
            }
            catch (Exception ex) {
                throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
            }
        }

        public static List<BlobItem> listBlobItems(BlobServiceClient blobServiceClient, Map<String, String> configuration, AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher, IWarningCollector warningCollector) throws CompilationException {
            String container = configuration.get("container");
            ArrayList<BlobItem> filesOnly = new ArrayList<BlobItem>();
            ExternalDataUtils.validateIncludeExclude(configuration);
            try {
                BlobContainerClient blobContainer = blobServiceClient.getBlobContainerClient(container);
                ListBlobsOptions listBlobsOptions = new ListBlobsOptions();
                listBlobsOptions.setPrefix(ExternalDataUtils.getPrefix(configuration));
                PagedIterable blobItems = blobContainer.listBlobs(listBlobsOptions, null);
                Azure.collectAndFilterBlobFiles((Iterable<BlobItem>)blobItems, includeExcludeMatcher.getPredicate(), includeExcludeMatcher.getMatchersList(), filesOnly);
                if (filesOnly.isEmpty() && warningCollector.shouldWarn()) {
                    Warning warning = Warning.of(null, (IError)ErrorCode.EXTERNAL_SOURCE_CONFIGURATION_RETURNED_NO_FILES, (Serializable[])new Serializable[0]);
                    warningCollector.warn(warning);
                }
            }
            catch (Exception ex) {
                throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
            }
            return filesOnly;
        }

        private static void collectAndFilterBlobFiles(Iterable<BlobItem> items, BiPredicate<List<Matcher>, String> predicate, List<Matcher> matchers, List<BlobItem> filesOnly) {
            for (BlobItem item : items) {
                String uri = item.getName();
                if (uri.endsWith("/") || !predicate.test(matchers, uri)) continue;
                filesOnly.add(item);
            }
        }

        public static List<PathItem> listDatalakePathItems(DataLakeServiceClient client, Map<String, String> configuration, AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher, IWarningCollector warningCollector) throws CompilationException {
            String container = configuration.get("container");
            ArrayList<PathItem> filesOnly = new ArrayList<PathItem>();
            ExternalDataUtils.validateIncludeExclude(configuration);
            try {
                DataLakeFileSystemClient fileSystemClient = client.getFileSystemClient(container);
                ListPathsOptions listOptions = new ListPathsOptions();
                boolean recursive = Boolean.parseBoolean(configuration.get("recursive"));
                listOptions.setRecursive(recursive);
                listOptions.setPath(ExternalDataUtils.getPrefix(configuration, false));
                PagedIterable pathItems = fileSystemClient.listPaths(listOptions, null);
                Azure.collectAndFilterDatalakeFiles((Iterable<PathItem>)pathItems, includeExcludeMatcher.getPredicate(), includeExcludeMatcher.getMatchersList(), filesOnly);
                if (filesOnly.isEmpty() && warningCollector.shouldWarn()) {
                    Warning warning = Warning.of(null, (IError)ErrorCode.EXTERNAL_SOURCE_CONFIGURATION_RETURNED_NO_FILES, (Serializable[])new Serializable[0]);
                    warningCollector.warn(warning);
                }
            }
            catch (Exception ex) {
                throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
            }
            return filesOnly;
        }

        private static void collectAndFilterDatalakeFiles(Iterable<PathItem> items, BiPredicate<List<Matcher>, String> predicate, List<Matcher> matchers, List<PathItem> filesOnly) {
            for (PathItem item : items) {
                String uri = item.getName();
                if (uri.endsWith("/") || !predicate.test(matchers, uri)) continue;
                filesOnly.add(item);
            }
        }

        public static void validateAzureBlobProperties(Map<String, String> configuration, SourceLocation srcLoc, IWarningCollector collector, IApplicationContext appCtx) throws CompilationException {
            if (configuration.get("format") == null) {
                throw new CompilationException(ErrorCode.PARAMETERS_REQUIRED, srcLoc, new Serializable[]{"format"});
            }
            ExternalDataUtils.validateIncludeExclude(configuration);
            try {
                String container = configuration.get("container");
                BlobServiceClient blobServiceClient = Azure.buildAzureBlobClient(appCtx, configuration);
                BlobContainerClient blobContainer = blobServiceClient.getBlobContainerClient(container);
                ListBlobsOptions listBlobsOptions = new ListBlobsOptions();
                listBlobsOptions.setPrefix(ExternalDataUtils.getPrefix(configuration));
                PagedIterable blobItems = blobContainer.listBlobs(listBlobsOptions, null);
                if (!blobItems.iterator().hasNext() && collector.shouldWarn()) {
                    Warning warning = Warning.of((SourceLocation)srcLoc, (IError)ErrorCode.EXTERNAL_SOURCE_CONFIGURATION_RETURNED_NO_FILES, (Serializable[])new Serializable[0]);
                    collector.warn(warning);
                }
            }
            catch (CompilationException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
            }
        }

        public static void validateAzureDataLakeProperties(Map<String, String> configuration, SourceLocation srcLoc, IWarningCollector collector, IApplicationContext appCtx) throws CompilationException {
            if (configuration.get("format") == null) {
                throw new CompilationException(ErrorCode.PARAMETERS_REQUIRED, srcLoc, new Serializable[]{"format"});
            }
            ExternalDataUtils.validateIncludeExclude(configuration);
            try {
                String container = configuration.get("container");
                DataLakeServiceClient dataLakeServiceClient = Azure.buildAzureDatalakeClient(appCtx, configuration);
                DataLakeFileSystemClient fileSystemClient = dataLakeServiceClient.getFileSystemClient(container);
                ListPathsOptions listPathsOptions = new ListPathsOptions();
                listPathsOptions.setPath(ExternalDataUtils.getPrefix(configuration));
                PagedIterable blobItems = fileSystemClient.listPaths(listPathsOptions, null);
                if (!blobItems.iterator().hasNext() && collector.shouldWarn()) {
                    Warning warning = Warning.of((SourceLocation)srcLoc, (IError)ErrorCode.EXTERNAL_SOURCE_CONFIGURATION_RETURNED_NO_FILES, (Serializable[])new Serializable[0]);
                    collector.warn(warning);
                }
            }
            catch (CompilationException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
            }
        }

        public static void configureAzureHdfsJobConf(JobConf conf, Map<String, String> configuration, String endPoint) {
            String container = configuration.get("container");
            String accountKey = configuration.get("accountKey");
            String sharedAccessSignature = configuration.get("sharedAccessSignature");
            HDFSUtils.disableHadoopFileSystemCache((Configuration)conf, "wasbs");
            StringBuilder hadoopKey = new StringBuilder();
            if (accountKey != null || sharedAccessSignature != null) {
                String hadoopValue;
                if (accountKey != null) {
                    hadoopKey.append("fs.azure.account.key").append('.');
                    hadoopValue = accountKey;
                } else {
                    hadoopKey.append("fs.azure.sas").append('.');
                    hadoopKey.append(container).append('.');
                    hadoopValue = sharedAccessSignature;
                }
                hadoopKey.append(endPoint);
                conf.set(hadoopKey.toString(), hadoopValue);
            }
        }
    }

    public static class AwsS3 {
        private AwsS3() {
            throw new AssertionError((Object)"do not instantiate");
        }

        public static S3Client buildAwsS3Client(Map<String, String> configuration) throws CompilationException {
            String accessKeyId = configuration.get("accessKeyId");
            String secretAccessKey = configuration.get("secretAccessKey");
            String sessionToken = configuration.get("sessionToken");
            String regionId = configuration.get("region");
            String serviceEndpoint = configuration.get("serviceEndpoint");
            S3ClientBuilder builder = S3Client.builder();
            Object credentialsProvider = accessKeyId == null ? AnonymousCredentialsProvider.create() : (sessionToken != null ? StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)accessKeyId, (String)secretAccessKey, (String)sessionToken)) : StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKeyId, (String)secretAccessKey)));
            builder.credentialsProvider((AwsCredentialsProvider)credentialsProvider);
            List regions = S3Client.serviceMetadata().regions();
            Optional<Region> selectedRegion = regions.stream().filter(region -> region.id().equals(regionId)).findFirst();
            if (selectedRegion.isEmpty()) {
                throw new CompilationException(ErrorCode.S3_REGION_NOT_SUPPORTED, new Serializable[]{regionId});
            }
            builder.region(selectedRegion.get());
            if (serviceEndpoint != null) {
                try {
                    URI uri = new URI(serviceEndpoint);
                    try {
                        builder.endpointOverride(uri);
                    }
                    catch (NullPointerException ex) {
                        throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
                    }
                }
                catch (URISyntaxException ex) {
                    throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{String.format("Invalid service endpoint %s", serviceEndpoint)});
                }
            }
            return (S3Client)builder.build();
        }

        public static void configureAwsS3HdfsJobConf(JobConf conf, Map<String, String> configuration, int numberOfPartitions) {
            String accessKeyId = configuration.get("accessKeyId");
            String secretAccessKey = configuration.get("secretAccessKey");
            String sessionToken = configuration.get("sessionToken");
            String serviceEndpoint = configuration.get("serviceEndpoint");
            HDFSUtils.disableHadoopFileSystemCache((Configuration)conf, "s3a");
            if (accessKeyId == null) {
                conf.set("fs.s3a.aws.credentials.provider", "org.apache.hadoop.fs.s3a.AnonymousAWSCredentialsProvider");
            } else {
                conf.set("fs.s3a.access.key", accessKeyId);
                conf.set("fs.s3a.secret.key", secretAccessKey);
                if (sessionToken != null) {
                    conf.set("fs.s3a.session.token", sessionToken);
                    conf.set("fs.s3a.aws.credentials.provider", "org.apache.hadoop.fs.s3a.TemporaryAWSCredentialsProvider");
                }
            }
            conf.set("fs.s3a.path.style.access", "true");
            conf.set("fs.s3a.connection.maximum", String.valueOf(numberOfPartitions));
            if (serviceEndpoint != null) {
                conf.set("fs.s3a.endpoint", serviceEndpoint);
            } else {
                conf.set("fs.s3a.endpoint", "s3.amazonaws.com");
            }
        }

        public static void validateProperties(Map<String, String> configuration, SourceLocation srcLoc, IWarningCollector collector) throws CompilationException {
            boolean isEmpty;
            S3Response response;
            String container;
            boolean useOldApi;
            block17: {
                if (configuration.get("format") == null) {
                    throw new CompilationException(ErrorCode.PARAMETERS_REQUIRED, srcLoc, new Serializable[]{"format"});
                }
                String accessKeyId = configuration.get("accessKeyId");
                String secretAccessKey = configuration.get("secretAccessKey");
                if (accessKeyId == null || secretAccessKey == null) {
                    if (accessKeyId != null) {
                        throw new CompilationException(ErrorCode.REQUIRED_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"secretAccessKey", "accessKeyId"});
                    }
                    if (secretAccessKey != null) {
                        throw new CompilationException(ErrorCode.REQUIRED_PARAM_IF_PARAM_IS_PRESENT, new Serializable[]{"accessKeyId", "secretAccessKey"});
                    }
                }
                ExternalDataUtils.validateIncludeExclude(configuration);
                S3Client s3Client = AwsS3.buildAwsS3Client(configuration);
                useOldApi = false;
                container = configuration.get("container");
                String prefix = ExternalDataUtils.getPrefix(configuration);
                try {
                    response = AwsS3.isBucketEmpty(s3Client, container, prefix, false);
                }
                catch (S3Exception ex) {
                    try {
                        if (ex.awsErrorDetails().errorCode().equals("NotImplemented")) {
                            useOldApi = true;
                            response = AwsS3.isBucketEmpty(s3Client, container, prefix, true);
                            break block17;
                        }
                        throw ex;
                    }
                    catch (SdkException ex2) {
                        throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
                    }
                }
                catch (SdkException ex) {
                    throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
                }
                finally {
                    if (s3Client != null) {
                        CleanupUtils.close((AutoCloseable)s3Client, null);
                    }
                }
            }
            boolean bl = isEmpty = useOldApi ? ((ListObjectsResponse)response).contents().isEmpty() : ((ListObjectsV2Response)response).contents().isEmpty();
            if (isEmpty && collector.shouldWarn()) {
                Warning warning = Warning.of((SourceLocation)srcLoc, (IError)ErrorCode.EXTERNAL_SOURCE_CONFIGURATION_RETURNED_NO_FILES, (Serializable[])new Serializable[0]);
                collector.warn(warning);
            }
            if (!response.sdkHttpResponse().isSuccessful()) {
                throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_CONTAINER_NOT_FOUND, new Serializable[]{container});
            }
        }

        private static S3Response isBucketEmpty(S3Client s3Client, String container, String prefix, boolean useOldApi) {
            ListObjectsResponse response;
            if (useOldApi) {
                ListObjectsRequest.Builder listObjectsBuilder = ListObjectsRequest.builder();
                listObjectsBuilder.prefix(prefix);
                response = s3Client.listObjects((ListObjectsRequest)listObjectsBuilder.bucket(container).maxKeys(Integer.valueOf(1)).build());
            } else {
                ListObjectsV2Request.Builder listObjectsBuilder = ListObjectsV2Request.builder();
                listObjectsBuilder.prefix(prefix);
                response = s3Client.listObjectsV2((ListObjectsV2Request)listObjectsBuilder.bucket(container).maxKeys(Integer.valueOf(1)).build());
            }
            return response;
        }

        public static List<S3Object> listS3Objects(Map<String, String> configuration, AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher, IWarningCollector warningCollector) throws CompilationException {
            List<S3Object> filesOnly;
            block12: {
                String container = configuration.get("container");
                S3Client s3Client = AwsS3.buildAwsS3Client(configuration);
                String prefix = ExternalDataUtils.getPrefix(configuration);
                try {
                    filesOnly = AwsS3.listS3Objects(s3Client, container, prefix, includeExcludeMatcher);
                }
                catch (S3Exception ex) {
                    try {
                        if (ex.awsErrorDetails().errorCode().equals("NotImplemented")) {
                            filesOnly = AwsS3.oldApiListS3Objects(s3Client, container, prefix, includeExcludeMatcher);
                            break block12;
                        }
                        throw ex;
                    }
                    catch (SdkException ex2) {
                        throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
                    }
                }
                catch (SdkException ex) {
                    throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
                }
                finally {
                    if (s3Client != null) {
                        CleanupUtils.close((AutoCloseable)s3Client, null);
                    }
                }
            }
            if (filesOnly.isEmpty() && warningCollector.shouldWarn()) {
                Warning warning = Warning.of(null, (IError)ErrorCode.EXTERNAL_SOURCE_CONFIGURATION_RETURNED_NO_FILES, (Serializable[])new Serializable[0]);
                warningCollector.warn(warning);
            }
            return filesOnly;
        }

        private static List<S3Object> listS3Objects(S3Client s3Client, String container, String prefix, AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher) {
            String newMarker = null;
            ArrayList<S3Object> filesOnly = new ArrayList<S3Object>();
            ListObjectsV2Request.Builder listObjectsBuilder = ListObjectsV2Request.builder().bucket(container);
            listObjectsBuilder.prefix(prefix);
            while (true) {
                ListObjectsV2Response listObjectsResponse = newMarker == null ? s3Client.listObjectsV2((ListObjectsV2Request)listObjectsBuilder.build()) : s3Client.listObjectsV2((ListObjectsV2Request)listObjectsBuilder.continuationToken(newMarker).build());
                AwsS3.collectAndFilterFiles(listObjectsResponse.contents(), includeExcludeMatcher.getPredicate(), includeExcludeMatcher.getMatchersList(), filesOnly);
                if (!listObjectsResponse.isTruncated().booleanValue()) break;
                newMarker = listObjectsResponse.nextContinuationToken();
            }
            return filesOnly;
        }

        private static List<S3Object> oldApiListS3Objects(S3Client s3Client, String container, String prefix, AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher) {
            String newMarker = null;
            ArrayList<S3Object> filesOnly = new ArrayList<S3Object>();
            ListObjectsRequest.Builder listObjectsBuilder = ListObjectsRequest.builder().bucket(container);
            listObjectsBuilder.prefix(prefix);
            while (true) {
                ListObjectsResponse listObjectsResponse = newMarker == null ? s3Client.listObjects((ListObjectsRequest)listObjectsBuilder.build()) : s3Client.listObjects((ListObjectsRequest)listObjectsBuilder.marker(newMarker).build());
                AwsS3.collectAndFilterFiles(listObjectsResponse.contents(), includeExcludeMatcher.getPredicate(), includeExcludeMatcher.getMatchersList(), filesOnly);
                if (!listObjectsResponse.isTruncated().booleanValue()) break;
                newMarker = listObjectsResponse.nextMarker();
            }
            return filesOnly;
        }

        private static void collectAndFilterFiles(List<S3Object> s3Objects, BiPredicate<List<Matcher>, String> predicate, List<Matcher> matchers, List<S3Object> filesOnly) {
            for (S3Object object : s3Objects) {
                if (object.key().endsWith("/") || !predicate.test(matchers, object.key())) continue;
                filesOnly.add(object);
            }
        }
    }
}

