/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.visitor.base;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.IfExpr;
import org.apache.asterix.lang.common.expression.IndexAccessor;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.ListSliceExpression;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.UnaryExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.NestClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.expression.WindowExpression;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppQueryExpressionVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class AbstractSqlppSimpleExpressionVisitor
extends AbstractSqlppQueryExpressionVisitor<Expression, ILangExpression> {
    @Override
    public Expression visit(FromClause fromClause, ILangExpression arg) throws CompilationException {
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            this.visit(fromTerm, arg);
        }
        return null;
    }

    @Override
    public Expression visit(FromTerm fromTerm, ILangExpression arg) throws CompilationException {
        fromTerm.setLeftExpression(this.visit(fromTerm.getLeftExpression(), arg));
        for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
            correlateClause.accept(this, arg);
        }
        return null;
    }

    @Override
    public Expression visit(JoinClause joinClause, ILangExpression arg) throws CompilationException {
        joinClause.setRightExpression(this.visit(joinClause.getRightExpression(), arg));
        joinClause.setConditionExpression(this.visit(joinClause.getConditionExpression(), arg));
        return null;
    }

    @Override
    public Expression visit(NestClause nestClause, ILangExpression arg) throws CompilationException {
        nestClause.setRightExpression(this.visit(nestClause.getRightExpression(), arg));
        nestClause.setConditionExpression(this.visit(nestClause.getConditionExpression(), arg));
        return null;
    }

    @Override
    public Expression visit(UnnestClause unnestClause, ILangExpression arg) throws CompilationException {
        unnestClause.setRightExpression(this.visit(unnestClause.getRightExpression(), arg));
        return null;
    }

    @Override
    public Expression visit(Projection projection, ILangExpression arg) throws CompilationException {
        if (projection.hasExpression()) {
            projection.setExpression(this.visit(projection.getExpression(), arg));
        }
        return null;
    }

    @Override
    public Expression visit(SelectBlock selectBlock, ILangExpression arg) throws CompilationException {
        if (selectBlock.hasFromClause()) {
            selectBlock.getFromClause().accept(this, arg);
        }
        if (selectBlock.hasLetWhereClauses()) {
            for (AbstractClause clause : selectBlock.getLetWhereList()) {
                clause.accept((ILangVisitor)this, (Object)arg);
            }
        }
        if (selectBlock.hasGroupbyClause()) {
            selectBlock.getGroupbyClause().accept((ILangVisitor)this, (Object)arg);
        }
        if (selectBlock.hasLetHavingClausesAfterGroupby()) {
            for (AbstractClause clause : selectBlock.getLetHavingListAfterGroupby()) {
                clause.accept((ILangVisitor)this, (Object)arg);
            }
        }
        selectBlock.getSelectClause().accept(this, arg);
        return null;
    }

    @Override
    public Expression visit(SelectClause selectClause, ILangExpression arg) throws CompilationException {
        if (selectClause.selectElement()) {
            selectClause.getSelectElement().accept(this, selectClause);
        }
        if (selectClause.selectRegular()) {
            selectClause.getSelectRegular().accept(this, selectClause);
        }
        return null;
    }

    @Override
    public Expression visit(SelectElement selectElement, ILangExpression arg) throws CompilationException {
        selectElement.setExpression(this.visit(selectElement.getExpression(), (ILangExpression)selectElement));
        return null;
    }

    @Override
    public Expression visit(SelectRegular selectRegular, ILangExpression arg) throws CompilationException {
        for (Projection projection : selectRegular.getProjections()) {
            projection.accept(this, arg);
        }
        return null;
    }

    @Override
    public Expression visit(SelectSetOperation selectSetOperation, ILangExpression arg) throws CompilationException {
        selectSetOperation.getLeftInput().accept(this, arg);
        for (SetOperationRight right : selectSetOperation.getRightInputs()) {
            right.getSetOperationRightInput().accept(this, arg);
        }
        return null;
    }

    @Override
    public Expression visit(HavingClause havingClause, ILangExpression arg) throws CompilationException {
        havingClause.setFilterExpression(this.visit(havingClause.getFilterExpression(), (ILangExpression)havingClause));
        return null;
    }

    public Expression visit(Query q, ILangExpression arg) throws CompilationException {
        q.setBody(this.visit(q.getBody(), (ILangExpression)q));
        return null;
    }

    public Expression visit(FunctionDecl fd, ILangExpression arg) throws CompilationException {
        fd.setFuncBody(this.visit(fd.getFuncBody(), (ILangExpression)fd));
        return null;
    }

    public Expression visit(WhereClause whereClause, ILangExpression arg) throws CompilationException {
        whereClause.setWhereExpr(this.visit(whereClause.getWhereExpr(), (ILangExpression)whereClause));
        return null;
    }

    public Expression visit(OrderbyClause oc, ILangExpression arg) throws CompilationException {
        oc.setOrderbyList(this.visit(oc.getOrderbyList(), (ILangExpression)oc));
        return null;
    }

    public Expression visit(GroupbyClause gc, ILangExpression arg) throws CompilationException {
        for (List gbyPairList : gc.getGbyPairList()) {
            for (GbyVariableExpressionPair gbyVarExpr : gbyPairList) {
                gbyVarExpr.setExpr(this.visit(gbyVarExpr.getExpr(), (ILangExpression)gc));
            }
        }
        if (gc.hasDecorList()) {
            for (GbyVariableExpressionPair decVarExpr : gc.getDecorPairList()) {
                decVarExpr.setExpr(this.visit(decVarExpr.getExpr(), (ILangExpression)gc));
            }
        }
        return null;
    }

    public Expression visit(LimitClause limitClause, ILangExpression arg) throws CompilationException {
        if (limitClause.hasLimitExpr()) {
            limitClause.setLimitExpr(this.visit(limitClause.getLimitExpr(), (ILangExpression)limitClause));
        }
        if (limitClause.hasOffset()) {
            limitClause.setOffset(this.visit(limitClause.getOffset(), (ILangExpression)limitClause));
        }
        return null;
    }

    public Expression visit(LetClause letClause, ILangExpression arg) throws CompilationException {
        letClause.setBindingExpr(this.visit(letClause.getBindingExpr(), (ILangExpression)letClause));
        return null;
    }

    @Override
    public Expression visit(SelectExpression selectExpression, ILangExpression arg) throws CompilationException {
        if (selectExpression.hasLetClauses()) {
            for (LetClause letClause : selectExpression.getLetList()) {
                letClause.accept((ILangVisitor)this, (Object)selectExpression);
            }
        }
        selectExpression.getSelectSetOperation().accept(this, selectExpression);
        if (selectExpression.hasOrderby()) {
            selectExpression.getOrderbyClause().accept((ILangVisitor)this, (Object)selectExpression);
        }
        if (selectExpression.hasLimit()) {
            selectExpression.getLimitClause().accept((ILangVisitor)this, (Object)selectExpression);
        }
        return selectExpression;
    }

    public Expression visit(LiteralExpr l, ILangExpression arg) throws CompilationException {
        return l;
    }

    public Expression visit(ListConstructor lc, ILangExpression arg) throws CompilationException {
        lc.setExprList(this.visit(lc.getExprList(), arg));
        return lc;
    }

    public Expression visit(RecordConstructor rc, ILangExpression arg) throws CompilationException {
        for (FieldBinding binding : rc.getFbList()) {
            binding.setLeftExpr(this.visit(binding.getLeftExpr(), arg));
            binding.setRightExpr(this.visit(binding.getRightExpr(), arg));
        }
        return rc;
    }

    public Expression visit(OperatorExpr operatorExpr, ILangExpression arg) throws CompilationException {
        operatorExpr.setExprList(this.visit(operatorExpr.getExprList(), arg));
        return operatorExpr;
    }

    public Expression visit(IfExpr ifExpr, ILangExpression arg) throws CompilationException {
        ifExpr.setCondExpr(this.visit(ifExpr.getCondExpr(), arg));
        ifExpr.setThenExpr(this.visit(ifExpr.getThenExpr(), arg));
        ifExpr.setElseExpr(this.visit(ifExpr.getElseExpr(), arg));
        return ifExpr;
    }

    public Expression visit(QuantifiedExpression qe, ILangExpression arg) throws CompilationException {
        for (QuantifiedPair pair : qe.getQuantifiedList()) {
            pair.setExpr(this.visit(pair.getExpr(), (ILangExpression)qe));
        }
        qe.setSatisfiesExpr(this.visit(qe.getSatisfiesExpr(), (ILangExpression)qe));
        return qe;
    }

    public Expression visit(CallExpr callExpr, ILangExpression arg) throws CompilationException {
        callExpr.setExprList(this.visit(callExpr.getExprList(), arg));
        if (callExpr.hasAggregateFilterExpr()) {
            callExpr.setAggregateFilterExpr(this.visit(callExpr.getAggregateFilterExpr(), arg));
        }
        return callExpr;
    }

    public Expression visit(VariableExpr varExpr, ILangExpression arg) throws CompilationException {
        return varExpr;
    }

    public Expression visit(UnaryExpr u, ILangExpression arg) throws CompilationException {
        u.setExpr(this.visit(u.getExpr(), arg));
        return u;
    }

    @Override
    public Expression visit(WindowExpression winExpr, ILangExpression arg) throws CompilationException {
        this.visitWindowExpressionExcludingExprListAndAggFilter(winExpr, arg);
        winExpr.setExprList(this.visit(winExpr.getExprList(), arg));
        if (winExpr.hasAggregateFilterExpr()) {
            winExpr.setAggregateFilterExpr(this.visit(winExpr.getAggregateFilterExpr(), arg));
        }
        return winExpr;
    }

    protected void visitWindowExpressionExcludingExprListAndAggFilter(WindowExpression winExpr, ILangExpression arg) throws CompilationException {
        if (winExpr.hasPartitionList()) {
            winExpr.setPartitionList(this.visit(winExpr.getPartitionList(), arg));
        }
        if (winExpr.hasOrderByList()) {
            winExpr.setOrderbyList(this.visit(winExpr.getOrderbyList(), arg));
        }
        if (winExpr.hasFrameStartExpr()) {
            winExpr.setFrameStartExpr(this.visit(winExpr.getFrameStartExpr(), arg));
        }
        if (winExpr.hasFrameEndExpr()) {
            winExpr.setFrameEndExpr(this.visit(winExpr.getFrameEndExpr(), arg));
        }
        if (winExpr.hasWindowFieldList()) {
            for (Pair<Expression, Identifier> field : winExpr.getWindowFieldList()) {
                field.first = this.visit((Expression)field.first, arg);
            }
        }
    }

    public Expression visit(FieldAccessor fa, ILangExpression arg) throws CompilationException {
        fa.setExpr(this.visit(fa.getExpr(), arg));
        return fa;
    }

    public Expression visit(IndexAccessor ia, ILangExpression arg) throws CompilationException {
        ia.setExpr(this.visit(ia.getExpr(), arg));
        if (ia.getIndexExpr() != null) {
            ia.setIndexExpr(this.visit(ia.getIndexExpr(), arg));
        }
        return ia;
    }

    public Expression visit(ListSliceExpression expression, ILangExpression arg) throws CompilationException {
        expression.setExpr(this.visit(expression.getExpr(), arg));
        expression.setStartIndexExpression(this.visit(expression.getStartIndexExpression(), arg));
        if (expression.hasEndExpression()) {
            expression.setEndIndexExpression(this.visit(expression.getEndIndexExpression(), arg));
        }
        return expression;
    }

    @Override
    public Expression visit(CaseExpression caseExpr, ILangExpression arg) throws CompilationException {
        caseExpr.setConditionExpr(this.visit(caseExpr.getConditionExpr(), arg));
        caseExpr.setWhenExprs(this.visit(caseExpr.getWhenExprs(), arg));
        caseExpr.setThenExprs(this.visit(caseExpr.getThenExprs(), arg));
        caseExpr.setElseExpr(this.visit(caseExpr.getElseExpr(), arg));
        return caseExpr;
    }

    public Expression visit(InsertStatement insertStatement, ILangExpression arg) throws CompilationException {
        Expression returnExpr = insertStatement.getReturnExpression();
        if (returnExpr != null) {
            insertStatement.setReturnExpression(this.visit(returnExpr, arg));
        }
        Query bodyQuery = insertStatement.getQuery();
        bodyQuery.accept((ILangVisitor)this, (Object)arg);
        return null;
    }

    protected Expression visit(Expression expr, ILangExpression arg) throws CompilationException {
        return this.postVisit((Expression)this.preVisit(expr).accept((ILangVisitor)this, (Object)arg));
    }

    protected Expression preVisit(Expression expr) throws CompilationException {
        return expr;
    }

    protected Expression postVisit(Expression expr) throws CompilationException {
        return expr;
    }

    protected List<Expression> visit(List<Expression> exprs, ILangExpression arg) throws CompilationException {
        ArrayList<Expression> newExprList = new ArrayList<Expression>(exprs.size());
        for (Expression expr : exprs) {
            newExprList.add(this.visit(expr, arg));
        }
        return newExprList;
    }
}

