/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.rewrites;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DatasetFullyQualifiedName;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.ViewDecl;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.base.Counter;
import org.apache.hyracks.api.exceptions.IWarningCollector;

public final class LangRewritingContext {
    private final MetadataProvider metadataProvider;
    private final IWarningCollector warningCollector;
    private final Map<FunctionSignature, FunctionDecl> declaredFunctions;
    private final Map<DatasetFullyQualifiedName, ViewDecl> declaredViews;
    private final Counter varCounter;
    private int systemVarCounter = 1;
    private final Map<Integer, VarIdentifier> oldVarIdToNewVarId = new HashMap<Integer, VarIdentifier>();

    public LangRewritingContext(MetadataProvider metadataProvider, List<FunctionDecl> declaredFunctions, List<ViewDecl> declaredViews, IWarningCollector warningCollector, int varCounter) {
        this.metadataProvider = metadataProvider;
        this.warningCollector = warningCollector;
        this.declaredFunctions = LangRewritingContext.createMap(declaredFunctions, FunctionDecl::getSignature);
        this.declaredViews = LangRewritingContext.createMap(declaredViews, ViewDecl::getViewName);
        this.varCounter = new Counter(varCounter);
    }

    public Counter getVarCounter() {
        return this.varCounter;
    }

    public VarIdentifier mapOldId(Integer oldId, String varValue) {
        int n = this.increaseAndGetCtr();
        VarIdentifier newVar = new VarIdentifier(varValue);
        newVar.setId(n);
        this.oldVarIdToNewVarId.put(oldId, newVar);
        return newVar;
    }

    public VarIdentifier getRewrittenVar(Integer oldId) {
        return this.oldVarIdToNewVarId.get(oldId);
    }

    public VarIdentifier newVariable() {
        int id = this.increaseAndGetCtr();
        return new VarIdentifier("#" + this.systemVarCounter++, id);
    }

    private int increaseAndGetCtr() {
        this.varCounter.inc();
        return this.varCounter.get();
    }

    public IWarningCollector getWarningCollector() {
        return this.warningCollector;
    }

    public MetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public Map<FunctionSignature, FunctionDecl> getDeclaredFunctions() {
        return this.declaredFunctions;
    }

    public Map<DatasetFullyQualifiedName, ViewDecl> getDeclaredViews() {
        return this.declaredViews;
    }

    private static <K, V> Map<K, V> createMap(List<V> values, Function<V, K> keyMapper) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<K, V> result = new HashMap<K, V>();
        for (V v : values) {
            result.put(keyMapper.apply(v), v);
        }
        return Collections.unmodifiableMap(result);
    }
}

