/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.bytes.stream.out;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.asterix.column.bytes.stream.out.AbstractBytesOutputStream;
import org.apache.asterix.column.bytes.stream.out.pointer.GrowableBytesPointer;
import org.apache.asterix.column.bytes.stream.out.pointer.IReservedPointer;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public final class GrowableBytesOutputStream
extends AbstractBytesOutputStream {
    private final ArrayBackedValueStorage storage = new ArrayBackedValueStorage(128);

    @Override
    public void write(int b) throws IOException {
        this.storage.getDataOutput().write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.storage.getDataOutput().write(b, off, len);
    }

    @Override
    public void finish() {
        this.reset();
    }

    @Override
    public void reset() {
        this.storage.reset();
    }

    @Override
    public void reserveByte(IReservedPointer pointer) throws IOException {
        ((GrowableBytesPointer)pointer).setPointer(this.storage.getLength());
        this.storage.getDataOutput().write(0);
    }

    @Override
    public void reserveInteger(IReservedPointer pointer) throws IOException {
        ((GrowableBytesPointer)pointer).setPointer(this.storage.getLength());
        this.storage.getDataOutput().writeInt(0);
    }

    @Override
    public IReservedPointer createPointer() {
        return new GrowableBytesPointer(this.storage);
    }

    @Override
    public int size() {
        return this.storage.getLength();
    }

    @Override
    public int capacity() {
        return this.storage.getByteArray().length;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.storage.getByteArray(), this.storage.getStartOffset(), this.storage.getLength());
    }
}

