/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.bytes.stream.out;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.asterix.column.bytes.stream.out.AbstractMultiBufferBytesOutputStream;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnWriteMultiPageOp;
import org.apache.hyracks.util.StorageUtil;

public final class MultiTemporaryBufferBytesOutputStream
extends AbstractMultiBufferBytesOutputStream {
    private static final int INITIAL_BUFFER_SIZE = StorageUtil.getIntSizeInBytes((int)32, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.KILOBYTE);

    public MultiTemporaryBufferBytesOutputStream(Mutable<IColumnWriteMultiPageOp> multiPageOpRef) {
        super(multiPageOpRef);
    }

    @Override
    protected void preReset() {
    }

    @Override
    protected ByteBuffer confiscateNewBuffer() throws HyracksDataException {
        if (this.buffers.isEmpty()) {
            return ByteBuffer.allocate(INITIAL_BUFFER_SIZE);
        }
        return ((IColumnWriteMultiPageOp)this.multiPageOpRef.getValue()).confiscateTemporary();
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        int writtenSize = 0;
        for (int i = 0; i < this.currentBufferIndex + 1; ++i) {
            ByteBuffer buffer = (ByteBuffer)this.buffers.get(i);
            outputStream.write(buffer.array(), 0, buffer.position());
            writtenSize += buffer.position();
        }
        if (writtenSize != this.position) {
            throw new IllegalStateException("Size is different");
        }
    }
}

