/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.ioopcallbacks;

import org.apache.asterix.common.context.DatasetInfo;
import org.apache.asterix.common.ioopcallbacks.LSMIOOperationCallback;
import org.apache.asterix.common.storage.IIndexCheckpointManagerProvider;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;

public class AtomicLSMIOOperationCallback
extends LSMIOOperationCallback {
    public AtomicLSMIOOperationCallback(DatasetInfo dsInfo, ILSMIndex lsmIndex, ILSMComponentId componentId, IIndexCheckpointManagerProvider indexCheckpointManagerProvider) {
        super(dsInfo, lsmIndex, componentId, indexCheckpointManagerProvider);
    }

    @Override
    public void afterFinalize(ILSMIOOperation operation) throws HyracksDataException {
        if (operation.getStatus() == ILSMIOOperation.LSMIOOperationStatus.FAILURE) {
            return;
        }
        if (operation.getIOOpertionType() != ILSMIOOperation.LSMIOOperationType.LOAD && operation.getAccessor().getOpContext().getOperation() == IndexOperation.DELETE_COMPONENTS) {
            this.deleteComponentsFromCheckpoint(operation);
        } else if (operation.getIOOpertionType() == ILSMIOOperation.LSMIOOperationType.LOAD) {
            this.addComponentToCheckpoint(operation);
        } else if (this.isMerge(operation)) {
            IoUtil.delete((FileReference)AtomicLSMIOOperationCallback.getOperationMaskFilePath(operation));
        }
    }
}

