/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.utils;

import java.io.File;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.DefaultIoDeviceFileSplit;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.MappedFileSplit;
import org.apache.hyracks.dataflow.std.file.ConstantFileSplitProvider;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StoragePathUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final char DATAVERSE_CONTINUATION_MARKER = '^';
    private static final String PARTITION_PATH = "storage" + File.separator + "partition_";

    private StoragePathUtil() {
    }

    public static IFileSplitProvider splitProvider(FileSplit[] splits) {
        return new ConstantFileSplitProvider(splits);
    }

    public static Pair<IFileSplitProvider, AlgebricksPartitionConstraint> splitProviderAndPartitionConstraints(FileSplit[] splits) {
        IFileSplitProvider splitProvider = StoragePathUtil.splitProvider(splits);
        String[] loc = new String[splits.length];
        for (int p = 0; p < splits.length; ++p) {
            loc[p] = splits[p].getNodeName();
        }
        AlgebricksAbsolutePartitionConstraint pc = new AlgebricksAbsolutePartitionConstraint(loc);
        return new Pair((Object)splitProvider, (Object)pc);
    }

    public static FileSplit getFileSplitForClusterPartition(ClusterPartition partition, String relativePath) {
        return new MappedFileSplit(partition.getActiveNodeId(), relativePath, partition.getIODeviceNum());
    }

    public static FileSplit getDefaultIoDeviceFileSpiltForNode(String nodeId, String relativePath) {
        return new DefaultIoDeviceFileSplit(nodeId, relativePath);
    }

    public static String prepareStoragePartitionPath(int partitionId) {
        return Paths.get("storage", "partition_" + partitionId).toString();
    }

    public static String prepareIngestionLogPath() {
        return Paths.get("ingestion_logs", new String[0]).toString();
    }

    public static String prepareNamespaceIndexName(String datasetName, String idxName, long rebalanceCount, String namespacePath) {
        return StoragePathUtil.prepareNamespaceComponentName(namespacePath, StoragePathUtil.prepareFullIndexName(datasetName, idxName, rebalanceCount));
    }

    public static String prepareDataverseName(DataverseName dataverseName) {
        List<String> parts = dataverseName.getParts();
        if (parts.size() < 2) {
            return parts.get(0);
        }
        Iterator<String> dvParts = parts.iterator();
        StringBuilder builder = new StringBuilder();
        builder.append(dvParts.next());
        while (dvParts.hasNext()) {
            builder.append(File.separatorChar).append('^').append(dvParts.next());
        }
        return builder.toString();
    }

    public static String prepareNamespaceComponentName(String namespacePath, String component) {
        return namespacePath + File.separatorChar + component;
    }

    private static String prepareFullIndexName(String datasetName, String idxName, long rebalanceCount) {
        return datasetName + File.separator + rebalanceCount + File.separator + idxName;
    }

    public static int getPartitionNumFromRelativePath(String relativePath) {
        int startIdx = relativePath.lastIndexOf("partition_") + "partition_".length();
        int partitionEndIdx = relativePath.indexOf(File.separatorChar, startIdx);
        int idxEnd = partitionEndIdx != -1 ? partitionEndIdx : relativePath.length();
        String partition = relativePath.substring(startIdx, idxEnd);
        return Integer.parseInt(partition);
    }

    public static String getIndexFileRelativePath(String fileAbsolutePath) {
        return ResourceReference.of(fileAbsolutePath).getRelativePath().toString();
    }

    public static String getFileRelativePath(String fileAbsolutePath) {
        return ResourceReference.of(fileAbsolutePath).getFileRelativePath().toString();
    }

    public static File createFile(String name, int count) throws HyracksDataException {
        try {
            String fileName = name + "_" + count;
            File file = new File(fileName);
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                boolean success = file.createNewFile();
                if (!success) {
                    throw new HyracksDataException("Unable to create spill file " + fileName);
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Created spill file " + file.getAbsolutePath());
                }
            } else {
                throw new HyracksDataException("spill file " + fileName + " already exists");
            }
            return file;
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static String getIndexNameFromPath(String path) {
        return Paths.get(path, new String[0]).getFileName().toString();
    }

    public static FileReference getIndexPath(IIOManager ioManager, ResourceReference ref) throws HyracksDataException {
        return ioManager.resolve(ref.getRelativePath().toString());
    }

    public static String getIndexSubPath(FileReference fileReference, boolean isDirectory) {
        int end;
        String relativePath = fileReference.getRelativePath();
        if (relativePath.length() <= PARTITION_PATH.length() || !relativePath.startsWith(PARTITION_PATH)) {
            return "";
        }
        String partition = PARTITION_PATH + StoragePathUtil.getPartitionNumFromRelativePath(relativePath);
        int partitionStart = relativePath.indexOf(partition);
        int start = partitionStart + partition.length() + 1;
        int n = end = isDirectory ? relativePath.length() : relativePath.lastIndexOf(47);
        if (start >= end) {
            return "";
        }
        return relativePath.substring(start, end);
    }

    public static boolean hasSameStorageRoot(FileReference file1, FileReference file2) {
        return file1.getDeviceHandle().equals((Object)file2.getDeviceHandle());
    }

    public static boolean isRelativeParent(FileReference parent, FileReference child) {
        return child.getRelativePath().startsWith(parent.getRelativePath());
    }
}

