/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.prefetch;

import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.hadoop.fs.impl.prefetch.Validate;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AInputStream;
import org.apache.hadoop.fs.s3a.S3AReadOpContext;
import org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.hadoop.fs.s3a.impl.ChangeTracker;
import org.apache.hadoop.fs.s3a.impl.SDKStreamDrainer;
import org.apache.hadoop.fs.s3a.statistics.S3AInputStreamStatistics;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ARemoteObject {
    private static final Logger LOG = LoggerFactory.getLogger(S3ARemoteObject.class);
    private final S3AReadOpContext context;
    private final S3ObjectAttributes s3Attributes;
    private final S3AInputStream.InputStreamCallbacks client;
    private final S3AInputStreamStatistics streamStatistics;
    private final ChangeTracker changeTracker;
    private final Map<InputStream, S3Object> s3Objects;
    private final String uri;
    private static final int DRAIN_BUFFER_SIZE = 16384;

    public S3ARemoteObject(S3AReadOpContext context, S3ObjectAttributes s3Attributes, S3AInputStream.InputStreamCallbacks client, S3AInputStreamStatistics streamStatistics, ChangeTracker changeTracker) {
        Validate.checkNotNull((Object)context, (String)"context");
        Validate.checkNotNull((Object)s3Attributes, (String)"s3Attributes");
        Validate.checkNotNull((Object)client, (String)"client");
        Validate.checkNotNull((Object)streamStatistics, (String)"streamStatistics");
        Validate.checkNotNull((Object)changeTracker, (String)"changeTracker");
        this.context = context;
        this.s3Attributes = s3Attributes;
        this.client = client;
        this.streamStatistics = streamStatistics;
        this.changeTracker = changeTracker;
        this.s3Objects = new IdentityHashMap<InputStream, S3Object>();
        this.uri = this.getPath();
    }

    public Invoker getReadInvoker() {
        return this.context.getReadInvoker();
    }

    public S3AInputStreamStatistics getStatistics() {
        return this.streamStatistics;
    }

    public String getPath() {
        return S3ARemoteObject.getPath(this.s3Attributes);
    }

    public static String getPath(S3ObjectAttributes s3Attributes) {
        return String.format("s3a://%s/%s", s3Attributes.getBucket(), s3Attributes.getKey());
    }

    public long size() {
        return this.s3Attributes.getLen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openForRead(long offset, int size) throws IOException {
        Validate.checkNotNegative((long)offset, (String)"offset");
        Validate.checkLessOrEqual((long)offset, (String)"offset", (long)this.size(), (String)"size()");
        Validate.checkLessOrEqual((long)size, (String)"size", (long)(this.size() - offset), (String)"size() - offset");
        this.streamStatistics.streamOpened();
        GetObjectRequest request = this.client.newGetRequest(this.s3Attributes.getKey()).withRange(offset, offset + (long)size - 1L);
        this.changeTracker.maybeApplyConstraint(request);
        String operation = String.format("%s %s at %d", "open", this.uri, offset);
        S3Object object = null;
        try (DurationTracker tracker = this.streamStatistics.initiateGetRequest();){
            object = (S3Object)Invoker.once(operation, this.uri, () -> this.client.getObject(request));
        }
        this.changeTracker.processResponse(object, operation, offset);
        S3ObjectInputStream stream = object.getObjectContent();
        Map<InputStream, S3Object> map = this.s3Objects;
        synchronized (map) {
            this.s3Objects.put((InputStream)stream, object);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(InputStream inputStream, int numRemainingBytes) {
        S3Object obj;
        Map<InputStream, S3Object> map = this.s3Objects;
        synchronized (map) {
            obj = this.s3Objects.remove(inputStream);
            if (obj == null) {
                throw new IllegalArgumentException("inputStream not found");
            }
        }
        SDKStreamDrainer drainer = new SDKStreamDrainer(this.uri, (Closeable)obj, (SdkFilterInputStream)((S3ObjectInputStream)inputStream), false, numRemainingBytes, this.streamStatistics, "close() operation");
        if ((long)numRemainingBytes <= this.context.getAsyncDrainThreshold()) {
            drainer.apply();
        } else {
            LOG.debug("initiating asynchronous drain of {} bytes", (Object)numRemainingBytes);
            this.client.submit(drainer);
        }
    }
}

