/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.service;

import java.io.File;
import java.io.IOException;
import org.apache.hyracks.control.common.config.ConfigUtils;
import org.ini4j.Ini;
import org.kohsuke.args4j.Option;

public class NCServiceConfig {
    @Option(name="-config-file", required=false, usage="Local NC configuration file (default: none)")
    public String configFile = null;
    @Option(name="-address", required=false, usage="Address to listen on for connections from CC (default: all addresses)")
    public String address = null;
    @Option(name="-port", required=false, usage="Port to listen on for connections from CC (default: 9090)")
    public int port = 9090;
    @Option(name="-logdir", required=false, usage="Directory to log NC output ('-' for stdout of NC service; default: $app.home/logs)")
    public String logdir = null;
    private Ini ini = null;

    private void loadINIFile() throws IOException {
        this.ini = ConfigUtils.loadINIFile((String)this.configFile);
        this.address = ConfigUtils.getString((Ini)this.ini, (String)"ncservice", (String)"address", (String)this.address);
        this.port = ConfigUtils.getInt((Ini)this.ini, (String)"ncservice", (String)"port", (int)this.port);
        this.logdir = ConfigUtils.getString((Ini)this.ini, (String)"ncservice", (String)"logdir", (String)this.logdir);
    }

    public void loadConfigAndApplyDefaults() throws IOException {
        if (this.configFile != null) {
            this.loadINIFile();
        }
        if (this.logdir == null) {
            this.logdir = System.getProperty("app.home", System.getProperty("user.home")) + File.separator + "logs";
        }
    }
}

