/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve;

import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.ParquetConverterContext;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.nested.AbstractComplexConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.GenericPrimitiveConverter;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.Warning;

public class UnsignedIntegerConverter
extends GenericPrimitiveConverter {
    private boolean overflowed = false;

    UnsignedIntegerConverter(AbstractComplexConverter parent, String stringFieldName, int index, ParquetConverterContext context) throws IOException {
        super(ATypeTag.BIGINT, parent, stringFieldName, index, context);
    }

    @Override
    public void addInt(int value) {
        this.addLong((long)value & 0xFFFFFFFFL);
    }

    @Override
    public void addLong(long value) {
        if (value < 0L) {
            if (!this.overflowed) {
                Warning warning = Warning.of(null, (IError)ErrorCode.PARQUET_CONTAINS_OVERFLOWED_BIGINT, (Serializable[])new Serializable[]{ATypeTag.BIGINT});
                this.context.getWarnings().add(warning);
                this.overflowed = true;
            }
            return;
        }
        super.addLong(value);
    }
}

