/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser.factory;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.asterix.external.api.IExternalDataRuntimeContext;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IStreamDataParser;
import org.apache.asterix.external.parser.DelimitedDataParser;
import org.apache.asterix.external.parser.factory.AbstractRecordStreamParserFactory;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;

public class DelimitedDataParserFactory
extends AbstractRecordStreamParserFactory<char[]> {
    private static final long serialVersionUID = 1L;
    private static final List<String> parserFormats = Collections.unmodifiableList(Arrays.asList("csv", "delimited-text", "tsv"));

    @Override
    public IRecordDataParser<char[]> createRecordParser(IExternalDataRuntimeContext context) throws HyracksDataException {
        return this.createParser(context);
    }

    private DelimitedDataParser createParser(IExternalDataRuntimeContext context) throws HyracksDataException {
        IValueParserFactory[] valueParserFactories = ExternalDataUtils.getValueParserFactories(this.recordType);
        char delimiter = ExternalDataUtils.validateGetDelimiter(this.configuration);
        char quote = ExternalDataUtils.validateGetQuote(this.configuration, delimiter);
        boolean hasHeader = ExternalDataUtils.hasHeader(this.configuration);
        String nullString = (String)this.configuration.get("null");
        return new DelimitedDataParser(context, valueParserFactories, delimiter, quote, hasHeader, this.recordType, ExternalDataUtils.getDataSourceType(this.configuration).equals((Object)IExternalDataSourceFactory.DataSourceType.STREAM), nullString);
    }

    @Override
    public Class<? extends char[]> getRecordClass() {
        return char[].class;
    }

    @Override
    public IStreamDataParser createInputStreamParser(IExternalDataRuntimeContext context) throws HyracksDataException {
        return this.createParser(context);
    }

    @Override
    public void setMetaType(ARecordType metaType) {
    }

    @Override
    public List<String> getParserFormats() {
        return parserFormats;
    }
}

