/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataUtil;
import org.apache.asterix.metadata.bootstrap.CompactionPolicyEntity;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class CompactionPolicyTupleTranslator
extends AbstractTupleTranslator<CompactionPolicy> {
    private final CompactionPolicyEntity compactionPolicyEntity;

    protected CompactionPolicyTupleTranslator(boolean getTuple, CompactionPolicyEntity compactionPolicyEntity) {
        super(getTuple, compactionPolicyEntity.getIndex(), compactionPolicyEntity.payloadPosition());
        this.compactionPolicyEntity = compactionPolicyEntity;
    }

    @Override
    protected CompactionPolicy createMetadataEntityFromARecord(ARecord compactionPolicyRecord) throws AlgebricksException {
        String dataverseCanonicalName = ((AString)compactionPolicyRecord.getValueByPos(this.compactionPolicyEntity.dataverseNameIndex())).getStringValue();
        DataverseName dataverseName = DataverseName.createFromCanonicalForm((String)dataverseCanonicalName);
        int databaseNameIndex = this.compactionPolicyEntity.databaseNameIndex();
        String databaseName = databaseNameIndex >= 0 ? ((AString)compactionPolicyRecord.getValueByPos(databaseNameIndex)).getStringValue() : MetadataUtil.databaseFor((DataverseName)dataverseName);
        String policyName = ((AString)compactionPolicyRecord.getValueByPos(this.compactionPolicyEntity.policyNameIndex())).getStringValue();
        String className = ((AString)compactionPolicyRecord.getValueByPos(this.compactionPolicyEntity.classNameIndex())).getStringValue();
        return new CompactionPolicy(databaseName, dataverseName, policyName, className);
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(CompactionPolicy compactionPolicy) throws HyracksDataException {
        String dataverseCanonicalName = compactionPolicy.getDataverseName().getCanonicalForm();
        this.tupleBuilder.reset();
        if (this.compactionPolicyEntity.databaseNameIndex() >= 0) {
            this.aString.setValue(compactionPolicy.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
            this.tupleBuilder.addFieldEndOffset();
        }
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(compactionPolicy.getPolicyName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(this.compactionPolicyEntity.getRecordType());
        if (this.compactionPolicyEntity.databaseNameIndex() >= 0) {
            this.fieldValue.reset();
            this.aString.setValue(compactionPolicy.getDatabaseName());
            this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
            this.recordBuilder.addField(this.compactionPolicyEntity.databaseNameIndex(), (IValueReference)this.fieldValue);
        }
        this.fieldValue.reset();
        this.aString.setValue(dataverseCanonicalName);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.compactionPolicyEntity.dataverseNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(compactionPolicy.getPolicyName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.compactionPolicyEntity.policyNameIndex(), (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(compactionPolicy.getClassName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(this.compactionPolicyEntity.classNameIndex(), (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }
}

