/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.lifecycle;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponent;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponentManager;
import org.apache.hyracks.util.ExitUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LifeCycleComponentManager
implements ILifeCycleComponentManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<ILifeCycleComponent> components = new ArrayList<ILifeCycleComponent>();
    private boolean stopInitiated = false;
    private boolean stopped = false;
    private String dumpPath;
    private boolean configured = false;

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        try {
            LOGGER.fatal("Uncaught Exception from thread {}; halting", (Object)t.getName(), (Object)e);
        }
        finally {
            ExitUtil.halt((int)11);
        }
    }

    @Override
    public synchronized void register(ILifeCycleComponent component) {
        this.components.add(component);
    }

    @Override
    public void startAll() {
        for (ILifeCycleComponent component : this.components) {
            component.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopAll(boolean dumpState) throws IOException {
        if (this.stopped) {
            LOGGER.info("Lifecycle management was already stopped");
            return;
        }
        this.stopped = true;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Attempting to stop " + this);
        }
        if (this.stopInitiated) {
            LOGGER.info("Stop already in progress");
            return;
        }
        if (!this.configured) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Lifecycle management not configured " + this);
            }
            return;
        }
        this.stopInitiated = true;
        LOGGER.error("Stopping instance");
        FileOutputStream componentDumpStream = null;
        String componentDumpPath = null;
        for (int index = this.components.size() - 1; index >= 0; --index) {
            ILifeCycleComponent component = this.components.get(index);
            try {
                if (dumpState) {
                    componentDumpPath = this.dumpPath + File.separator + component.getClass().getName() + "-coredump";
                    File f = new File(componentDumpPath);
                    File parentDir = new File(f.getParent());
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    componentDumpStream = new FileOutputStream(f);
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Stopping component instance " + component.getClass().getName() + "; dump state: " + dumpState + ", dump path: " + componentDumpPath);
                }
                component.stop(dumpState, componentDumpStream);
                continue;
            }
            catch (Exception e) {
                LOGGER.log(Level.ERROR, "Exception in stopping component " + component.getClass().getName(), (Throwable)e);
                continue;
            }
            finally {
                if (componentDumpStream != null) {
                    componentDumpStream.close();
                }
            }
        }
        this.stopInitiated = false;
        this.stopped = true;
    }

    @Override
    public void configure(Map<String, String> configuration) {
        this.dumpPath = configuration.get("DUMP_PATH");
        if (this.dumpPath == null) {
            this.dumpPath = System.getProperty("user.dir");
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("dump path not configured. Using current directory " + this.dumpPath);
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("LifecycleComponentManager configured " + this);
        }
        this.configured = true;
    }

    @Override
    public String getDumpPath() {
        return this.dumpPath;
    }

    @Override
    public void dumpState(OutputStream os) throws IOException {
        for (int index = this.components.size() - 1; index >= 0; --index) {
            ILifeCycleComponent component = this.components.get(index);
            component.dumpState(os);
        }
    }

    public boolean stoppedAll() {
        return this.stopped;
    }

    public static final class Config {
        public static final String DUMP_PATH_KEY = "DUMP_PATH";
    }
}

