/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.AvroRuntimeException;

public class NettyTransportCodec {

    public static class NettyFrameDecoder
    extends ByteToMessageDecoder {
        private boolean packHeaderRead = false;
        private int listSize;
        private NettyDataPack dataPack;
        private final long maxMem = Runtime.getRuntime().maxMemory();
        private static final long SIZEOF_REF = 8L;

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            if (!in.isReadable()) {
                return;
            }
            if (!this.packHeaderRead) {
                if (this.decodePackHeader(ctx, in)) {
                    this.packHeaderRead = true;
                }
            } else if (this.decodePackBody(ctx, in)) {
                this.packHeaderRead = false;
                out.add(this.dataPack);
            }
        }

        private boolean decodePackHeader(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
            if (buffer.readableBytes() < 8) {
                return false;
            }
            int serial = buffer.readInt();
            int listSize = buffer.readInt();
            if ((double)((long)listSize * 8L) > 0.1 * (double)this.maxMem) {
                throw new AvroRuntimeException("Excessively large list allocation request detected: " + listSize + " items! Connection closed.");
            }
            this.listSize = listSize;
            this.dataPack = new NettyDataPack(serial, new ArrayList<ByteBuffer>(listSize));
            return true;
        }

        private boolean decodePackBody(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
            if (buffer.readableBytes() < 4) {
                return false;
            }
            buffer.markReaderIndex();
            int length = buffer.readInt();
            if (buffer.readableBytes() < length) {
                buffer.resetReaderIndex();
                return false;
            }
            ByteBuffer bb = ByteBuffer.allocate(length);
            buffer.readBytes(bb);
            ((Buffer)bb).flip();
            this.dataPack.getDatas().add(bb);
            return this.dataPack.getDatas().size() == this.listSize;
        }
    }

    public static class NettyFrameEncoder
    extends MessageToMessageEncoder<NettyDataPack> {
        protected void encode(ChannelHandlerContext ctx, NettyDataPack dataPack, List<Object> out) throws Exception {
            List<ByteBuffer> origs = dataPack.getDatas();
            ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(origs.size() * 2 + 1);
            bbs.add(this.getPackHeader(dataPack));
            for (ByteBuffer b : origs) {
                bbs.add(this.getLengthHeader(b));
                bbs.add(b);
            }
            out.add(Unpooled.wrappedBuffer((ByteBuffer[])bbs.toArray(new ByteBuffer[0])));
        }

        private ByteBuffer getPackHeader(NettyDataPack dataPack) {
            ByteBuffer header = ByteBuffer.allocate(8);
            header.putInt(dataPack.getSerial());
            header.putInt(dataPack.getDatas().size());
            ((Buffer)header).flip();
            return header;
        }

        private ByteBuffer getLengthHeader(ByteBuffer buf) {
            ByteBuffer header = ByteBuffer.allocate(4);
            header.putInt(buf.limit());
            ((Buffer)header).flip();
            return header;
        }
    }

    public static class NettyDataPack {
        private int serial;
        private List<ByteBuffer> datas;

        public NettyDataPack() {
        }

        public NettyDataPack(int serial, List<ByteBuffer> datas) {
            this.serial = serial;
            this.datas = datas;
        }

        public void setSerial(int serial) {
            this.serial = serial;
        }

        public int getSerial() {
            return this.serial;
        }

        public void setDatas(List<ByteBuffer> datas) {
            this.datas = datas;
        }

        public List<ByteBuffer> getDatas() {
            return this.datas;
        }
    }
}

