/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.perf.test.generic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.perf.test.BasicState;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

public class GenericWithPromotionTest {
    private static final String RECORD_SCHEMA = "{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"double\" },\n{ \"name\": \"f2\", \"type\": \"double\" },\n{ \"name\": \"f3\", \"type\": \"double\" },\n{ \"name\": \"f4\", \"type\": \"int\" },\n{ \"name\": \"f5\", \"type\": \"int\" },\n{ \"name\": \"f6\", \"type\": \"int\" }\n] }";
    private static final String RECORD_SCHEMA_WITH_PROMOTION = "{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"double\" },\n{ \"name\": \"f2\", \"type\": \"double\" },\n{ \"name\": \"f3\", \"type\": \"double\" },\n{ \"name\": \"f4\", \"type\": \"long\" },\n{ \"name\": \"f5\", \"type\": \"long\" },\n{ \"name\": \"f6\", \"type\": \"long\" }\n] }";

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public void decode(Blackhole blackhole, TestStateDecode state) throws Exception {
        Decoder d = state.decoder;
        GenericDatumReader reader = new GenericDatumReader(state.writerSchema, state.readerSchema);
        for (int i = 0; i < state.getBatchSize(); ++i) {
            blackhole.consume(reader.read(null, d));
        }
    }

    @State(value=Scope.Thread)
    public static class TestStateDecode
    extends BasicState {
        private final Schema readerSchema = new Schema.Parser().parse("{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"double\" },\n{ \"name\": \"f2\", \"type\": \"double\" },\n{ \"name\": \"f3\", \"type\": \"double\" },\n{ \"name\": \"f4\", \"type\": \"long\" },\n{ \"name\": \"f5\", \"type\": \"long\" },\n{ \"name\": \"f6\", \"type\": \"long\" }\n] }");
        private final Schema writerSchema = new Schema.Parser().parse("{ \"type\": \"record\", \"name\": \"R\", \"fields\": [\n{ \"name\": \"f1\", \"type\": \"double\" },\n{ \"name\": \"f2\", \"type\": \"double\" },\n{ \"name\": \"f3\", \"type\": \"double\" },\n{ \"name\": \"f4\", \"type\": \"int\" },\n{ \"name\": \"f5\", \"type\": \"int\" },\n{ \"name\": \"f6\", \"type\": \"int\" }\n] }");
        private byte[] testData;
        private Decoder decoder;

        @Setup(value=Level.Trial)
        public void doSetupTrial() throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Encoder encoder = super.newEncoder(true, (OutputStream)baos);
            GenericDatumWriter writer = new GenericDatumWriter(this.writerSchema);
            Random r = super.getRandom();
            for (int i = 0; i < this.getBatchSize(); ++i) {
                GenericData.Record rec = new GenericData.Record(this.writerSchema);
                rec.put(0, (Object)r.nextDouble());
                rec.put(1, (Object)r.nextDouble());
                rec.put(2, (Object)r.nextDouble());
                rec.put(3, (Object)r.nextInt());
                rec.put(4, (Object)r.nextInt());
                rec.put(5, (Object)r.nextInt());
                writer.write((Object)rec, encoder);
            }
            encoder.flush();
            this.testData = baos.toByteArray();
        }

        @Setup(value=Level.Invocation)
        public void doSetupInvocation() throws Exception {
            this.decoder = super.newDecoder(this.testData);
        }
    }
}

