/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.profile.PerfSupport;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.TextResult;
import org.openjdk.jmh.util.FileUtils;
import org.openjdk.jmh.util.TempFile;
import org.openjdk.jmh.util.Utils;

public final class LinuxPerfC2CProfiler
implements ExternalProfiler {
    protected final TempFile perfBinData;

    public LinuxPerfC2CProfiler() throws ProfilerException {
        Collection<String> failMsg = Utils.tryWith(PerfSupport.PERF_EXEC, "c2c", "record", "echo", "1");
        if (!failMsg.isEmpty()) {
            throw new ProfilerException(failMsg.toString());
        }
        try {
            this.perfBinData = FileUtils.weakTempFile("perf-c2c-bin");
        }
        catch (IOException e) {
            throw new ProfilerException(e);
        }
    }

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        long delay = TimeUnit.NANOSECONDS.toMillis((long)params.getWarmup().getCount() * params.getWarmup().getTime().convertTo(TimeUnit.NANOSECONDS)) + TimeUnit.SECONDS.toMillis(1L);
        return Arrays.asList("perf", "c2c", "record", "-o", this.perfBinData.getAbsolutePath(), "--", "--delay", String.valueOf(delay));
    }

    @Override
    public Collection<String> addJVMOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    @Override
    public void beforeTrial(BenchmarkParams params) {
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        try {
            Process process = new ProcessBuilder("perf", "c2c", "report", "--stats", "-i", this.perfBinData.getAbsolutePath()).redirectErrorStream(true).start();
            Collection<String> lines = FileUtils.readAllLines(process.getInputStream());
            String out = Utils.join(lines, System.lineSeparator());
            return Collections.singleton(new TextResult(out, "perfc2c"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean allowPrintOut() {
        return false;
    }

    @Override
    public boolean allowPrintErr() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Linux perf c2c profiler";
    }
}

