/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class WorkerThreadFactories {
    WorkerThreadFactories() {
    }

    static ThreadFactory platformWorkerFactory(String prefix) {
        return new PlatformThreadFactory(prefix);
    }

    static ThreadFactory virtualWorkerFactory(String prefix) {
        try {
            Method m = Class.forName("java.lang.Thread").getMethod("ofVirtual", new Class[0]);
            Object threadBuilder = m.invoke(null, new Object[0]);
            Class<?> threadBuilderClazz = Class.forName("java.lang.Thread$Builder");
            m = threadBuilderClazz.getMethod("name", String.class, Long.TYPE);
            m.invoke(threadBuilder, prefix + "-jmh-worker-", 1L);
            m = threadBuilderClazz.getMethod("factory", new Class[0]);
            return (ThreadFactory)m.invoke(threadBuilder, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | NullPointerException | InvocationTargetException e) {
            throw new RuntimeException("Cannot instantiate VirtualThreadFactory", e);
        }
    }

    static class PlatformThreadFactory
    implements ThreadFactory {
        private final AtomicInteger counter = new AtomicInteger();
        private final String prefix;
        private final ThreadFactory factory;

        public PlatformThreadFactory(String prefix) {
            this.prefix = prefix;
            this.factory = Executors.defaultThreadFactory();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.factory.newThread(r);
            thread.setName(this.prefix + "-jmh-worker-" + this.counter.incrementAndGet());
            thread.setDaemon(true);
            return thread;
        }
    }
}

