/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.app.event.implement;

import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.util.RuntimeServicesAware;
import org.slf4j.Logger;

public abstract class EscapeReference
implements ReferenceInsertionEventHandler,
RuntimeServicesAware {
    private RuntimeServices rs;
    private String matchRegExp = null;
    protected Logger log;

    protected abstract String escape(Object var1);

    protected abstract String getMatchAttribute();

    @Override
    public Object referenceInsert(Context context, String reference, Object value) {
        if (value == null) {
            return value;
        }
        if (this.matchRegExp == null) {
            return this.escape(value);
        }
        if (reference.matches(this.matchRegExp)) {
            return this.escape(value);
        }
        return value;
    }

    @Override
    public void setRuntimeServices(RuntimeServices rs) {
        this.rs = rs;
        this.log = rs.getLog("event");
        this.matchRegExp = StringUtils.trim(rs.getString(this.getMatchAttribute()));
        if (StringUtils.isEmpty(this.matchRegExp)) {
            this.matchRegExp = null;
        }
        if (this.matchRegExp != null) {
            try {
                "".matches(this.matchRegExp);
            }
            catch (PatternSyntaxException E) {
                this.log.error("Invalid regular expression '{}'. No escaping will be performed.", (Object)this.matchRegExp, (Object)E);
                this.matchRegExp = null;
            }
        }
    }

    protected RuntimeServices getRuntimeServices() {
        return this.rs;
    }
}

