/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.IncludeEventHandler;
import org.apache.velocity.app.event.InvalidReferenceEventHandler;
import org.apache.velocity.app.event.MethodExceptionEventHandler;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapterImpl;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.ParserConfiguration;
import org.apache.velocity.runtime.ParserPool;
import org.apache.velocity.runtime.RuntimeConstants;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.VelocimacroFactory;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.Macro;
import org.apache.velocity.runtime.directive.Scope;
import org.apache.velocity.runtime.directive.StopCommand;
import org.apache.velocity.runtime.parser.LogContext;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.resource.ContentResource;
import org.apache.velocity.runtime.resource.ResourceManager;
import org.apache.velocity.util.ClassUtils;
import org.apache.velocity.util.ExtProperties;
import org.apache.velocity.util.RuntimeServicesAware;
import org.apache.velocity.util.introspection.ChainableUberspector;
import org.apache.velocity.util.introspection.LinkingUberspector;
import org.apache.velocity.util.introspection.Uberspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeInstance
implements RuntimeConstants,
RuntimeServices {
    private VelocimacroFactory vmFactory = null;
    private Logger log = LoggerFactory.getLogger("org.apache.velocity");
    private ParserPool parserPool;
    private boolean initializing = false;
    private volatile boolean initialized = false;
    private ExtProperties overridingProperties = null;
    private Map<String, Directive> runtimeDirectives = new Hashtable<String, Directive>();
    private Map<String, Directive> runtimeDirectivesShared;
    private ExtProperties configuration = new ExtProperties();
    private ResourceManager resourceManager = null;
    private EventCartridge eventCartridge = null;
    private boolean stringInterning = false;
    private String evaluateScopeName = "evaluate";
    private Set<String> enabledScopeControls = new HashSet<String>();
    private Map<Object, Object> applicationAttributes = null;
    private Uberspect uberSpect;
    private String defaultEncoding;
    private RuntimeConstants.SpaceGobbling spaceGobbling;
    private boolean hyphenAllowedInIdentifiers;
    private LogContext logContext;
    private Constructor<? extends Parser> parserConstructor;
    private ParserConfiguration parserConfiguration;

    public RuntimeInstance() {
        this.reset();
    }

    @Override
    public synchronized void init() {
        if (!this.initialized && !this.initializing) {
            try {
                this.log.debug("Initializing Velocity, Calling init()...");
                this.initializing = true;
                this.log.trace("*****************************");
                this.log.debug("Starting Apache Velocity v2.3");
                this.log.trace("RuntimeInstance initializing.");
                this.initializeProperties();
                this.initializeSelfProperties();
                this.initializeLog();
                this.initializeResourceManager();
                this.initializeDirectives();
                this.initializeEventHandlers();
                this.initializeParserPool();
                this.initializeIntrospection();
                this.initializeScopeSettings();
                this.vmFactory.initVelocimacro();
                this.log.trace("RuntimeInstance successfully initialized.");
                this.initialized = true;
                this.initializing = false;
            }
            catch (RuntimeException re) {
                try {
                    this.reset();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                throw re;
            }
            finally {
                this.initializing = false;
            }
        }
    }

    public synchronized void reset() {
        this.configuration = new ExtProperties();
        this.defaultEncoding = null;
        this.evaluateScopeName = "evaluate";
        this.eventCartridge = null;
        this.initialized = false;
        this.initializing = false;
        this.overridingProperties = null;
        this.parserPool = null;
        this.enabledScopeControls.clear();
        this.resourceManager = null;
        this.runtimeDirectives = new Hashtable<String, Directive>();
        this.runtimeDirectivesShared = null;
        this.uberSpect = null;
        this.stringInterning = false;
        this.parserConfiguration = new ParserConfiguration();
        this.vmFactory = new VelocimacroFactory(this);
        this.applicationAttributes = new HashMap<Object, Object>();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    private void requireInitialization() {
        if (!this.initialized) {
            try {
                this.init();
            }
            catch (Exception e) {
                this.log.error("Could not auto-initialize Velocity", e);
                throw new RuntimeException("Velocity could not be initialized!", e);
            }
        }
    }

    private void initializeSelfProperties() {
        this.stringInterning = this.getBoolean("runtime.string_interning", true);
        String im = this.getString("parser.space_gobbling", "lines");
        try {
            this.spaceGobbling = RuntimeConstants.SpaceGobbling.valueOf(im.toUpperCase(Locale.ROOT));
        }
        catch (NoSuchElementException nse) {
            this.spaceGobbling = RuntimeConstants.SpaceGobbling.LINES;
        }
        this.hyphenAllowedInIdentifiers = this.getBoolean("parser.allow_hyphen_in_identifiers", false);
    }

    private char getConfiguredCharacter(String configKey, char defaultChar) {
        String configuredChar = this.getString(configKey);
        if (configuredChar != null) {
            if (configuredChar.length() != 1) {
                throw new IllegalArgumentException(String.format("value of '%s' must be a single character string, but is '%s'", configKey, configuredChar));
            }
            return configuredChar.charAt(0);
        }
        return defaultChar;
    }

    private void initializeIntrospection() {
        String[] uberspectors;
        for (String rm : uberspectors = this.configuration.getStringArray("introspector.uberspect.class")) {
            Object o = null;
            try {
                o = ClassUtils.getNewInstance(rm);
            }
            catch (ClassNotFoundException cnfe) {
                String err = "The specified class for Uberspect (" + rm + ") does not exist or is not accessible to the current classloader.";
                this.log.error(err);
                throw new VelocityException(err, cnfe);
            }
            catch (InstantiationException ie) {
                throw new VelocityException("Could not instantiate class '" + rm + "'", ie);
            }
            catch (IllegalAccessException ae) {
                throw new VelocityException("Cannot access class '" + rm + "'", ae);
            }
            if (!(o instanceof Uberspect)) {
                String err = "The specified class for Uberspect (" + rm + ") does not implement " + Uberspect.class.getName() + "; Velocity is not initialized correctly.";
                this.log.error(err);
                throw new VelocityException(err);
            }
            Uberspect u = (Uberspect)o;
            if (u instanceof RuntimeServicesAware) {
                ((RuntimeServicesAware)((Object)u)).setRuntimeServices(this);
            }
            if (this.uberSpect == null) {
                this.uberSpect = u;
                continue;
            }
            if (u instanceof ChainableUberspector) {
                ((ChainableUberspector)u).wrap(this.uberSpect);
                this.uberSpect = u;
                continue;
            }
            this.uberSpect = new LinkingUberspector(this.uberSpect, u);
        }
        if (this.uberSpect == null) {
            String err = "It appears that no class was specified as the Uberspect.  Please ensure that all configuration information is correct.";
            this.log.error(err);
            throw new VelocityException(err);
        }
        this.uberSpect.init();
    }

    private void setDefaultProperties() {
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getClassLoader().getResourceAsStream("org/apache/velocity/runtime/defaults/velocity.properties");
            if (inputStream == null) {
                throw new IOException("Resource not found: org/apache/velocity/runtime/defaults/velocity.properties");
            }
            this.configuration.load(inputStream);
            this.defaultEncoding = this.getString("resource.default_encoding", "UTF-8");
            this.log.debug("Default Properties resource: {}", (Object)"org/apache/velocity/runtime/defaults/velocity.properties");
        }
        catch (IOException ioe) {
            String msg = "Cannot get Velocity Runtime default properties!";
            this.log.error(msg, ioe);
            throw new RuntimeException(msg, ioe);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ioe) {
                String msg = "Cannot close Velocity Runtime default properties!";
                this.log.error(msg, ioe);
                throw new RuntimeException(msg, ioe);
            }
        }
    }

    @Override
    public void setProperty(String key, Object value) {
        if (this.overridingProperties == null) {
            this.overridingProperties = new ExtProperties();
        }
        this.overridingProperties.setProperty(key, value);
    }

    public void setProperties(String fileName) {
        ExtProperties props = null;
        try {
            props = new ExtProperties(fileName);
        }
        catch (IOException e) {
            throw new VelocityException("Error reading properties from '" + fileName + "'", e);
        }
        Enumeration en = props.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            this.setProperty(key, props.get(key));
        }
    }

    public void setProperties(Properties props) {
        Enumeration<Object> en = props.keys();
        while (en.hasMoreElements()) {
            String key = en.nextElement().toString();
            this.setProperty(key, props.get(key));
        }
    }

    @Override
    public void setConfiguration(ExtProperties configuration) {
        if (this.overridingProperties == null) {
            this.overridingProperties = configuration;
        } else if (this.overridingProperties != configuration) {
            this.overridingProperties.combine(configuration);
        }
    }

    @Override
    public void addProperty(String key, Object value) {
        if (this.overridingProperties == null) {
            this.overridingProperties = new ExtProperties();
        }
        this.overridingProperties.addProperty(key, value);
    }

    @Override
    public void clearProperty(String key) {
        if (this.overridingProperties != null) {
            this.overridingProperties.clearProperty(key);
        }
    }

    @Override
    public Object getProperty(String key) {
        Object o = null;
        if (!this.initialized && this.overridingProperties != null) {
            o = this.overridingProperties.get(key);
        }
        if (o == null) {
            o = this.configuration.getProperty(key);
        }
        if (o instanceof String) {
            return StringUtils.trim((String)o);
        }
        return o;
    }

    private void initializeProperties() {
        if (!this.configuration.isInitialized()) {
            this.setDefaultProperties();
        }
        if (this.overridingProperties != null) {
            this.configuration.combine(this.overridingProperties);
        }
    }

    @Override
    public void init(Properties p) {
        this.setConfiguration(ExtProperties.convertProperties(p));
        this.init();
    }

    @Override
    public void init(String configurationFile) {
        this.setProperties(configurationFile);
        this.init();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeResourceManager() {
        Object inst = this.getProperty("resource.manager.instance");
        String rm = this.getString("resource.manager.class");
        if (inst != null) {
            if (ResourceManager.class.isAssignableFrom(inst.getClass())) {
                this.resourceManager = (ResourceManager)inst;
                this.resourceManager.initialize(this);
                return;
            }
            String msg = inst.getClass().getName() + " object set as resource.manager.instance is not a valid org.apache.velocity.runtime.resource.ResourceManager.";
            this.log.error(msg);
            throw new VelocityException(msg);
        }
        if (rm != null && rm.length() > 0) {
            Object o = null;
            try {
                o = ClassUtils.getNewInstance(rm);
            }
            catch (ClassNotFoundException cnfe) {
                String err = "The specified class for ResourceManager (" + rm + ") does not exist or is not accessible to the current classloader.";
                this.log.error(err);
                throw new VelocityException(err, cnfe);
            }
            catch (InstantiationException ie) {
                throw new VelocityException("Could not instantiate class '" + rm + "'", ie);
            }
            catch (IllegalAccessException ae) {
                throw new VelocityException("Cannot access class '" + rm + "'", ae);
            }
            if (!(o instanceof ResourceManager)) {
                String err = "The specified class for ResourceManager (" + rm + ") does not implement " + ResourceManager.class.getName() + "; Velocity is not initialized correctly.";
                this.log.error(err);
                throw new VelocityException(err);
            }
            this.resourceManager = (ResourceManager)o;
            this.resourceManager.initialize(this);
            this.setProperty("resource.manager.instance", this.resourceManager);
            return;
        }
        String err = "It appears that no class or instance was specified as the ResourceManager.  Please ensure that all configuration information is correct.";
        this.log.error(err);
        throw new VelocityException(err);
    }

    private void initializeEventHandlers() {
        String[] invalidReferenceSet;
        String[] includeHandler;
        String[] methodexception;
        this.eventCartridge = new EventCartridge();
        this.eventCartridge.setRuntimeServices(this);
        String[] referenceinsertion = this.configuration.getStringArray("event_handler.reference_insertion.class");
        if (referenceinsertion != null) {
            for (String aReferenceinsertion : referenceinsertion) {
                EventHandler ev = this.initializeSpecificEventHandler(aReferenceinsertion, "event_handler.reference_insertion.class", ReferenceInsertionEventHandler.class);
                if (ev == null) continue;
                this.eventCartridge.addReferenceInsertionEventHandler((ReferenceInsertionEventHandler)ev);
            }
        }
        if ((methodexception = this.configuration.getStringArray("event_handler.method_exception.class")) != null) {
            for (String aMethodexception : methodexception) {
                EventHandler ev = this.initializeSpecificEventHandler(aMethodexception, "event_handler.method_exception.class", MethodExceptionEventHandler.class);
                if (ev == null) continue;
                this.eventCartridge.addMethodExceptionHandler((MethodExceptionEventHandler)ev);
            }
        }
        if ((includeHandler = this.configuration.getStringArray("event_handler.include.class")) != null) {
            for (String anIncludeHandler : includeHandler) {
                EventHandler ev = this.initializeSpecificEventHandler(anIncludeHandler, "event_handler.include.class", IncludeEventHandler.class);
                if (ev == null) continue;
                this.eventCartridge.addIncludeEventHandler((IncludeEventHandler)ev);
            }
        }
        if ((invalidReferenceSet = this.configuration.getStringArray("event_handler.invalid_references.class")) != null) {
            for (String anInvalidReferenceSet : invalidReferenceSet) {
                EventHandler ev = this.initializeSpecificEventHandler(anInvalidReferenceSet, "event_handler.invalid_references.class", InvalidReferenceEventHandler.class);
                if (ev == null) continue;
                this.eventCartridge.addInvalidReferenceEventHandler((InvalidReferenceEventHandler)ev);
            }
        }
    }

    private EventHandler initializeSpecificEventHandler(String classname, String paramName, Class<?> EventHandlerInterface) {
        if (classname != null && classname.length() > 0) {
            Object o = null;
            try {
                o = ClassUtils.getNewInstance(classname);
            }
            catch (ClassNotFoundException cnfe) {
                String err = "The specified class for " + paramName + " (" + classname + ") does not exist or is not accessible to the current classloader.";
                this.log.error(err);
                throw new VelocityException(err, cnfe);
            }
            catch (InstantiationException ie) {
                throw new VelocityException("Could not instantiate class '" + classname + "'", ie);
            }
            catch (IllegalAccessException ae) {
                throw new VelocityException("Cannot access class '" + classname + "'", ae);
            }
            if (!EventHandlerInterface.isAssignableFrom(EventHandlerInterface)) {
                String err = "The specified class for " + paramName + " (" + classname + ") does not implement " + EventHandlerInterface.getName() + "; Velocity is not initialized correctly.";
                this.log.error(err);
                throw new VelocityException(err);
            }
            EventHandler ev = (EventHandler)o;
            if (ev instanceof RuntimeServicesAware) {
                ((RuntimeServicesAware)((Object)ev)).setRuntimeServices(this);
            }
            return ev;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeLog() {
        try {
            Object o = this.getProperty("runtime.log.instance");
            if (o != null) {
                if (!Logger.class.isAssignableFrom(o.getClass())) {
                    String msg = o.getClass().getName() + " object set as runtime.log.instance is not a valid org.slf4j.Logger implementation.";
                    this.log.error(msg);
                    throw new VelocityException(msg);
                }
                this.log = (Logger)o;
            } else {
                o = this.getProperty("runtime.log.name");
                if (o != null) {
                    if (!(o instanceof String)) {
                        String msg = o.getClass().getName() + " object set as runtime.log.name is not a valid string.";
                        this.log.error(msg);
                        throw new VelocityException(msg);
                    }
                    this.log = LoggerFactory.getLogger((String)o);
                }
            }
            boolean trackLocation = this.getBoolean("runtime.log.track_location", false);
            this.logContext = new LogContext(trackLocation);
            return;
        }
        catch (Exception e) {
            throw new VelocityException("Error initializing log: " + e.getMessage(), e);
        }
    }

    private void initializeDirectives() {
        String[] userdirective;
        Properties directiveProperties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getResourceAsStream("/org/apache/velocity/runtime/defaults/directive.properties");
            if (inputStream == null) {
                throw new VelocityException("Error loading directive.properties! Something is very wrong if these properties aren't being located. Either your Velocity distribution is incomplete or your Velocity jar file is corrupted!");
            }
            directiveProperties.load(inputStream);
        }
        catch (IOException ioe) {
            String msg = "Error while loading directive properties!";
            this.log.error(msg, ioe);
            throw new RuntimeException(msg, ioe);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ioe) {
                String msg = "Cannot close directive properties!";
                this.log.error(msg, ioe);
                throw new RuntimeException(msg, ioe);
            }
        }
        Enumeration<Object> directiveClasses = directiveProperties.elements();
        while (directiveClasses.hasMoreElements()) {
            String directiveClass = (String)directiveClasses.nextElement();
            this.loadDirective(directiveClass);
            this.log.debug("Loaded System Directive: {}", (Object)directiveClass);
        }
        for (String anUserdirective : userdirective = this.configuration.getStringArray("runtime.custom_directives")) {
            this.loadDirective(anUserdirective);
            this.log.debug("Loaded User Directive: {}", (Object)anUserdirective);
        }
    }

    public synchronized void addDirective(Directive directive) {
        this.runtimeDirectives.put(directive.getName(), directive);
        this.updateSharedDirectivesMap();
    }

    @Override
    public Directive getDirective(String name) {
        return this.runtimeDirectivesShared.get(name);
    }

    public synchronized void removeDirective(String name) {
        this.runtimeDirectives.remove(name);
        this.updateSharedDirectivesMap();
    }

    private void updateSharedDirectivesMap() {
        this.runtimeDirectivesShared = new HashMap<String, Directive>(this.runtimeDirectives);
    }

    public void loadDirective(String directiveClass) {
        try {
            Object o = ClassUtils.getNewInstance(directiveClass);
            if (!(o instanceof Directive)) {
                String msg = directiveClass + " does not implement " + Directive.class.getName() + "; it cannot be loaded.";
                this.log.error(msg);
                throw new VelocityException(msg);
            }
            Directive directive = (Directive)o;
            this.addDirective(directive);
        }
        catch (Exception e) {
            String msg = "Failed to load Directive: " + directiveClass;
            this.log.error(msg, e);
            throw new VelocityException(msg, e);
        }
    }

    private void initializeParserPool() {
        Object o;
        Class<?> parserClass;
        String parserClassName = this.getString("parser.class", "org.apache.velocity.runtime.parser.StandardParser");
        try {
            parserClass = ClassUtils.getClass(parserClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new VelocityException("parser class not found: " + parserClassName, cnfe);
        }
        try {
            this.parserConstructor = parserClass.getConstructor(RuntimeServices.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new VelocityException("parser class must provide a constructor taking a RuntimeServices argument", nsme);
        }
        String pp = this.getString("parser.pool.class");
        if (pp != null && pp.length() > 0) {
            o = null;
            try {
                o = ClassUtils.getNewInstance(pp);
            }
            catch (ClassNotFoundException cnfe) {
                String err = "The specified class for ParserPool (" + pp + ") does not exist (or is not accessible to the current classloader.";
                this.log.error(err);
                throw new VelocityException(err, cnfe);
            }
            catch (InstantiationException ie) {
                throw new VelocityException("Could not instantiate class '" + pp + "'", ie);
            }
            catch (IllegalAccessException ae) {
                throw new VelocityException("Cannot access class '" + pp + "'", ae);
            }
            if (!(o instanceof ParserPool)) {
                String err = "The specified class for ParserPool (" + pp + ") does not implement " + ParserPool.class + " Velocity not initialized correctly.";
                this.log.error(err);
                throw new VelocityException(err);
            }
        } else {
            String err = "It appears that no class was specified as the ParserPool.  Please ensure that all configuration information is correct.";
            this.log.error(err);
            throw new VelocityException(err);
        }
        this.parserPool = (ParserPool)o;
        this.parserPool.initialize(this);
        Parser parser = this.parserPool.get();
        this.parserConfiguration = new ParserConfiguration();
        this.parserConfiguration.setDollarChar(parser.dollar());
        this.parserConfiguration.setHashChar(parser.hash());
        this.parserConfiguration.setAtChar(parser.at());
        this.parserConfiguration.setAsteriskChar(parser.asterisk());
        this.parserPool.put(parser);
    }

    @Override
    public Parser createNewParser() {
        this.requireInitialization();
        try {
            return this.parserConstructor.newInstance(this);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new VelocityException("could not build new parser class", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleNode parse(Reader reader, Template template) throws ParseException {
        this.requireInitialization();
        Parser parser = this.parserPool.get();
        boolean keepParser = true;
        if (parser == null) {
            this.log.info("Runtime: ran out of parsers. Creating a new one.  Please increment the parser.pool.size property. The current value is too small.");
            parser = this.createNewParser();
            keepParser = false;
        }
        try {
            SimpleNode simpleNode = parser.parse(reader, template);
            return simpleNode;
        }
        finally {
            if (keepParser) {
                parser.resetCurrentTemplate();
                this.parserPool.put(parser);
            }
        }
    }

    private void initializeScopeSettings() {
        ExtProperties scopes = this.configuration.subset("context.scope_control");
        if (scopes != null) {
            Iterator<String> scopeIterator = scopes.getKeys();
            while (scopeIterator.hasNext()) {
                String scope = scopeIterator.next();
                boolean enabled = scopes.getBoolean(scope);
                if (!enabled) continue;
                this.enabledScopeControls.add(scope);
            }
        }
    }

    @Override
    public boolean evaluate(Context context, Writer out, String logTag, String instring) {
        return this.evaluate(context, out, logTag, new StringReader(instring));
    }

    @Override
    public boolean evaluate(Context context, Writer writer, String logTag, Reader reader) {
        if (logTag == null) {
            throw new NullPointerException("logTag (i.e. template name) cannot be null, you must provide an identifier for the content being evaluated");
        }
        SimpleNode nodeTree = null;
        Template t = new Template();
        t.setName(logTag);
        try {
            nodeTree = this.parse(reader, t);
        }
        catch (ParseException pex) {
            throw new ParseErrorException(pex, null);
        }
        catch (TemplateInitException pex) {
            throw new ParseErrorException(pex, null);
        }
        if (nodeTree == null) {
            return false;
        }
        return this.render(context, writer, logTag, nodeTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean render(Context context, Writer writer, String logTag, SimpleNode nodeTree) {
        InternalContextAdapterImpl ica = new InternalContextAdapterImpl(context);
        ica.pushCurrentTemplateName(logTag);
        try {
            try {
                nodeTree.init(ica, this);
            }
            catch (TemplateInitException pex) {
                throw new ParseErrorException(pex, null);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = "RuntimeInstance.render(): init exception for tag = " + logTag;
                this.log.error(msg, e);
                throw new VelocityException(msg, e, this.getLogContext().getStackTrace());
            }
            try {
                String self;
                if (this.isScopeControlEnabled(this.evaluateScopeName)) {
                    Object previous = ica.get(this.evaluateScopeName);
                    context.put(this.evaluateScopeName, new Scope(this, previous));
                }
                if ((self = this.getString("context.self_reference_key")) != null) {
                    context.put(self, context);
                }
                nodeTree.render(ica, writer);
            }
            catch (StopCommand stop) {
                if (!stop.isFor(this)) {
                    throw stop;
                }
                this.log.debug(stop.getMessage());
            }
            catch (IOException e) {
                throw new VelocityException("IO Error in writer: " + e.getMessage(), e, this.getLogContext().getStackTrace());
            }
        }
        finally {
            Object obj;
            ica.popCurrentTemplateName();
            if (this.isScopeControlEnabled(this.evaluateScopeName) && (obj = ica.get(this.evaluateScopeName)) instanceof Scope) {
                Scope scope = (Scope)obj;
                if (scope.getParent() != null) {
                    ica.put(this.evaluateScopeName, scope.getParent());
                } else if (scope.getReplaced() != null) {
                    ica.put(this.evaluateScopeName, scope.getReplaced());
                } else {
                    ica.remove(this.evaluateScopeName);
                }
            }
        }
        return true;
    }

    @Override
    public boolean invokeVelocimacro(String vmName, String logTag, String[] params, Context context, Writer writer) {
        if (vmName == null || context == null || writer == null) {
            String msg = "RuntimeInstance.invokeVelocimacro(): invalid call: vmName, context, and writer must not be null";
            this.log.error(msg);
            throw new NullPointerException(msg);
        }
        if (logTag == null) {
            logTag = vmName;
        }
        if (params == null) {
            params = new String[]{};
        }
        if (!this.isVelocimacro(vmName, null)) {
            String msg = "RuntimeInstance.invokeVelocimacro(): VM '" + vmName + "' is not registered.";
            this.log.error(msg);
            throw new VelocityException(msg, null, this.getLogContext().getStackTrace());
        }
        StringBuilder template = new StringBuilder(String.valueOf(this.parserConfiguration.getHashChar()));
        template.append(vmName);
        template.append("(");
        for (String param : params) {
            template.append(" $");
            template.append(param);
        }
        template.append(" )");
        return this.evaluate(context, writer, logTag, template.toString());
    }

    private String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    @Override
    public Template getTemplate(String name) throws ResourceNotFoundException, ParseErrorException {
        return this.getTemplate(name, null);
    }

    @Override
    public Template getTemplate(String name, String encoding) throws ResourceNotFoundException, ParseErrorException {
        this.requireInitialization();
        if (encoding == null) {
            encoding = this.getDefaultEncoding();
        }
        return (Template)this.resourceManager.getResource(name, 1, encoding);
    }

    @Override
    public ContentResource getContent(String name) throws ResourceNotFoundException, ParseErrorException {
        return this.getContent(name, this.getDefaultEncoding());
    }

    @Override
    public ContentResource getContent(String name, String encoding) throws ResourceNotFoundException, ParseErrorException {
        this.requireInitialization();
        return (ContentResource)this.resourceManager.getResource(name, 2, encoding);
    }

    @Override
    public String getLoaderNameForResource(String resourceName) {
        this.requireInitialization();
        return this.resourceManager.getLoaderNameForResource(resourceName);
    }

    @Override
    public Logger getLog() {
        return this.log;
    }

    @Override
    public Logger getLog(String childNamespace) {
        Logger log = (Logger)this.getProperty("runtime.log.instance");
        if (log == null) {
            String loggerName = this.getString("runtime.log.name", "org.apache.velocity") + "." + childNamespace;
            log = LoggerFactory.getLogger(loggerName);
        }
        return log;
    }

    @Override
    public LogContext getLogContext() {
        return this.logContext;
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.configuration.getString(key, defaultValue);
    }

    @Override
    public Directive getVelocimacro(String vmName, Template renderingTemplate, Template template) {
        return this.vmFactory.getVelocimacro(vmName, renderingTemplate, template);
    }

    @Override
    public boolean addVelocimacro(String name, Node macro, List<Macro.MacroArg> macroArgs, Template definingTemplate) {
        return this.vmFactory.addVelocimacro(this.stringInterning ? name.intern() : name, macro, macroArgs, definingTemplate);
    }

    @Override
    public boolean isVelocimacro(String vmName, Template template) {
        return this.vmFactory.isVelocimacro(this.stringInterning ? vmName.intern() : vmName, template);
    }

    @Override
    public String getString(String key) {
        return StringUtils.trim(this.configuration.getString(key));
    }

    @Override
    public int getInt(String key) {
        return this.configuration.getInt(key);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        return this.configuration.getInt(key, defaultValue);
    }

    @Override
    public boolean getBoolean(String key, boolean def) {
        return this.configuration.getBoolean(key, def);
    }

    @Override
    public ExtProperties getConfiguration() {
        return this.configuration;
    }

    @Override
    public EventCartridge getApplicationEventCartridge() {
        return this.eventCartridge;
    }

    @Override
    public Object getApplicationAttribute(Object key) {
        return this.applicationAttributes.get(key);
    }

    @Override
    public Object setApplicationAttribute(Object key, Object o) {
        return this.applicationAttributes.put(key, o);
    }

    @Override
    public Uberspect getUberspect() {
        return this.uberSpect;
    }

    @Override
    public boolean useStringInterning() {
        return this.stringInterning;
    }

    @Override
    public RuntimeConstants.SpaceGobbling getSpaceGobbling() {
        return this.spaceGobbling;
    }

    @Override
    public boolean isHyphenAllowedInIdentifiers() {
        return this.hyphenAllowedInIdentifiers;
    }

    @Override
    public boolean isScopeControlEnabled(String scopeName) {
        return this.enabledScopeControls.contains(scopeName);
    }

    @Override
    public ParserConfiguration getParserConfiguration() {
        return this.parserConfiguration;
    }
}

