/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.sjavac.server;

import java.io.IOException;
import java.io.PrintStream;
import org.openjdk.tools.javac.main.Main;
import org.openjdk.tools.sjavac.Log;
import org.openjdk.tools.sjavac.server.SjavacServer;
import org.openjdk.tools.sjavac.server.log.LazyInitFileLog;
import org.openjdk.tools.sjavac.server.log.LoggingOutputStream;

public class ServerMain {
    private static LazyInitFileLog errorLog;

    public static int run(String[] stringArray) {
        int n;
        errorLog = new LazyInitFileLog("server.log");
        Log.setLogForCurrentThread(errorLog);
        Log.setLogLevel(Log.Level.ERROR);
        Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> {
            Log.setLogForCurrentThread(errorLog);
            Log.error(throwable);
        });
        System.setOut(new PrintStream(new LoggingOutputStream(System.out, Log.Level.INFO, "[stdout] ")));
        System.setErr(new PrintStream(new LoggingOutputStream(System.err, Log.Level.ERROR, "[stderr] ")));
        if (stringArray.length > 1) {
            Log.error("When spawning a background server, only a single --startserver argument is allowed.");
            return Main.Result.CMDERR.exitCode;
        }
        try {
            SjavacServer sjavacServer = new SjavacServer(stringArray[0]);
            n = sjavacServer.startServer();
        }
        catch (IOException | InterruptedException exception) {
            exception.printStackTrace();
            n = Main.Result.ERROR.exitCode;
        }
        return n;
    }

    public static LazyInitFileLog getErrorLog() {
        return errorLog;
    }
}

