/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.domain;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ComparisonChain;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.typereg.OsgiBundleWithUrl;
import org.apache.brooklyn.rest.domain.TypeSummary;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.text.NaturalOrderComparator;
import org.apache.brooklyn.util.text.VersionComparator;

public class BundleSummary
implements Comparable<BundleSummary> {
    private final String symbolicName;
    private final String version;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private final List<TypeSummary> types = MutableList.of();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Boolean deleteable;
    @JsonIgnore
    private final Map<String, Object> others = MutableMap.of();

    BundleSummary() {
        this.symbolicName = null;
        this.version = null;
        this.deleteable = null;
    }

    public BundleSummary(OsgiBundleWithUrl bundle) {
        this.symbolicName = bundle.getSymbolicName();
        this.version = bundle.getSuppliedVersionString();
        this.deleteable = bundle.getDeleteable();
    }

    @JsonAnyGetter
    public Map<String, Object> getExtraFields() {
        return this.others;
    }

    @JsonAnySetter
    public void setExtraField(String name, Object value) {
        this.others.put(name, value);
    }

    public void addType(TypeSummary type) {
        this.types.add(type);
    }

    @Override
    public int compareTo(BundleSummary o2) {
        BundleSummary o1 = this;
        return ComparisonChain.start().compare((Object)o1.symbolicName, (Object)o2.symbolicName, (Comparator)NaturalOrderComparator.INSTANCE).compare((Object)o2.version, (Object)o1.version, (Comparator)VersionComparator.INSTANCE).result();
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version;
    }

    public List<TypeSummary> getTypes() {
        return this.types;
    }

    public Boolean getDeleteable() {
        return this.deleteable;
    }

    public String toString() {
        return JavaClassNames.cleanSimpleClassName((Object)this) + "[" + this.symbolicName + ":" + this.version + "]";
    }
}

