/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.resolve.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.typereg.BrooklynTypeRegistry;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.resolve.jackson.AsPropertyIfAmbiguous;
import org.apache.brooklyn.core.resolve.jackson.BrooklynJacksonType;
import org.apache.brooklyn.core.typereg.RegisteredTypeLoadingContexts;
import org.apache.brooklyn.util.core.flags.BrooklynTypeNameResolution;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;

public class BrooklynRegisteredTypeJacksonSerialization {
    public static ObjectMapper apply(ObjectMapper mapper, ManagementContext mgmt, boolean allowRegisteredTypes, BrooklynClassLoadingContext loader, boolean allowPojoJavaTypes) {
        mapper.setDefaultTyping((TypeResolverBuilder)new BrtTypeResolverBuilder(mgmt, allowRegisteredTypes, loader, allowPojoJavaTypes));
        SimpleModule module = new SimpleModule();
        if (allowRegisteredTypes) {
            module.setDeserializers((SimpleDeserializers)new RegisteredTypeDeserializers(mgmt));
        }
        mapper.registerModule((Module)module);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    static class BrtTypeResolverBuilder
    extends ObjectMapper.DefaultTypeResolverBuilder {
        private final ManagementContext mgmt;
        private final boolean allowRegisteredTypes;
        private final BrooklynClassLoadingContext loader;
        private final boolean allowPojoJavaTypes;

        public BrtTypeResolverBuilder(ManagementContext mgmt, boolean allowRegisteredTypes, BrooklynClassLoadingContext loader, boolean allowPojoJavaTypes) {
            super(ObjectMapper.DefaultTyping.NON_FINAL, (PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance);
            this.mgmt = mgmt;
            this.init(JsonTypeInfo.Id.CLASS, null);
            this.inclusion(JsonTypeInfo.As.PROPERTY);
            this.typeProperty("type");
            this.allowRegisteredTypes = allowRegisteredTypes;
            this.loader = loader;
            this.allowPojoJavaTypes = allowPojoJavaTypes;
        }

        protected TypeIdResolver idResolver(MapperConfig<?> config, JavaType baseType, PolymorphicTypeValidator subtypeValidator, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
            return new BrooklynRegisteredTypeAndClassNameIdResolver(baseType, config, subtypeValidator, this.mgmt, this.allowRegisteredTypes, this.loader, this.allowPojoJavaTypes);
        }

        public TypeSerializer buildTypeSerializer(SerializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
            if (!this.useForType(baseType)) {
                return null;
            }
            if (baseType.isPrimitive()) {
                return null;
            }
            if (baseType.isCollectionLikeType() || baseType.isMapLikeType()) {
                return null;
            }
            TypeIdResolver idRes = this.idResolver((MapperConfig<?>)config, baseType, this.subTypeValidator((MapperConfig)config), subtypes, true, false);
            return new AsPropertyIfAmbiguous.AsPropertyIfAmbiguousTypeSerializer(idRes, null, this._typeProperty);
        }

        public TypeDeserializer buildTypeDeserializer(DeserializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
            if (!this.useForType(baseType)) {
                return null;
            }
            if (baseType.isPrimitive()) {
                return null;
            }
            PolymorphicTypeValidator subTypeValidator = this.verifyBaseTypeValidity((MapperConfig)config, baseType);
            TypeIdResolver idRes = this.idResolver((MapperConfig<?>)config, baseType, subTypeValidator, subtypes, false, true);
            JavaType defaultImpl = this.defineDefaultImpl(config, baseType);
            return new AsPropertyIfAmbiguous.AsPropertyButNotIfFieldConflictTypeDeserializer(baseType, idRes, this._typeProperty, this._typeIdVisible, defaultImpl, this._includeAs);
        }

        protected JavaType defineDefaultImpl(DeserializationConfig config, JavaType baseType) {
            JavaType result = super.defineDefaultImpl(config, baseType);
            if (result != null) {
                return result;
            }
            if (baseType.isMapLikeType()) {
                return config.constructType(LinkedHashMap.class);
            }
            if (baseType.isCollectionLikeType()) {
                return config.constructType(LinkedList.class);
            }
            return null;
        }
    }

    static class BrooklynRegisteredTypeAndClassNameIdResolver
    extends ClassNameIdResolver
    implements AsPropertyIfAmbiguous.HasBaseType {
        private final ManagementContext mgmt;
        private final boolean allowRegisteredTypes;
        private final BrooklynClassLoadingContext loader;
        private final boolean allowPojoJavaTypes;

        public BrooklynRegisteredTypeAndClassNameIdResolver(JavaType baseType, MapperConfig<?> config, PolymorphicTypeValidator subtypeValidator, ManagementContext mgmt, boolean allowRegisteredTypes, BrooklynClassLoadingContext loader, boolean allowPojoJavaTypes) {
            super(baseType, config.getTypeFactory(), subtypeValidator);
            this.mgmt = mgmt;
            this.allowRegisteredTypes = allowRegisteredTypes;
            this.loader = loader;
            this.allowPojoJavaTypes = allowPojoJavaTypes;
        }

        public JavaType typeFromId(DatabindContext context, String id) throws IOException {
            RegisteredType rt;
            Maybe<Class<?>> builtin = BrooklynTypeNameResolution.getClassForBuiltInTypeName(id);
            if (builtin.isPresent()) {
                return context.constructType((Type)builtin.get());
            }
            if (this.allowRegisteredTypes && this.mgmt != null && (rt = this.mgmt.getTypeRegistry().get(id, RegisteredTypeLoadingContexts.loader(this.loader))) != null) {
                return new BrooklynJacksonType(rt);
            }
            if (this.allowPojoJavaTypes) {
                Maybe fromLoader;
                if (this.loader != null && (fromLoader = this.loader.tryLoadClass(id)).isPresent()) {
                    return context.constructType((Type)fromLoader.get());
                }
                try {
                    return super.typeFromId(context, id);
                }
                catch (IOException e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    try {
                        JavaType result = context.resolveAndValidateSubType(context.constructType(Object.class), id, this._subTypeValidator);
                        if (result != null) {
                            return result;
                        }
                    }
                    catch (Exception e2) {
                        Exceptions.propagateIfFatal((Throwable)e2);
                    }
                    if (id.equals(this.idFromBaseType()) && !id.equals(super.idFromBaseType())) {
                        return this.typeFromId(context, super.idFromBaseType());
                    }
                    throw e;
                }
            }
            if (this._baseType != null && this._baseType.toCanonical().equals(id)) {
                return this._baseType;
            }
            if (id != null && id.startsWith("org.apache.brooklyn.camp.brooklyn.spi.dsl.")) {
                return context.constructType(Object.class);
            }
            if (context instanceof DeserializationContext) {
                return ((DeserializationContext)context).handleUnknownTypeId(this._baseType, id, (TypeIdResolver)this, "no such class found");
            }
            return null;
        }

        @Override
        public JavaType getBaseType() {
            return this._baseType;
        }

        public String idFromBaseType() {
            if (this._baseType instanceof BrooklynJacksonType) {
                return ((BrooklynJacksonType)this._baseType).getTypeName();
            }
            return super.idFromBaseType();
        }
    }

    static class RegisteredTypeDeserializers
    extends SimpleDeserializers {
        private final ManagementContext mgmt;

        public RegisteredTypeDeserializers(ManagementContext mgmt) {
            this.mgmt = mgmt;
        }

        public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
            if (type instanceof BrooklynJacksonType) {
                return new RegisteredTypeDeserializer(this.mgmt, (BrooklynJacksonType)type);
            }
            return super.findBeanDeserializer(type, config, beanDesc);
        }
    }

    static class RegisteredTypeDeserializer<T>
    extends JsonDeserializer<T> {
        private final BrooklynJacksonType type;
        private final ManagementContext mgmt;

        public RegisteredTypeDeserializer(ManagementContext mgmt, BrooklynJacksonType type) {
            this.mgmt = mgmt;
            this.type = type;
        }

        public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            try {
                Object target = this.getEmptyValue(ctxt);
                JsonDeserializer delegate = ctxt.findContextualValueDeserializer(ctxt.constructType(target.getClass()), null);
                return (T)delegate.deserialize(p, ctxt, target);
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }

        public Object getEmptyValue(DeserializationContext ctxt) throws JsonMappingException {
            if (this.mgmt == null) {
                throw new NullPointerException("Requested to deserialize Brooklyn type " + this.type + " without a management context");
            }
            if (this.type.getRegisteredType().getKind().equals((Object)BrooklynTypeRegistry.RegisteredTypeKind.SPEC)) {
                return this.mgmt.getTypeRegistry().createSpec(this.type.getRegisteredType(), null, null);
            }
            return this.mgmt.getTypeRegistry().createBean(this.type.getRegisteredType(), null, null);
        }
    }
}

